/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import java.util.Arrays;

public class VRC7SoundChip
implements ExpansionSoundChip {
    private final EnvState[] modenv_state = new EnvState[6];
    private final EnvState[] carenv_state = new EnvState[6];
    private final int[] vol = new int[6];
    private final int[] freq = new int[6];
    private final int[] octave = new int[6];
    private final int[] instrument = new int[6];
    private final int[] mod = new int[6];
    private final int[] oldmodout = new int[6];
    private final int[] out = new int[6];
    private final boolean[] key = new boolean[6];
    private final boolean[] chSust = new boolean[6];
    private int fmctr = 0;
    private int amctr = 0;
    private final double[] phase = new double[6];
    private final int[] usertone = new int[8];
    private final int[] modenv_vol = new int[6];
    private final int[] carenv_vol = new int[6];
    private final int[][] instdata = new int[][]{this.usertone, {3, 33, 5, 6, 232, 129, 66, 39}, {19, 65, 20, 13, 216, 246, 35, 18}, {17, 17, 8, 8, 250, 178, 32, 18}, {49, 97, 12, 7, 168, 100, 97, 39}, {50, 33, 30, 6, 225, 118, 1, 40}, {2, 1, 6, 0, 163, 226, 244, 244}, {33, 97, 29, 7, 130, 129, 17, 7}, {35, 33, 34, 23, 162, 114, 1, 23}, {53, 17, 37, 0, 64, 115, 114, 1}, {181, 1, 15, 15, 168, 165, 81, 2}, {23, 193, 36, 7, 248, 248, 34, 18}, {113, 35, 17, 6, 101, 116, 24, 22}, {1, 2, 211, 5, 201, 149, 3, 2}, {97, 99, 12, 0, 148, 192, 51, 246}, {33, 114, 13, 0, 193, 213, 86, 6}};
    private static final int[] LOGSIN = VRC7SoundChip.genlogsintbl();
    private static final int[] EXP = VRC7SoundChip.genexptbl();
    private static final int[] AM = VRC7SoundChip.genamtbl();
    private static final double[] MULTIPLIER = new double[]{0.5, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 12.0, 15.0, 15.0};
    private static final double[] VIBRATO = VRC7SoundChip.genvibtbl();
    private static final int[] KEYSCALE = new int[]{0, 1536, 2048, 2368, 2560, 2752, 2880, 3008, 3072, 3200, 3264, 3328, 3392, 3456, 3520, 3584};
    int ch = 0;
    private int s;
    int lpaccum = 0;
    int lpaccum2 = 0;
    private static final int ZEROVOL = 0x800000;
    private static final int MAXVOL = 0;
    private static final int[] ATTACKVAL = new int[]{0, 0, 0, 0, 98, 120, 146, 171, 195, 216, 293, 341, 390, 471, 602, 683, 780, 964, 1168, 1366, 1560, 1927, 2315, 2731, 3075, 3855, 4682, 5461, 6242, 8035, 9364, 10921, 12480, 15423, 18727, 21856, 24960, 30847, 37413, 43713, 51130, 61580, 74991, 87425, 99841, 123161, 149319, 173949, 200870, 241044, 281218, 312464, 337461, 401739, 496266, 562435, 602609, 766957, 937392, 1205218, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF};
    private static final int[] DECAYVAL = new int[]{0, 0, 0, 0, 8, 10, 12, 14, 16, 20, 24, 28, 32, 40, 48, 56, 65, 77, 96, 112, 129, 161, 193, 224, 258, 321, 386, 449, 516, 643, 771, 898, 1032, 1285, 1542, 1796, 2064, 2570, 3084, 3591, 4211, 5268, 6167, 7183, 8255, 10282, 12407, 14360, 16510, 20552, 24668, 28745, 33020, 41154, 49336, 57391, 66169, 82308, 98673, 114783, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859, 132859};

    public VRC7SoundChip() {
        Arrays.fill((Object[])this.modenv_state, (Object)EnvState.CUTOFF);
        Arrays.fill((Object[])this.carenv_state, (Object)EnvState.CUTOFF);
        Arrays.fill(this.modenv_vol, 511);
        Arrays.fill(this.carenv_vol, 511);
    }

    public static int clamp(int a) {
        return a != (a & 0xFF) ? (a < 0 ? 0 : 255) : a;
    }

    private static double[] genvibtbl() {
        double l = 298295.5;
        double f = 6.4;
        int depth = 10;
        double[] tbl = new double[(int)Math.ceil(l / f)];
        for (int x = 0; x < tbl.length; ++x) {
            tbl[x] = (double)depth * VRC7SoundChip.tri(Math.PI * 2 * f * (double)x / l);
        }
        return tbl;
    }

    private static int[] genamtbl() {
        double l = 298295.5;
        double f = 3.7;
        int depth = 128;
        int[] tbl = new int[(int)Math.ceil(l / f)];
        for (int x = 0; x < tbl.length; ++x) {
            tbl[x] = (int)((double)depth * VRC7SoundChip.tri(Math.PI * 2 * f * (double)x / l) + (double)depth);
        }
        return tbl;
    }

    private static double tri(double x) {
        if ((x %= Math.PI * 2) < 1.5707963267948966) {
            return x / Math.PI;
        }
        if (x < 4.71238898038469) {
            return 1.0 - x / Math.PI;
        }
        return x / Math.PI - 2.0;
    }

    private static int[] genlogsintbl() {
        int[] tbl = new int[256];
        for (int i = 0; i < tbl.length; ++i) {
            tbl[i] = (int)Math.round(-Math.log(Math.sin(((double)i + 0.5) * Math.PI / 256.0 / 2.0)) / Math.log(2.0) * 256.0);
        }
        return tbl;
    }

    private static int[] genexptbl() {
        int[] tbl = new int[256];
        for (int i = 0; i < tbl.length; ++i) {
            tbl[i] = (int)Math.round((Math.pow(2.0, (double)i / 256.0) - 1.0) * 1024.0);
        }
        return tbl;
    }

    @Override
    public final void write(int register, int data) {
        switch (register) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.usertone[register & 7] = data;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                int n = register - 16;
                this.freq[n] = this.freq[n] & 0xF00 | data;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                int m = register - 32;
                this.octave[m] = data >> 1 & 7;
                this.freq[m] = this.freq[m] & 0xFF | (data & 1) << 8;
                if ((data & 0x10) != 0 && !this.key[m]) {
                    this.carenv_state[m] = EnvState.CUTOFF;
                    this.modenv_state[m] = EnvState.CUTOFF;
                }
                this.key[m] = (data & 0x10) != 0;
                this.chSust[m] = (data & 0x20) != 0;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                int j = register - 48;
                this.vol[j] = data & 0xF;
                this.instrument[j] = data >> 4 & 0xF;
                break;
            }
        }
    }

    @Override
    public final void clock(int cycle) {
        for (int i = 0; i < cycle; ++i) {
            this.ch = (this.ch + 1) % 36;
            if (this.ch >= 6) continue;
            this.operate();
        }
    }

    private void operate() {
        int modks;
        this.fmctr = (this.fmctr + 1) % VIBRATO.length;
        this.amctr = (this.amctr + 1) % AM.length;
        int n = this.ch;
        this.phase[n] = this.phase[n] + 0.001953125 * (double)(this.freq[this.ch] << this.octave[this.ch]);
        int n2 = this.ch;
        this.phase[n2] = this.phase[n2] % 1024.0;
        int[] inst = this.instdata[this.instrument[this.ch]];
        int modEnvelope = this.setenvelope(inst, this.modenv_state, this.modenv_vol, this.ch, false) << 2;
        int carEnvelope = this.setenvelope(inst, this.carenv_state, this.carenv_vol, this.ch, true) << 2;
        int keyscale = KEYSCALE[this.freq[this.ch] >> 5] - 512 * (7 - this.octave[this.ch]);
        if (keyscale < 0) {
            keyscale = 0;
        }
        modks = (modks = inst[2] >> 6) == 0 ? 0 : keyscale >> 3 - modks;
        int carks = inst[3] >> 6;
        carks = carks == 0 ? 0 : keyscale >> 3 - carks;
        int fb = ~inst[3] & 7;
        double modVibrato = (inst[0] & 0x40) != 0 ? VIBRATO[this.fmctr] * (double)(1 << this.octave[this.ch]) : 0.0;
        double modFreqMultiplier = MULTIPLIER[inst[0] & 0xF];
        int modFeedback = fb == 7 ? 0 : this.mod[this.ch] + this.oldmodout[this.ch] >> 2 + fb;
        int mod_f = modFeedback + (int)(modVibrato + modFreqMultiplier * this.phase[this.ch]);
        int modVol = (inst[2] & 0x3F) * 32;
        int modAM = (inst[0] & 0x80) != 0 ? AM[this.amctr] : 0;
        boolean modRectify = (inst[3] & 8) != 0;
        this.mod[this.ch] = this.operator(mod_f, modVol + modEnvelope + modks + modAM, modRectify) << 2;
        this.oldmodout[this.ch] = this.mod[this.ch];
        double carVibrato = (inst[1] & 0x40) != 0 ? VIBRATO[this.fmctr] * (double)(this.freq[this.ch] << this.octave[this.ch]) / 512.0 : 0.0;
        double carFreqMultiplier = MULTIPLIER[inst[1] & 0xF];
        int carFeedback = this.mod[this.ch] + this.oldmodout[this.ch] >> 1;
        int car_f = carFeedback + (int)(carVibrato + carFreqMultiplier * this.phase[this.ch]);
        int carVol = this.vol[this.ch] * 128;
        int carAM = (inst[1] & 0x80) != 0 ? AM[this.amctr] : 0;
        boolean carRectify = (inst[3] & 0x10) != 0;
        this.out[this.ch] = this.operator(car_f, carVol + carEnvelope + carks + carAM, carRectify) << 2;
        this.outputSample(this.ch);
    }

    private int operator(int phase, int gain, boolean rectify) {
        return this.exp(this.logsin(phase, rectify) + gain);
    }

    private int exp(int val) {
        if (val > 8191) {
            val = 8191;
        }
        int mantissa = EXP[-val & 0xFF];
        int exponent = -val >> 8;
        return (mantissa + 1024 >> -exponent) * this.s;
    }

    private int logsin(int x, boolean rectify) {
        switch (x >> 8 & 3) {
            case 0: {
                this.s = 1;
                return LOGSIN[x & 0xFF];
            }
            case 1: {
                this.s = 1;
                return LOGSIN[255 - (x & 0xFF)];
            }
            case 2: {
                this.s = rectify ? 0 : -1;
                return LOGSIN[x & 0xFF];
            }
        }
        this.s = rectify ? 0 : -1;
        return LOGSIN[255 - (x & 0xFF)];
    }

    private void outputSample(int ch) {
        int sample = this.out[ch] * 24;
        this.lpaccum -= (sample += this.lpaccum) >> 2;
        int j = this.lpaccum;
        this.lpaccum2 -= (j += this.lpaccum2) >> 2;
    }

    @Override
    public final int getval() {
        return this.lpaccum2;
    }

    private int setenvelope(int[] instrument, EnvState[] state, int[] vol, int ch, boolean isCarrier) {
        boolean keyscaleRate = (instrument[isCarrier ? 1 : 0] & 0x10) != 0;
        int ksrShift = keyscaleRate ? (this.octave[ch] << 1) + (this.freq[ch] >> 8) : this.octave[ch] >> 1;
        switch (state[ch]) {
            default: {
                if (vol[ch] < 0x800000) {
                    int n = ch;
                    vol[n] = vol[n] + 16384;
                    break;
                }
                vol[ch] = 0x800000;
                if (!this.key[ch]) break;
                state[ch] = EnvState.ATTACK;
                this.phase[ch] = 0.0;
                break;
            }
            case ATTACK: {
                if (vol[ch] > 8) {
                    int n = ch;
                    vol[n] = vol[n] - ATTACKVAL[(instrument[isCarrier ? 5 : 4] >> 4) * 4 + ksrShift];
                } else {
                    state[ch] = EnvState.DECAY;
                }
                if (this.key[ch]) break;
                state[ch] = EnvState.RELEASE;
                break;
            }
            case DECAY: {
                if (vol[ch] < (instrument[isCarrier ? 7 : 6] >> 4) * 524288) {
                    int n = ch;
                    vol[n] = vol[n] + DECAYVAL[(instrument[isCarrier ? 5 : 4] & 0xF) * 4 + ksrShift];
                } else {
                    state[ch] = EnvState.RELEASE;
                }
                if (this.key[ch]) break;
                state[ch] = EnvState.RELEASE;
                break;
            }
            case RELEASE: {
                boolean d5 = (instrument[isCarrier ? 1 : 0] & 0x20) != 0;
                boolean SUS = this.chSust[ch];
                if (this.key[ch]) {
                    if (d5) break;
                    int n = ch;
                    vol[n] = vol[n] + DECAYVAL[(instrument[isCarrier ? 7 : 6] & 0xF) * 4 + ksrShift];
                    break;
                }
                if (d5) {
                    if (SUS) {
                        int n = ch;
                        vol[n] = vol[n] + DECAYVAL[20 + ksrShift];
                        break;
                    }
                    int n = ch;
                    vol[n] = vol[n] + DECAYVAL[(instrument[isCarrier ? 7 : 6] & 0xF) * 4 + ksrShift];
                    break;
                }
                if (SUS) {
                    int n = ch;
                    vol[n] = vol[n] + DECAYVAL[20 + ksrShift];
                    break;
                }
                int n = ch;
                vol[n] = vol[n] + DECAYVAL[28 + ksrShift];
            }
        }
        if (vol[ch] < 0) {
            vol[ch] = 0;
        }
        if (vol[ch] > 0x800000) {
            vol[ch] = 0x800000;
        }
        if (state[ch] == EnvState.ATTACK) {
            int output = 0x800000 - (int)(8388608.0 * Math.log(0x800000 - vol[ch]) / Math.log(8388608.0));
            return output >> 14;
        }
        return vol[ch] >> 14;
    }

    private static enum EnvState {
        CUTOFF,
        ATTACK,
        DECAY,
        RELEASE;

    }
}

