/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Action52Mapper
extends Mapper {
    int[] ram = new int[4];
    int prgchip = 0;
    int prgpage = 0;
    int chrpage = 0;
    boolean prgmode = false;

    @Override
    public void loadrom() throws BadMapperException {
        super.loadrom();
        this.cartWrite(32768, 0);
    }

    @Override
    public final void cartWrite(int addr, int data) {
        block11: {
            block10: {
                if (addr > 24575) break block10;
                this.ram[addr & 3] = data & 0xF;
                break block11;
            }
            if (addr < 32768) break block11;
            this.chrpage = ((addr & 0xF) << 2) + (data & 3);
            this.prgmode = (addr & 0x20) != 0;
            this.prgpage = addr >> 6 & 0x1F;
            this.prgchip = addr >> 11 & 3;
            this.setmirroring((addr & 0x2000) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
            for (int i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (this.chrpage * 8 + i) % this.chrsize;
            }
            int off = 0;
            switch (this.prgchip) {
                case 0: {
                    off = 0;
                    break;
                }
                case 1: {
                    off = 524288;
                    break;
                }
                case 3: {
                    off = 0x100000;
                    break;
                }
                default: {
                    System.err.println("Who knows.");
                }
            }
            if (this.prgmode) {
                for (int i = 0; i < 16; ++i) {
                    this.prg_map[i] = (1024 * (16 * this.prgpage + i) + off) % this.prgsize;
                    this.prg_map[i + 16] = (1024 * (16 * this.prgpage + i) + off) % this.prgsize;
                }
            } else {
                for (int i = 0; i < 32; ++i) {
                    this.prg_map[i] = (1024 * (32 * (this.prgpage >> 1) + i) + off) % this.prgsize;
                }
            }
        }
    }

    @Override
    public final int cartRead(int addr) {
        if (addr >= 32768) {
            return this.prg[this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF)];
        }
        if (addr < 24576) {
            return this.ram[addr & 3] & 0xF;
        }
        return addr >> 8;
    }

    @Override
    public void reset() {
        this.cartWrite(32768, 0);
    }
}

