/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class MMC1Mapper
extends Mapper {
    private int mmc1shift = 0;
    private int mmc1latch = 0;
    private int mmc1ctrl = 12;
    private int mmc1chr0 = 0;
    private int mmc1chr1 = 0;
    private int mmc1prg = 0;
    private boolean soromlatch = false;
    private double cpucycleprev = 0.0;
    private long framecountprev = 0L;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
        this.setbanks();
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if ((double)this.cpu.clocks == this.cpucycleprev && this.cpuram.apu.nes.framecount == this.framecountprev) {
            return;
        }
        this.framecountprev = this.cpuram.apu.nes.framecount;
        this.cpucycleprev = this.cpu.clocks;
        if ((data & 0x80) != 0) {
            this.mmc1shift = 0;
            this.mmc1latch = 0;
            this.mmc1ctrl |= 0xC;
            this.setbanks();
            return;
        }
        this.mmc1shift = (this.mmc1shift >> 1) + (data & 1) * 16;
        ++this.mmc1latch;
        if (this.mmc1latch < 5) {
            return;
        }
        if (addr >= 32768 && addr <= 40959) {
            Mapper.MirrorType mirtype;
            this.mmc1ctrl = this.mmc1shift & 0x1F;
            switch (this.mmc1ctrl & 3) {
                case 0: {
                    mirtype = Mapper.MirrorType.SS_MIRROR0;
                    break;
                }
                case 1: {
                    mirtype = Mapper.MirrorType.SS_MIRROR1;
                    break;
                }
                case 2: {
                    mirtype = Mapper.MirrorType.V_MIRROR;
                    break;
                }
                default: {
                    mirtype = Mapper.MirrorType.H_MIRROR;
                }
            }
            this.setmirroring(mirtype);
        } else if (addr >= 40960 && addr <= 49151) {
            this.mmc1chr0 = this.mmc1shift & 0x1F;
            if (this.prgsize > 262144) {
                this.mmc1chr0 &= 0xF;
                this.soromlatch = (this.mmc1shift & 0x10) != 0;
            }
        } else if (addr >= 49152 && addr <= 57343) {
            this.mmc1chr1 = this.mmc1shift & 0x1F;
            if (this.prgsize > 262144) {
                this.mmc1chr1 &= 0xF;
            }
        } else if (addr >= 57344 && addr <= 65535) {
            this.mmc1prg = this.mmc1shift & 0xF;
        }
        this.setbanks();
        this.mmc1latch = 0;
        this.mmc1shift = 0;
    }

    private void setbanks() {
        int i;
        if ((this.mmc1ctrl & 0x10) != 0) {
            for (i = 0; i < 4; ++i) {
                this.chr_map[i] = 1024 * (i + 4 * this.mmc1chr0) % this.chrsize;
            }
            for (i = 0; i < 4; ++i) {
                this.chr_map[i + 4] = 1024 * (i + 4 * this.mmc1chr1) % this.chrsize;
            }
        } else {
            for (i = 0; i < 8; ++i) {
                this.chr_map[i] = 1024 * (i + 8 * (this.mmc1chr0 >> 1)) % this.chrsize;
            }
        }
        if ((this.mmc1ctrl & 8) == 0) {
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = (1024 * i + 32768 * (this.mmc1prg >> 1)) % this.prgsize;
            }
        } else if ((this.mmc1ctrl & 4) == 0) {
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * i;
            }
            for (i = 0; i < 16; ++i) {
                this.prg_map[i + 16] = (1024 * i + 16384 * this.mmc1prg) % this.prgsize;
            }
        } else {
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = (1024 * i + 16384 * this.mmc1prg) % this.prgsize;
            }
            for (i = 1; i <= 16; ++i) {
                this.prg_map[32 - i] = this.prgsize - 1024 * i;
                if (this.prg_map[32 - i] <= 262144) continue;
                int n = 32 - i;
                this.prg_map[n] = this.prg_map[n] - 262144;
            }
        }
        if (this.soromlatch && this.prgsize > 262144) {
            i = 0;
            while (i < this.prg_map.length) {
                int n = i++;
                this.prg_map[n] = this.prg_map[n] + 262144;
            }
        }
    }
}

