/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper200
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public int cartRead(int addr) {
        if (addr < 16384) {
            return this.prg[this.prg_map[(addr & 0x3FFF) >> 10] + (addr & 0x3FF)];
        }
        return this.prg[this.prg_map[(addr & 0x3FFF) >> 10] + (addr - 16384 & 0x3FF)];
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        int reg = addr & 7;
        this.setmirroring((data & 8) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * reg) & this.chrsize - 1;
        }
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * (i + 16 * reg) & this.prgsize - 1;
        }
    }
}

