/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper31
extends Mapper {
    public boolean nsfBanking;
    public int[] nsfBanks = new int[]{0, 0, 0, 0, 0, 0, 0, 255};

    @Override
    public void loadrom() throws BadMapperException {
        super.loadrom();
        this.setBanks();
    }

    @Override
    public void cartWrite(int addr, int data) {
        if (addr >= 24576 && addr < 32768) {
            this.prgram[addr & 0x1FFF] = data;
        } else if (addr >= 20480 && addr < 24576) {
            this.nsfBanks[addr & 7] = data;
            this.setBanks();
        } else {
            System.err.println("write to " + utils.hex(addr) + " goes nowhere");
        }
    }

    @Override
    public int cartRead(int addr) {
        if (addr >= 32768) {
            int fuuu = this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF);
            return this.prg[fuuu];
        }
        if (addr >= 24576 && this.hasprgram) {
            return this.prgram[addr & 0x1FFF];
        }
        if (addr >= 20480) {
            return this.nsfBanks[addr & 7];
        }
        System.err.println("reading open bus " + utils.hex(addr));
        return addr >> 8;
    }

    private void setBanks() {
        for (int i = 0; i < this.prg_map.length; ++i) {
            this.prg_map[i] = 4096 * this.nsfBanks[i / 4] + 1024 * (i % 4);
            if (this.prg_map[i] < this.prg.length) continue;
            int n = i;
            this.prg_map[n] = this.prg_map[n] & this.prgsize - 1;
        }
    }
}

