/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.audio.FDSSoundChip;
import com.grapeshot.halfnes.audio.MMC5SoundChip;
import com.grapeshot.halfnes.audio.Namco163SoundChip;
import com.grapeshot.halfnes.audio.Sunsoft5BSoundChip;
import com.grapeshot.halfnes.audio.VRC6SoundChip;
import com.grapeshot.halfnes.audio.VRC7SoundChip;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.mappers.NSFPlayerFont;
import com.grapeshot.halfnes.utils;
import java.util.Arrays;

public class NSFMapper
extends Mapper {
    private int load;
    private int init;
    private int play;
    private int song;
    private int numSongs;
    public boolean nsfBanking;
    public int[] nsfStartBanks = new int[10];
    public int[] nsfBanks = new int[10];
    private int sndchip;
    boolean vrc6 = false;
    boolean vrc7 = false;
    boolean mmc5 = false;
    boolean n163 = false;
    boolean s5b = false;
    boolean hasInitSound = false;
    boolean fds = false;
    private boolean n163autoincrement = false;
    private int n163soundAddr = 0;
    private int mmc5multiplier1;
    private int mmc5multiplier2;
    private int vrc7regaddr = 0;
    private int s5bSoundCommand = 0;
    private Namco163SoundChip n163Audio;
    private VRC6SoundChip vrc6Audio;
    private VRC7SoundChip vrc7Audio;
    private Sunsoft5BSoundChip s5bAudio;
    private MMC5SoundChip mmc5Audio;
    private static final String trackstr = "Track --- / ---          <-B A->";
    private FDSSoundChip fdsAudio;
    int control;
    int prevcontrol;
    int unfinishedcounter = 0;
    int time = 4;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        this.loader.parseHeader();
        this.prgsize = this.loader.prgsize;
        this.mappertype = this.loader.mappertype;
        this.prgoff = this.loader.prgoff;
        for (int i2 = 112; i2 < 120; ++i2) {
            if (this.loader.header[i2] == 0) continue;
            this.nsfBanking = true;
            this.nsfStartBanks[i2 - 112] = this.loader.header[i2];
        }
        this.prgoff = 0;
        this.load = this.loader.header[8] + (this.loader.header[9] << 8);
        this.init = this.loader.header[10] + (this.loader.header[11] << 8);
        this.play = this.loader.header[12] + (this.loader.header[13] << 8);
        this.numSongs = this.loader.header[6] - 1;
        this.song = this.loader.header[7] - 1;
        this.region = this.loader.header[122] == 1 ? Mapper.TVType.PAL : Mapper.TVType.NTSC;
        this.chroff = 0;
        this.chrsize = 0;
        this.scrolltype = Mapper.MirrorType.V_MIRROR;
        this.sndchip = this.loader.header[123];
        if (!this.nsfBanking && this.load < 32768) {
            throw new BadMapperException("NSF with no banking loading low");
        }
        int paddingLen = this.nsfBanking ? this.load & 0xFFF : this.load - 32768;
        this.prg = new int[0x100000];
        System.arraycopy(this.loader.load(this.loader.romlen(), this.prgoff), 0, this.prg, paddingLen, this.loader.romlen());
        this.crc = NSFMapper.crc32(this.prg);
        this.haschrram = true;
        this.chrsize = 8192;
        this.chr = new int[8192];
        this.prg_map = new int[(this.sndchip & 4) != 0 ? 40 : 32];
        if (!this.nsfBanking) {
            for (i = 0; i < 8; ++i) {
                this.nsfStartBanks[i] = i;
            }
        }
        if ((this.sndchip & 4) != 0) {
            this.nsfStartBanks[8] = this.nsfStartBanks[6];
            this.nsfStartBanks[9] = this.nsfStartBanks[7];
        }
        this.chr_map = new int[8];
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
        this.cpuram = new CPURAM(this);
        this.cpu = new CPU(this.cpuram);
        this.ppu = new PPU(this);
        Arrays.fill(this.pput0, 0);
        this.setmirroring(this.scrolltype);
        this.ppu.pal[0] = 63;
        this.ppu.pal[1] = 32 + (int)(this.crc % 12L);
        this.ppu.pal[2] = 32 + (int)(this.crc % 12L);
        this.ppu.pal[3] = 32 + (int)(this.crc % 12L);
        this.chr = NSFPlayerFont.font;
    }

    @Override
    public void init() {
        int i;
        this.nsfBanks = (int[])this.nsfStartBanks.clone();
        this.setBanks();
        for (i = 0; i <= 2047; ++i) {
            this.cpuram.write(i, 0);
        }
        for (i = 16384; i <= 16403; ++i) {
            this.cpuram.write(i, 0);
        }
        this.cpuram.write(16405, 15);
        this.cpuram.write(16407, 64);
        this.cpu.push(255);
        this.cpu.push(250);
        this.cpu.setPC(this.init);
        this.cpu.interrupt = -99999;
        this.cpu.setRegA(this.song);
        if (this.region == Mapper.TVType.PAL) {
            this.cpu.setRegX(1);
        } else {
            this.cpu.setRegX(0);
        }
        for (i = 0; i < 768; ++i) {
            this.pput0[i] = Math.random() > 0.5 ? 47 : 92;
        }
        for (i = 0; i < 96; ++i) {
            this.pput0[i + 800] = this.loader.header[i + 14];
        }
        for (i = 0; i < trackstr.length(); ++i) {
            this.pput0[i + 896] = trackstr.charAt(i);
        }
        if (!this.hasInitSound) {
            this.setSoundChip();
            this.hasInitSound = true;
        }
        if (!this.fds) {
            for (i = 24576; i <= Short.MAX_VALUE; ++i) {
                this.cpuram.write(i, 0);
            }
        }
    }

    @Override
    public void reset() {
        this.song = this.loader.header[7] - 1;
        this.init();
        this.cpu.setPC(this.init);
    }

    @Override
    public void cartWrite(int addr, int data) {
        if (this.n163 && addr == 63488) {
            this.n163autoincrement = (data & 0x80) != 0;
            this.n163soundAddr = data & 0x7F;
        } else if (this.n163 && addr == 18432) {
            this.n163Audio.write(this.n163soundAddr, data);
            if (this.n163autoincrement) {
                ++this.n163soundAddr;
                this.n163soundAddr &= 0x7F;
            }
        } else if (this.s5b && addr == 57344) {
            this.s5bAudio.write(this.s5bSoundCommand, data);
        } else if (this.s5b && addr == 49152) {
            this.s5bSoundCommand = data & 0xF;
        } else if (this.vrc6 && addr >= 45056 && addr <= 45058) {
            this.vrc6Audio.write((addr & 0xF000) + (addr & 3), data);
        } else if (this.vrc6 && addr >= 40960 && addr <= 40962) {
            this.vrc6Audio.write((addr & 0xF000) + (addr & 3), data);
        } else if (this.vrc7 && addr == 36912) {
            this.vrc7Audio.write(this.vrc7regaddr, data);
        } else if (this.vrc7 && addr == 36880) {
            this.vrc7regaddr = data;
        } else if (this.vrc6 && addr >= 36864 && addr <= 36866) {
            this.vrc6Audio.write((addr & 0xF000) + (addr & 3), data);
        } else if (this.fds && this.nsfBanking && addr >= 24576) {
            if (addr < 32768) {
                int fuuu = this.prg_map[(addr - 24576 >> 10) + 32] + (addr & 0x3FF);
                this.prg[fuuu] = data;
            } else {
                int fuuu = this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF);
                this.prg[fuuu] = data;
            }
        } else if (this.fds && !this.nsfBanking && addr >= 24576) {
            if (addr < 32768) {
                this.prgram[addr - 24576] = data;
            } else {
                int fuuu = this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF);
                this.prg[fuuu] = data;
            }
        } else if (addr >= 24576 && addr < 32768) {
            this.prgram[addr & 0x1FFF] = data;
        } else if (addr >= 24568 && addr < 24576) {
            this.nsfBanks[addr - 24568] = data;
            this.setBanks();
        } else if (this.fds && this.nsfBanking && addr == 24566) {
            this.nsfBanks[8] = data;
            this.setBanks();
        } else if (this.fds && this.nsfBanking && addr >= 24567) {
            this.nsfBanks[9] = data;
            this.setBanks();
        } else if (this.mmc5 && addr >= 23552 && addr <= 24565) {
            this.prgram[addr - 23552] = data;
        } else if (this.mmc5 && addr == 20998) {
            this.mmc5multiplier2 = data;
        } else if (this.mmc5 && addr == 20997) {
            this.mmc5multiplier1 = data;
        } else if (this.mmc5 && addr >= 20480 && addr <= 20501) {
            this.mmc5Audio.write(addr - 20480, data);
        } else if (this.fds && addr >= 16448 && addr <= 16530) {
            this.fdsAudio.write(addr, data);
        }
    }

    @Override
    public int cartRead(int addr) {
        if (addr >= 32768) {
            if (addr > 65530) {
                switch (addr) {
                    case 65531: {
                        return 76;
                    }
                    case 65532: {
                        return 251;
                    }
                    case 65533: {
                        return 255;
                    }
                }
                return 0;
            }
            int fuuu = this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF);
            return this.prg[fuuu];
        }
        if (addr >= 24576 && this.hasprgram) {
            if (this.fds && this.nsfBanking) {
                int fuuu = this.prg_map[(addr - 24576 >> 10) + 32] + (addr & 0x3FF);
                return this.prg[fuuu];
            }
            return this.prgram[addr & 0x1FFF];
        }
        if (addr >= 24568) {
            return this.nsfBanks[addr - 24568];
        }
        if (this.fds && this.nsfBanking && addr == 24566) {
            return this.nsfBanks[8];
        }
        if (this.fds && this.nsfBanking && addr == 24567) {
            return this.nsfBanks[9];
        }
        if (this.mmc5 && addr >= 23552) {
            return this.prgram[addr - 23552];
        }
        if (this.mmc5 && addr == 20998) {
            return this.mmc5multiplier1 * this.mmc5multiplier2 >> 8 & 0xFF;
        }
        if (this.mmc5 && addr == 20997) {
            return this.mmc5multiplier1 * this.mmc5multiplier2 & 0xFF;
        }
        if (this.mmc5 && addr == 20501) {
            return this.mmc5Audio.status();
        }
        if (this.n163 && addr == 18432) {
            int retval = this.n163Audio.read(this.n163soundAddr);
            if (this.n163autoincrement) {
                ++this.n163soundAddr;
                this.n163soundAddr &= 0x7F;
            }
            return retval;
        }
        if (this.fds && addr >= 16448 && addr < 16531) {
            return this.fdsAudio.read(addr);
        }
        return addr >> 8;
    }

    @Override
    public void ppuWrite(int addr, int data) {
    }

    @Override
    public void notifyscanline(int scanline) {
        if (scanline == 240) {
            if (this.cpu.PC != 65531) {
                if (this.unfinishedcounter < this.time) {
                    ++this.unfinishedcounter;
                    return;
                }
                if (this.unfinishedcounter == this.time) {
                    ++this.unfinishedcounter;
                }
            } else {
                this.unfinishedcounter = 0;
            }
            this.ppu.write(6, 0);
            this.ppu.write(6, 0);
            this.ppu.write(5, 0);
            this.ppu.write(0, 0);
            this.ppu.write(1, 26);
            this.writeTracks();
            this.prevcontrol = this.control;
            this.control = 0;
            this.cpuram.write(16406, 1);
            this.cpuram.write(16406, 0);
            for (int i = 0; i < 8; ++i) {
                this.control = (this.control << 1) + ((this.cpuram.read(16406) & 3) != 0 ? 1 : 0);
            }
            if ((this.control & 0x80) != 0 && (this.prevcontrol & 0x80) == 0) {
                ++this.song;
                if (this.song > this.numSongs) {
                    this.song = 0;
                }
                this.init();
            } else if ((this.control & 0x40) != 0 && (this.prevcontrol & 0x40) == 0) {
                --this.song;
                if (this.song < 0) {
                    this.song = this.numSongs;
                }
                this.init();
            } else if (this.unfinishedcounter <= this.time) {
                this.cpu.push(this.cpu.PC - 1 >> 8);
                this.cpu.push(this.cpu.PC - 1 & 0xFF);
                this.cpu.setPC(this.play);
            }
        }
    }

    @Override
    public String getrominfo() {
        return "NSF INFO: \nFilename:     " + this.loader.name + "\nSize:     " + this.loader.romlen() / 1024 + " K\nExpansion Sound:  " + this.expSound() + "\nTrack: " + (this.song + 1) + " / " + (this.numSongs + 1) + "\nLoad Address:  " + utils.hex(this.load) + "\nInit Address:  " + utils.hex(this.init) + "\nPlay Address:  " + utils.hex(this.play) + "\nBanking?      " + (this.nsfBanking ? "Yes" : "No") + "\nCRC:          " + utils.hex(this.crc);
    }

    private String expSound() {
        String chips = "";
        if (this.vrc6) {
            chips = chips + "VRC6 ";
        }
        if (this.vrc7) {
            chips = chips + "VRC7 ";
        }
        if (this.n163) {
            chips = chips + "Namco 163 ";
        }
        if (this.mmc5) {
            chips = chips + "MMC5 ";
        }
        if (this.s5b) {
            chips = chips + "Sunsoft 5B ";
        }
        if (this.fds) {
            chips = chips + "FDS ";
        }
        return chips.length() > 0 ? chips : "None";
    }

    private void setBanks() {
        for (int i = 0; i < this.prg_map.length; ++i) {
            this.prg_map[i] = 4096 * this.nsfBanks[i / 4] + 1024 * (i % 4);
            if (this.prg_map[i] < this.prg.length) continue;
            int n = i;
            this.prg_map[n] = this.prg_map[n] % this.prg.length;
        }
    }

    private void setSoundChip() {
        if ((this.sndchip & 1) != 0) {
            this.vrc6 = true;
            this.vrc6Audio = new VRC6SoundChip();
            this.cpuram.apu.addExpnSound(this.vrc6Audio);
        }
        if ((this.sndchip & 2) != 0) {
            this.vrc7 = true;
            this.vrc7Audio = new VRC7SoundChip();
            this.cpuram.apu.addExpnSound(this.vrc7Audio);
        }
        if ((this.sndchip & 4) != 0) {
            this.fds = true;
            this.fdsAudio = new FDSSoundChip();
            this.cpuram.apu.addExpnSound(this.fdsAudio);
        }
        if ((this.sndchip & 8) != 0) {
            this.mmc5 = true;
            this.mmc5Audio = new MMC5SoundChip();
            this.cpuram.apu.addExpnSound(this.mmc5Audio);
        }
        if ((this.sndchip & 0x10) != 0) {
            this.n163 = true;
            this.n163Audio = new Namco163SoundChip();
            this.cpuram.apu.addExpnSound(this.n163Audio);
        }
        if ((this.sndchip & 0x20) != 0) {
            this.s5b = true;
            this.s5bAudio = new Sunsoft5BSoundChip();
            this.cpuram.apu.addExpnSound(this.s5bAudio);
        }
    }

    private void writeTracks() {
        String cur = String.format("%3d / %-3d", this.song + 1, this.numSongs + 1);
        for (int i = 0; i < cur.length(); ++i) {
            this.pput0[i + 896 + 6] = cur.charAt(i);
        }
    }
}

