/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Sunsoft01Mapper
extends Mapper {
    private int lowBank = 0;
    private int highBank = 0;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr >= 24576 && addr < 32768) {
            int i;
            this.lowBank = data & 7;
            this.highBank = data >> 4 & 7;
            for (i = 0; i < 4; ++i) {
                this.chr_map[i] = 1024 * (i + this.lowBank * 4) % this.chrsize;
            }
            for (i = 0; i < 4; ++i) {
                this.chr_map[4 + i] = 1024 * (i + this.highBank * 4) % this.chrsize;
            }
        }
    }
}

