/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.PrefsSingleton;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class PreferencesDialog
extends JDialog {
    private int screenScaling;
    private boolean okClicked = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxNTSC;
    private JCheckBox jCheckBoxNTView;
    private JCheckBox jCheckBoxShowScope;
    private JCheckBox jCheckBoxSleep;
    private JCheckBox jCheckBoxSmoothVideo;
    private JCheckBox jCheckMaintainAspect;
    private JCheckBox jCheckSoundEnable;
    private JCheckBox jCheckSoundFiltering;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JComboBox jRegionBox;
    private JComboBox jSampleRateBox;
    private JSpinner jSpinnerScale;
    private JSlider volumeSlider;

    public PreferencesDialog(Frame parent) {
        super(parent, true);
        Preferences prefs = PrefsSingleton.get();
        this.initComponents();
        this.setTitle("HalfNES Preferences");
        this.jCheckSoundEnable.setSelected(prefs.getBoolean("soundEnable", true));
        this.jCheckSoundFiltering.setSelected(prefs.getBoolean("soundFiltering", true));
        this.jCheckMaintainAspect.setSelected(prefs.getBoolean("maintainAspect", true));
        this.jCheckBoxNTSC.setSelected(prefs.getBoolean("TVEmulation", false));
        this.jCheckBoxNTView.setSelected(prefs.getBoolean("ntView", false));
        this.jCheckBoxShowScope.setSelected(prefs.getBoolean("showScope", false));
        this.jCheckBoxSleep.setSelected(prefs.getBoolean("Sleep", true));
        this.jButtonOK.setActionCommand("OK");
        this.jButtonCancel.setActionCommand("Cancel");
        this.screenScaling = prefs.getInt("screenScaling", 2);
        this.jSpinnerScale.setValue(this.screenScaling);
        this.jSampleRateBox.setSelectedItem(Integer.toString(prefs.getInt("sampleRate", 44100)));
        this.jCheckBoxSmoothVideo.setSelected(prefs.getBoolean("smoothScaling", false));
        this.volumeSlider.setValue(prefs.getInt("outputvol", 13107));
        this.jRegionBox.setSelectedIndex(prefs.getInt("region", 0));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jCheckSoundEnable = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSampleRateBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jCheckMaintainAspect = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.jCheckSoundFiltering = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.volumeSlider = new JSlider();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jCheckBoxNTSC = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.jSpinnerScale = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jCheckBoxSmoothVideo = new JCheckBox();
        this.jCheckBoxSleep = new JCheckBox();
        this.jCheckBoxShowScope = new JCheckBox();
        this.jCheckBoxNTView = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jRegionBox = new JComboBox();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("OptionsDialog");
        this.setResizable(false);
        this.jLabel1.setText("Screen scaling: scale up ");
        this.jCheckSoundEnable.setText("Enable Sound");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jSampleRateBox.setModel(new DefaultComboBoxModel<String>(new String[]{"16000", "24000", "44100", "48000", "96000"}));
        this.jSampleRateBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jSampleRateBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Sample Rate:");
        this.jCheckMaintainAspect.setText("Maintain Aspect Ratio");
        this.jLabel14.setText("Sound:");
        this.jCheckSoundFiltering.setText("Enable Filtering");
        this.jCheckSoundFiltering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckSoundFilteringActionPerformed(evt);
            }
        });
        this.jLabel15.setText("Output Volume:");
        this.volumeSlider.setMajorTickSpacing(8192);
        this.volumeSlider.setMaximum(16384);
        this.volumeSlider.setMinorTickSpacing(4096);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setValue(80);
        this.jLabel17.setText("0");
        this.jLabel18.setText("100");
        this.jCheckBoxNTSC.setText("Use NTSC TV Filter (Experimental)");
        this.jCheckBoxNTSC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckBoxNTSCActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Video options:");
        this.jSpinnerScale.setModel(new SpinnerNumberModel(2, 1, 6, 1));
        this.jLabel20.setText("times");
        this.jCheckBoxSmoothVideo.setText("Use Smooth Scaling");
        this.jCheckBoxSmoothVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckBoxSmoothVideoActionPerformed(evt);
            }
        });
        this.jCheckBoxSleep.setText("Sleep Between Frames");
        this.jCheckBoxSleep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckBoxSleepActionPerformed(evt);
            }
        });
        this.jCheckBoxShowScope.setText("Show Audio Output");
        this.jCheckBoxNTView.setText("Show Nametable Viewer");
        this.jLabel3.setText("Console Region:");
        this.jRegionBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto Detect", "NTSC", "PAL", "Dendy (Hybrid)"}));
        this.jRegionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jRegionBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerScale, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20, -2, 26, -2)).addComponent(this.jLabel19).addComponent(this.jCheckBoxNTSC).addComponent(this.jCheckMaintainAspect).addComponent(this.jCheckBoxSmoothVideo).addComponent(this.jCheckBoxSleep).addComponent(this.jCheckBoxShowScope).addComponent(this.jCheckBoxNTView)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.volumeSlider, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.jCheckSoundEnable).addComponent(this.jCheckSoundFiltering).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSampleRateBox, -2, 83, -2)).addComponent(this.jLabel15).addGroup(layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel18)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRegionBox, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckSoundEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckSoundFiltering).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSampleRateBox, -2, 20, -2)).addGap(3, 3, 3).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel18))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinnerScale, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSmoothVideo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckMaintainAspect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNTSC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSleep).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNTView))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jRegionBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if ("Cancel".equals(evt.getActionCommand())) {
            this.setVisible(false);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Preferences prefs = PrefsSingleton.get();
        prefs.putBoolean("soundEnable", this.jCheckSoundEnable.isSelected());
        prefs.putBoolean("soundFiltering", this.jCheckSoundFiltering.isSelected());
        prefs.putBoolean("maintainAspect", this.jCheckMaintainAspect.isSelected());
        prefs.putBoolean("TVEmulation", this.jCheckBoxNTSC.isSelected());
        prefs.putBoolean("Sleep", this.jCheckBoxSleep.isSelected());
        this.screenScaling = (Integer)this.jSpinnerScale.getModel().getValue();
        prefs.putBoolean("smoothScaling", this.jCheckBoxSmoothVideo.isSelected());
        prefs.putBoolean("showScope", this.jCheckBoxShowScope.isSelected());
        prefs.putBoolean("ntView", this.jCheckBoxNTView.isSelected());
        prefs.putInt("screenScaling", this.screenScaling);
        prefs.putInt("sampleRate", Integer.parseInt(this.jSampleRateBox.getSelectedItem().toString()));
        prefs.putInt("outputvol", this.volumeSlider.getValue());
        prefs.putInt("region", this.jRegionBox.getSelectedIndex());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.okClicked = true;
        this.setVisible(false);
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void jSampleRateBoxActionPerformed(ActionEvent evt) {
    }

    private void jCheckSoundFilteringActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxNTSCActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxSmoothVideoActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxSleepActionPerformed(ActionEvent evt) {
    }

    private void jRegionBoxActionPerformed(ActionEvent evt) {
    }
}

