/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.FileUtils;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.cheats.ActionReplay;
import com.grapeshot.halfnes.cheats.ActionReplayGui;
import com.grapeshot.halfnes.ui.ControllerImpl;
import com.grapeshot.halfnes.ui.ControlsDialog;
import com.grapeshot.halfnes.ui.GUIInterface;
import com.grapeshot.halfnes.ui.NESFileFilter;
import com.grapeshot.halfnes.ui.PreferencesDialog;
import com.grapeshot.halfnes.video.NTSCRenderer;
import com.grapeshot.halfnes.video.RGBRenderer;
import com.grapeshot.halfnes.video.Renderer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

public class SwingUI
extends JFrame
implements GUIInterface {
    private Canvas canvas;
    private BufferStrategy buffer;
    private NES nes;
    private static final long serialVersionUID = 6411494245530679723L;
    private final AL listener = new AL();
    private int screenScaleFactor;
    private final long[] frametimes = new long[60];
    private int frametimeptr = 0;
    private boolean smoothScale;
    private boolean inFullScreen = false;
    private GraphicsDevice gd;
    private int NES_HEIGHT;
    private int NES_WIDTH;
    private Renderer renderer;
    private final ControllerImpl padController1;
    private final ControllerImpl padController2;
    int bgcolor;
    BufferedImage frame;
    double fps;
    int frameskip = 0;

    public SwingUI() {
        this.nes = new NES(this);
        this.screenScaleFactor = PrefsSingleton.get().getInt("screenScaling", 2);
        this.padController1 = new ControllerImpl(this, 0);
        this.padController2 = new ControllerImpl(this, 1);
        this.nes.setControllers(this.padController1, this.padController2);
        this.padController1.startEventQueue();
        this.padController2.startEventQueue();
    }

    @Override
    public NES getNes() {
        return this.nes;
    }

    @Override
    public void setNES(NES nes) {
        this.nes = nes;
    }

    public synchronized void setRenderOptions() {
        if (this.canvas != null) {
            this.remove(this.canvas);
        }
        this.screenScaleFactor = PrefsSingleton.get().getInt("screenScaling", 2);
        this.smoothScale = PrefsSingleton.get().getBoolean("smoothScaling", false);
        if (PrefsSingleton.get().getBoolean("TVEmulation", false)) {
            this.renderer = new NTSCRenderer();
            this.NES_WIDTH = 302;
        } else {
            this.renderer = new RGBRenderer();
            this.NES_WIDTH = 256;
        }
        if (PrefsSingleton.get().getInt("region", 0) > 1) {
            this.NES_HEIGHT = 240;
            this.renderer.setClip(0);
        } else {
            this.NES_HEIGHT = 224;
            this.renderer.setClip(8);
        }
        this.canvas = new Canvas();
        this.canvas.setSize(this.NES_WIDTH * this.screenScaleFactor, this.NES_HEIGHT * this.screenScaleFactor);
        this.canvas.setEnabled(false);
        this.add(this.canvas);
        this.pack();
        this.canvas.createBufferStrategy(2);
        this.buffer = this.canvas.getBufferStrategy();
    }

    public void start(String[] args) {
        if (args == null || args.length < 1 || args[0] == null) {
            this.nes.run();
        } else {
            this.nes.run(args[0]);
        }
    }

    @Override
    public synchronized void run() {
        this.setTitle("HalfNES 1.0.6");
        this.setResizable(false);
        this.buildMenus();
        this.setRenderOptions();
        this.getRootPane().registerKeyboardAction(this.listener, "Escape", KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(this.listener, "Toggle Fullscreen", KeyStroke.getKeyStroke(122, 0), 2);
        this.getRootPane().registerKeyboardAction(this.listener, "Quit", KeyStroke.getKeyStroke(115, 512), 2);
        this.setLocation(PrefsSingleton.get().getInt("windowX", 0), PrefsSingleton.get().getInt("windowY", 0));
        this.addWindowListener(this.listener);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
        TransferHandler handler = new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    File toload = (File)((List)t.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                    SwingUI.this.loadROM(toload.getCanonicalPath());
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        this.setTransferHandler(handler);
    }

    public void buildMenus() {
        JMenuBar menus = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem item = new JMenuItem("Open ROM");
        file.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        file.addSeparator();
        item = new JMenuItem("Preferences");
        file.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        file.addSeparator();
        item = new JMenuItem("Toggle Fullscreen");
        file.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        item.addActionListener(this.listener);
        menus.add(file);
        item = new JMenuItem("Quit");
        file.add(item);
        item.addActionListener(this.listener);
        menus.add(file);
        JMenu nesmenu = new JMenu("NES");
        item = new JMenuItem("Reset");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Hard Reset");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Pause");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        item = new JMenuItem("Resume");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        item = new JMenuItem("Fast Forward");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(32, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Frame Advance");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        nesmenu.addSeparator();
        item = new JMenuItem("Controller Settings");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item = new JMenuItem("Cheat Codes");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(121, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        nesmenu.addSeparator();
        item = new JMenuItem("ROM Info");
        nesmenu.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menus.add(nesmenu);
        JMenu help = new JMenu("Help");
        item = new JMenuItem("About");
        help.add(item);
        item.addActionListener(this.listener);
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menus.add(help);
        this.setJMenuBar(menus);
    }

    public void loadROM() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(0);
        fileDialog.setTitle("Select a ROM to load");
        String path = PrefsSingleton.get().get("filePath", System.getProperty("user.dir", ""));
        File startDirectory = new File(path);
        if (startDirectory.isDirectory()) {
            fileDialog.setDirectory(path);
        }
        fileDialog.setFilenameFilter(new NESFileFilter());
        boolean wasInFullScreen = false;
        if (this.inFullScreen) {
            wasInFullScreen = true;
            this.toggleFullScreen();
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            PrefsSingleton.get().put("filePath", fileDialog.getDirectory());
            this.loadROM(fileDialog.getDirectory() + fileDialog.getFile());
        }
        if (wasInFullScreen) {
            this.toggleFullScreen();
        }
    }

    private void loadROM(String path) {
        if (path.endsWith(".zip") || path.endsWith(".ZIP")) {
            try {
                this.loadRomFromZip(path);
            }
            catch (IOException ex) {
                this.messageBox("Could not load file:\nFile does not exist or is not a valid NES game.\n" + ex.getMessage());
            }
        } else {
            this.nes.loadROM(path);
        }
    }

    private void loadRomFromZip(String zipName) throws IOException {
        File extractedFile;
        String romName = this.selectRomInZip(this.listRomsInZip(zipName));
        if (romName != null && (extractedFile = this.extractRomFromZip(zipName, romName)) != null) {
            extractedFile.deleteOnExit();
            this.nes.loadROM(extractedFile.getCanonicalPath());
        }
    }

    private List<String> listRomsInZip(String zipName) throws IOException {
        ZipFile zipFile = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        ArrayList<String> romNames = new ArrayList<String>();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".nes") && !entry.getName().endsWith(".fds") && !entry.getName().endsWith(".nsf")) continue;
            romNames.add(entry.getName());
        }
        zipFile.close();
        if (romNames.isEmpty()) {
            throw new IOException("No NES games found in ZIP file.");
        }
        return romNames;
    }

    private String selectRomInZip(List<String> romNames) {
        if (romNames.size() > 1) {
            return (String)JOptionPane.showInputDialog(this, "Select ROM to load", "Select ROM to load", -1, null, romNames.toArray(), romNames.get(0));
        }
        if (romNames.size() == 1) {
            return romNames.get(0);
        }
        return null;
    }

    private File extractRomFromZip(String zipName, String romName) throws IOException {
        int numBytes;
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipName));
        while ((entry = zipStream.getNextEntry()) != null && !entry.getName().equals(romName)) {
        }
        if (entry == null) {
            zipStream.close();
            throw new IOException("Cannot find file " + romName + " inside archive " + zipName);
        }
        File outputFile = new File(new File(zipName).getParent() + File.separator + FileUtils.stripExtension(new File(zipName).getName()) + " - " + romName);
        if (outputFile.exists()) {
            this.messageBox("Cannot extract file. File " + outputFile.getCanonicalPath() + " already exists.");
            zipStream.close();
            return null;
        }
        byte[] buf = new byte[4096];
        FileOutputStream fos = new FileOutputStream(outputFile);
        while ((numBytes = zipStream.read(buf, 0, buf.length)) != -1) {
            fos.write(buf, 0, numBytes);
        }
        zipStream.close();
        fos.close();
        return outputFile;
    }

    public synchronized void toggleFullScreen() {
        if (this.inFullScreen) {
            this.dispose();
            this.gd.setFullScreenWindow(null);
            this.canvas.setSize(this.NES_HEIGHT * this.screenScaleFactor, this.NES_WIDTH * this.screenScaleFactor);
            this.setUndecorated(false);
            this.setVisible(true);
            this.inFullScreen = false;
            this.buildMenus();
        } else {
            this.setJMenuBar(null);
            this.gd = this.getGraphicsConfiguration().getDevice();
            if (!this.gd.isFullScreenSupported()) {
                this.messageBox("Fullscreen is not supported by your OS or version of Java.");
                return;
            }
            this.dispose();
            this.setUndecorated(true);
            this.gd.setFullScreenWindow(this);
            this.setVisible(true);
            DisplayMode dm = this.gd.getDisplayMode();
            this.canvas.setSize(dm.getWidth(), dm.getHeight());
            this.inFullScreen = true;
        }
    }

    @Override
    public void messageBox(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public final synchronized void setFrame(int[] nextframe, int[] bgcolors, boolean dotcrawl) {
        this.frametimes[this.frametimeptr] = this.nes.getFrameTime();
        ++this.frametimeptr;
        this.frametimeptr %= this.frametimes.length;
        if (this.frametimeptr == 0) {
            long averageframes = 0L;
            for (long l : this.frametimes) {
                averageframes += l;
            }
            this.fps = 1.0E9 / (double)(averageframes /= (long)this.frametimes.length);
            this.setTitle(String.format("HalfNES %s - %s, %2.2f fps" + (this.frameskip > 0 ? " frameskip " + this.frameskip : ""), "1.0.6", this.nes.getCurrentRomName(), this.fps));
        }
        if (this.nes.framecount % (long)(this.frameskip + 1) == 0L) {
            this.frame = this.renderer.render(nextframe, bgcolors, dotcrawl);
            this.render();
        }
    }

    @Override
    public final synchronized void render() {
        Graphics graphics = this.buffer.getDrawGraphics();
        if (this.smoothScale) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        if (this.inFullScreen) {
            graphics.setColor(Color.BLACK);
            DisplayMode dm = this.gd.getDisplayMode();
            int scrnheight = dm.getHeight();
            int scrnwidth = dm.getWidth();
            graphics.fillRect(0, 0, scrnwidth, scrnheight);
            if (PrefsSingleton.get().getBoolean("maintainAspect", true)) {
                double scalefactor = this.getmaxscale(scrnwidth, scrnheight);
                int height = (int)((double)this.NES_HEIGHT * scalefactor);
                int width = (int)(256.0 * scalefactor * 1.1666667);
                graphics.drawImage(this.frame, scrnwidth / 2 - width / 2, scrnheight / 2 - height / 2, width, height, null);
            } else {
                graphics.drawImage(this.frame, 0, 0, scrnwidth, scrnheight, null);
            }
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawString(this.getTitle(), 16, 16);
        } else {
            graphics.drawImage(this.frame, 0, 0, this.NES_WIDTH * this.screenScaleFactor, this.NES_HEIGHT * this.screenScaleFactor, null);
        }
        graphics.dispose();
        this.buffer.show();
    }

    private void showOptions() {
        PreferencesDialog dialog = new PreferencesDialog(this);
        dialog.setVisible(true);
        if (dialog.okClicked()) {
            this.setRenderOptions();
            this.nes.setParameters();
        }
    }

    private void showControlsDialog() {
        ControlsDialog dialog = new ControlsDialog(this);
        dialog.setVisible(true);
        if (dialog.okClicked()) {
            this.padController1.setButtons();
            this.padController2.setButtons();
        }
    }

    private void showActionReplayDialog() {
        this.nes.pause();
        ActionReplay actionReplay = this.nes.getActionReplay();
        if (actionReplay != null) {
            ActionReplayGui dialog = new ActionReplayGui((Frame)this, false, actionReplay);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "You have to load a game first.", "No ROM", 0);
        }
        this.nes.resume();
    }

    public void savewindowposition() {
        PrefsSingleton.get().putInt("windowX", this.getX());
        PrefsSingleton.get().putInt("windowY", this.getY());
    }

    private double getmaxscale(int width, int height) {
        return Math.min((double)height / (double)this.NES_HEIGHT, (double)width / (double)this.NES_WIDTH);
    }

    @Override
    public void loadROMs(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class AL
    implements ActionListener,
    WindowListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Quit")) {
                this.close();
            } else if (arg0.getActionCommand().equals("Reset")) {
                SwingUI.this.nes.reset();
            } else if (arg0.getActionCommand().equals("Hard Reset")) {
                SwingUI.this.nes.reloadROM();
            } else if (arg0.getActionCommand().equals("Pause")) {
                SwingUI.this.nes.pause();
            } else if (arg0.getActionCommand().equals("Resume")) {
                SwingUI.this.nes.resume();
            } else if (arg0.getActionCommand().equals("Preferences")) {
                SwingUI.this.showOptions();
            } else if (arg0.getActionCommand().equals("Fast Forward")) {
                SwingUI.this.nes.toggleFrameLimiter();
            } else if (arg0.getActionCommand().equals("About")) {
                SwingUI.this.messageBox("HalfNES 1.0.6\nGet the latest version and report any bugs at https://github.com/ \n\nThis program is free software licensed under the GPL version 3, and comes with \nNO WARRANTY of any kind. (but if something's broken, please report it). \nSee the license.txt file for details.");
            } else if (arg0.getActionCommand().equals("ROM Info")) {
                String info = SwingUI.this.nes.getrominfo();
                if (info != null) {
                    SwingUI.this.messageBox(info);
                }
            } else if (arg0.getActionCommand().equals("Open ROM")) {
                SwingUI.this.loadROM();
            } else if (arg0.getActionCommand().equals("Toggle Fullscreen")) {
                SwingUI.this.toggleFullScreen();
            } else if (arg0.getActionCommand().equals("Frame Advance")) {
                SwingUI.this.nes.frameAdvance();
            } else if (arg0.getActionCommand().equals("Escape")) {
                if (SwingUI.this.inFullScreen) {
                    SwingUI.this.toggleFullScreen();
                } else {
                    this.close();
                }
            } else if (arg0.getActionCommand().equals("Controller Settings")) {
                SwingUI.this.showControlsDialog();
            } else if (arg0.getActionCommand().equals("Cheat Codes")) {
                SwingUI.this.showActionReplayDialog();
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            SwingUI.this.dispose();
            SwingUI.this.savewindowposition();
            SwingUI.this.padController1.stopEventQueue();
            SwingUI.this.padController2.stopEventQueue();
            SwingUI.this.nes.quit();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

