/*
 * Decompiled with CFR 0.152.
 */
package mcd;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import mcd.McdDeviceHelper;
import mcd.bus.McdSubInterruptHandler;
import mcd.cdd.ExtendedCueSheet;
import mcd.util.McdMemView;
import omegadrive.SystemLoader;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.Megadrive;
import omegadrive.system.SysUtil;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.VideoMode;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;

public class MegaCd
extends Megadrive {
    private static final Logger LOG = LogHelper.getLogger(MegaCd.class.getSimpleName());
    public static final boolean verbose = false;
    public static final double MCD_SUB_68K_CLOCK_MHZ = 1.25E7;
    public static final double MCD_68K_RATIO_NTSC = 0.6136362857142857;
    public static final double MCD_68K_RATIO_PAL = 0.6080391314285715;
    private double mcd68kRatio;
    protected M68kProvider subCpu;
    protected McdSubInterruptHandler interruptHandler;
    protected McdDeviceHelper.McdLaunchContext mcdLaunchContext;
    protected double nextSub68kCycle = 1.0;
    double subCnt = 0.0;

    protected MegaCd(DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = SystemLoader.SystemType.MEGACD;
    }

    public static SystemProvider createNewInstance(DisplayWindow emuFrame) {
        return new MegaCd(emuFrame);
    }

    @Override
    public void init() {
        this.mcdLaunchContext = McdDeviceHelper.setupDevices();
        super.init();
        this.vdp.addVdpEventListener(this.mcdLaunchContext.subBus);
        ((MdMainBusProvider)this.bus).attachDevices(this, this.memory, this.joypad, this.vdp, this.cpu, this.z80, this.sound);
        this.mcdLaunchContext.subBus.attachDevice(this);
        this.subCpu = this.mcdLaunchContext.subCpu;
        this.interruptHandler = this.mcdLaunchContext.interruptHandler;
        this.subCpu.reset();
    }

    @Override
    protected void postInit() {
        super.postInit();
        MegaCd.megaCdDiscInsert(this.mcdLaunchContext, this.mediaSpec);
    }

    @Override
    protected MdMainBusProvider createBus() {
        assert (this.mcdLaunchContext.mainBus != null);
        this.bus = this.mcdLaunchContext.mainBus;
        return (MdMainBusProvider)this.bus;
    }

    @Override
    protected void loop() {
        this.updateVideoMode(true);
        do {
            this.run68k();
            this.runSub68k();
            this.runZ80();
            this.runFM();
            this.runVdp();
            ++this.cycleCounter;
        } while (!this.futureDoneFlag);
    }

    protected void runSub68k() {
        while (this.nextSub68kCycle <= (double)this.cycleCounter) {
            boolean canRun = !this.subCpu.isStopped();
            int cycleDelayCpu = 1;
            MdRuntimeData.setAccessTypeExt(BufferUtil.CpuDeviceAccess.SUB_M68K);
            if (canRun) {
                cycleDelayCpu = this.subCpu.runInstruction() + MdRuntimeData.resetCpuDelayExt();
            }
            this.interruptHandler.handleInterrupts();
            cycleDelayCpu = Math.max(1, cycleDelayCpu);
            this.subCnt += (double)cycleDelayCpu;
            this.mcdLaunchContext.stepDevices(cycleDelayCpu);
            this.nextSub68kCycle += 1.0 * this.mcd68kRatio * (double)cycleDelayCpu;
            assert (MdRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    @Override
    protected void updateVideoMode(boolean force) {
        VideoMode prev = this.displayContext.videoMode;
        super.updateVideoMode(force);
        if (force || prev != this.vdp.getVideoMode()) {
            this.mcd68kRatio = this.displayContext.videoMode.isPal() ? 0.6080391314285715 : 0.6136362857142857;
            this.mcdLaunchContext.pcm.updateVideoMode(this.displayContext.videoMode);
            this.mcdLaunchContext.cdd.updateVideoMode(this.displayContext.videoMode);
            this.mcdLaunchContext.interruptHandler.setRegion(this.displayContext.videoMode.getRegion());
            LOG.info("Video mode changed: {}, mcd68kRatio: {}", (Object)this.displayContext.videoMode, (Object)this.mcd68kRatio);
        }
    }

    @Override
    public void newFrame() {
        this.mcdLaunchContext.pcm.newFrame();
        this.mcdLaunchContext.cdd.newFrame();
        this.displayContext.megaCdLedState = Optional.of(this.mcdLaunchContext.subBus.getLedState());
        super.newFrame();
    }

    @Override
    protected UpdatableViewer createMemView() {
        return McdMemView.createInstance((MdMainBusProvider)this.bus, this.mcdLaunchContext, this.vdp.getVdpMemory());
    }

    @Override
    protected void resetCycleCounters(int counter) {
        super.resetCycleCounters(counter);
        assert (this.nextSub68kCycle >= (double)counter);
        this.logSlowFrames();
        this.nextSub68kCycle = Math.max(1.0, this.nextSub68kCycle - (double)counter);
    }

    public static void megaCdDiscInsert(McdDeviceHelper.McdLaunchContext mcdLaunchContext, MediaSpecHolder mediaSpec) {
        Path p;
        boolean segaMode1 = mcdLaunchContext.mainBus.isEnableMode1();
        boolean bios = mcdLaunchContext.mainBus.isBios();
        boolean tryInsertAsDisc = !segaMode1 && !bios && mediaSpec.hasDiscImage();
        boolean biosNoDisc = false;
        boolean biosCdAudio = true;
        if (bios) {
            LOG.info("Bios mode, noDisc: {}, cdAudio: {}", (Object)biosNoDisc, (Object)biosCdAudio);
        }
        if (tryInsertAsDisc) {
            assert (mediaSpec.cdFile.sheetOpt.isPresent());
            mcdLaunchContext.cdd.tryInsert(mediaSpec.cdFile.sheetOpt.get());
        } else if ((segaMode1 || !bios || biosCdAudio) && Files.exists(p = Path.of("./test_roms/SonicCD", "SonicCD_AudioOnly.cue"), new LinkOption[0])) {
            ExtendedCueSheet cueSheet = new ExtendedCueSheet(p, SysUtil.RomFileType.BIN_CUE);
            mcdLaunchContext.cdd.tryInsert(cueSheet);
        }
    }

    @Override
    protected void handleCloseRom() {
        super.handleCloseRom();
        this.mcdLaunchContext.cdd.close();
        this.mcdLaunchContext.pcm.close();
    }

    @Override
    protected void handleSoftReset() {
        if (this.softResetPending) {
            this.subCpu.softReset();
        }
        super.handleSoftReset();
    }

    private void logSlowFrames() {
        long fc = this.getFrameCounter();
        if ((fc + 1L) % (long)this.mediaSpec.getRegion().getFps() == 0L) {
            boolean rangeOk;
            boolean bl = rangeOk = Math.abs(1.25E7 - this.subCnt) < 100000.0;
            if (fc > 100L && !rangeOk) {
                LOG.warn("Frame#{} SubCpu timing off!!!, 68K clock: {}, mode: {}", new Object[]{fc, this.subCnt, this.displayContext.videoMode});
            }
            this.subCnt = 0.0;
        }
    }

    static {
        System.setProperty("68k.debug", "false");
        System.setProperty("helios.68k.debug.mode", "0");
        System.setProperty("z80.debug", "false");
    }
}

