/*
 * Decompiled with CFR 0.152.
 */
package mcd.bus;

import java.nio.ByteBuffer;
import mcd.McdDeviceHelper;
import mcd.bus.MegaCdMainCpuBusIntf;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.joypad.MdJoypad;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;
import s32x.bus.S32xBus;
import s32x.bus.S32xBusIntf;

public class Mcd32xMainBus
extends DeviceAwareBus<MdVdpProvider, MdJoypad>
implements MdMainBusProvider {
    private static final Logger LOG = LogHelper.getLogger(Mcd32xMainBus.class.getSimpleName());
    public final S32xBusIntf s32xBus;
    public final MegaCdMainCpuBusIntf mcdMainBus;
    private final MdMainBusProvider mdBus;
    private boolean cartBoot;

    public Mcd32xMainBus(McdDeviceHelper.McdLaunchContext mcdLaunchContext) {
        this.mdBus = mcdLaunchContext.mdBus;
        this.s32xBus = S32xBus.createS32xBus(this.mdBus);
        this.mcdMainBus = mcdLaunchContext.mainBus;
    }

    @Override
    public void init() {
        super.init();
        this.mcdMainBus.init();
        this.s32xBus.init();
        this.cartBoot = true;
        if (this.getSystem().getMediaSpec().cdFile.bootable) {
            this.s32xBus.setRom(ByteBuffer.allocate(0));
            this.cartBoot = false;
        }
    }

    @Override
    public MdMainBusProvider attachDevice(Device device) {
        super.attachDevice(device);
        this.mcdMainBus.attachDevice(device);
        this.s32xBus.attachDevice(device);
        return (MdMainBusProvider)this.mdBus.attachDevice(device);
    }

    @Override
    public int read(int address, Size size) {
        assert (this.cartBoot == this.mcdMainBus.isEnableMode1());
        return switch (Mcd32xMainBus.byAddress(address &= 0xFFFFFF, this.cartBoot)) {
            case SystemLoader.SystemType.S32X -> this.s32xBus.read(address, size);
            case SystemLoader.SystemType.MEGACD -> this.mcdMainBus.read(address, size);
            default -> throw new RuntimeException(Mcd32xMainBus.byAddress(address, this.cartBoot).toString());
        };
    }

    @Override
    public void write(int address, int data, Size size) {
        assert (this.cartBoot == this.mcdMainBus.isEnableMode1());
        switch (Mcd32xMainBus.byAddress(address &= 0xFFFFFF, this.cartBoot)) {
            case S32X: {
                this.s32xBus.write(address, data, size);
                break;
            }
            case MEGACD: {
                this.mcdMainBus.write(address, data, size);
                break;
            }
            default: {
                throw new RuntimeException(Mcd32xMainBus.byAddress(address, this.cartBoot).toString());
            }
        }
    }

    private static SystemLoader.SystemType byAddress(int address, boolean cartBoot) {
        if (cartBoot) {
            if (address >= 0x880000 && address < 0x900000) {
                return SystemLoader.SystemType.S32X;
            }
            if (address < 256) {
                return SystemLoader.SystemType.S32X;
            }
        } else assert (address < 0x880000 || address >= 0x900000) : Util.th(address);
        boolean is32xAddr = address >= 0x840000 && address < 0x880000 || address >= 10572032 && address < 10572800 || address >= 10563820 && address < 10563824;
        return is32xAddr ? SystemLoader.SystemType.S32X : SystemLoader.SystemType.MEGACD;
    }

    @Override
    public void handleVdpInterrupts68k() {
        this.mdBus.handleVdpInterrupts68k();
    }

    @Override
    public void ackInterrupt68k(int level) {
        this.mdBus.ackInterrupt68k(level);
    }

    @Override
    public boolean is68kRunning() {
        return this.mdBus.is68kRunning();
    }

    @Override
    public void handleVdpInterruptsZ80() {
        this.mdBus.handleVdpInterruptsZ80();
    }

    @Override
    public void resetFrom68k() {
        this.mdBus.resetFrom68k();
    }

    @Override
    public void setVdpBusyState(MdVdpProvider.VdpBusyState state) {
        this.mdBus.setVdpBusyState(state);
    }

    @Override
    public boolean isZ80Running() {
        return this.mdBus.isZ80Running();
    }

    @Override
    public boolean isZ80ResetState() {
        return this.mdBus.isZ80ResetState();
    }

    @Override
    public boolean isZ80BusRequested() {
        return this.mdBus.isZ80BusRequested();
    }

    @Override
    public void setZ80ResetState(boolean z80ResetState) {
        this.mdBus.setZ80ResetState(z80ResetState);
    }

    @Override
    public void setZ80BusRequested(boolean z80BusRequested) {
        this.mdBus.setZ80BusRequested(z80BusRequested);
    }

    @Override
    public PsgProvider getPsg() {
        return this.mdBus.getPsg();
    }

    @Override
    public FmProvider getFm() {
        return this.mdBus.getFm();
    }

    @Override
    public SystemProvider getSystem() {
        return this.mdBus.getSystem();
    }

    @Override
    public MdVdpProvider getVdp() {
        return this.mdBus.getVdp();
    }

    @Override
    public MdCartInfoProvider getCartridgeInfoProvider() {
        return this.mdBus.getCartridgeInfoProvider();
    }
}

