/*
 * Decompiled with CFR 0.152.
 */
package mcd.bus;

import java.nio.ByteBuffer;
import java.util.Objects;
import mcd.bus.McdSubInterruptHandler;
import mcd.bus.MegaCdMainCpuBusIntf;
import mcd.bus.MegaCdSubCpuBusIntf;
import mcd.cdd.CdBiosHelper;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.util.McdBiosHolder;
import mcd.util.McdRegBitUtil;
import omegadrive.Device;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.joypad.MdJoypad;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;

public class MegaCdMainCpuBus
extends DeviceAwareBus<MdVdpProvider, MdJoypad>
implements MegaCdMainCpuBusIntf {
    private static final Logger LOG = LogHelper.getLogger(MegaCdMainCpuBus.class.getSimpleName());
    public static final int MCD_GATE_REGS_SIZE = 64;
    public static final int MCD_GATE_REGS_MASK = 63;
    private ByteBuffer prgRam;
    private ByteBuffer sysGateRegs;
    private ByteBuffer commonGateRegs;
    private int prgRamBankValue = 0;
    private int prgRamBankShift = 0;
    private boolean enableMCDBus = true;
    private boolean enableMode1 = false;
    private boolean isBios;
    public ByteBuffer bios;
    private LogHelper logHelper = new LogHelper();
    private MegaCdMemoryContext memCtx;
    private McdBiosHolder biosHolder;
    public MC68000Wrapper subCpu;
    public MegaCdSubCpuBusIntf subCpuBus;
    private BufferUtil.CpuDeviceAccess cpu = BufferUtil.CpuDeviceAccess.M68K;
    private int maskMode1;
    protected MdMainBusProvider mdBus;
    @Deprecated
    public static boolean subCpuReset = false;
    @Deprecated
    public static int ifl2Trigger = 0;

    public MegaCdMainCpuBus(MegaCdMemoryContext ctx, MdMainBusProvider mdBus) {
        this.prgRam = ByteBuffer.wrap(ctx.prgRam);
        this.sysGateRegs = ctx.getGateSysRegs(this.cpu);
        this.commonGateRegs = ByteBuffer.wrap(ctx.commonGateRegs);
        this.memCtx = ctx;
        BufferUtil.writeBufferRaw(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_RESET.addr, 2, Size.WORD);
        BufferUtil.writeBufferRaw(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_MEM_MODE.addr + 1, 1, Size.BYTE);
        BufferUtil.writeBufferRaw(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_CDC_REG_DATA.addr, 65535, Size.WORD);
        this.biosHolder = McdBiosHolder.getInstance();
        this.maskMode1 = !this.enableMode1 ? 0x400000 : 0;
        this.mdBus = mdBus;
    }

    @Override
    public void init() {
        this.mdBus.init();
        this.setEnableMode1(true);
        MdCartInfoProvider cartridgeInfoProvider = this.mdBus.getCartridgeInfoProvider();
        boolean mcdVer = cartridgeInfoProvider.toString().contains("krikzz");
        boolean bl = this.isBios = cartridgeInfoProvider.getSerial().startsWith("BR ") && !mcdVer;
        if (this.isBios) {
            this.setEnableMode1(false);
            LOG.info("Bios detected with serial: {}, disabling mode1 mapper", (Object)cartridgeInfoProvider.getSerial());
            this.bios = McdBiosHolder.loadBios(this.systemProvider.getRegion(), this.systemProvider.getRomPath());
            return;
        }
        if (this.systemProvider.getMediaSpec().hasDiscImage() && this.systemProvider.getMediaSpec().cdFile.bootable) {
            this.setEnableMode1(false);
            LOG.info("CUE/ISO file detected, disabling mode1 mapper");
        }
        this.bios = this.biosHolder.getBiosBuffer(this.systemProvider.getRegion());
    }

    @Override
    public MdMainBusProvider attachDevice(Device device) {
        super.attachDevice(device);
        return (MdMainBusProvider)this.mdBus.attachDevice(device);
    }

    @Override
    public int read(int address, Size size) {
        assert (Util.assertCheckBusOp(address, size));
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.M68K || MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.Z80);
        if ((address &= 0xFFFFFF) >= 10559488 && address <= 10559743) {
            if (!this.enableMCDBus) {
                LOG.info("Enabling MegaCD bus mapping");
                this.enableMCDBus = true;
            }
            return this.handleMegaCdExpRead(address & 0x3F, size) & size.getMask();
        }
        int res = size.getMask();
        if (this.enableMCDBus) {
            int addr = address | this.maskMode1;
            if (addr >= 0x400070 && addr < 0x400074) {
                return this.readHintVector(addr, size);
            }
            if (addr >= 0x600000 && addr < 0x800000) {
                res = this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M && (addr &= 0x3FFFF) >= 131072 ? this.memCtx.wramHelper.readCellMapped(address, size) : this.memCtx.wramHelper.readWordRam(this.cpu, addr, size);
            } else if (addr >= 0x400000 && addr < 0x600000) {
                if ((addr &= 0x3FFFF) >= 131072) {
                    addr = this.prgRamBankShift | addr & 0x1FFFF;
                    res = BufferUtil.readBuffer(this.prgRam, addr, size);
                } else {
                    res = BufferUtil.readBuffer(this.bios, addr & 0x1FFFF, size);
                }
            } else {
                res = this.mdBus.read(address, size);
            }
        }
        return res & size.getMask();
    }

    @Override
    public void write(int address, int data, Size size) {
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.M68K || MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.Z80);
        assert (Util.assertCheckBusOp(address, size));
        address &= 0xFFFFFF;
        if (this.enableMCDBus) {
            if (address >= 10559488 && address <= 10559743) {
                this.handleMegaCdExpWrite(address & 0x3F, data, size);
                return;
            }
            int addr = address | this.maskMode1;
            if (addr >= 0x420000 && addr < 0x600000) {
                if ((addr &= 0x3FFFF) >= 131072) {
                    if (this.subCpu.isStopped()) {
                        addr = this.prgRamBankShift | addr & 0x1FFFF;
                        BufferUtil.writeBufferRaw(this.prgRam, addr, data, size);
                    } else {
                        LogHelper.logWarnOnce(LOG, "Ignoring {} writing to PRG_RAM when SUB is running", new Object[]{MdRuntimeData.getAccessTypeExt()});
                    }
                } else {
                    LOG.error("Writing to boot rom: {}({})", (Object)Util.th(addr), (Object)Util.th(address));
                }
                return;
            }
            if (addr >= 0x600000 && addr < 0x800000) {
                this.memCtx.wramHelper.writeWordRam(this.cpu, addr &= 0x3FFFF, data, size);
                if (addr < 131072 && this.memCtx.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M) {
                    this.memCtx.wramHelper.writeCellMapped(addr, data, size);
                }
                return;
            }
        }
        this.mdBus.write(address, data, size);
        CdBiosHelper.checkMainMemRegion(this.memoryProvider.getRamData(), address);
    }

    @Override
    public void writeIoPort(int port, int value) {
        this.mdBus.writeIoPort(port, value);
    }

    @Override
    public MdCartInfoProvider getCartridgeInfoProvider() {
        return this.mdBus.getCartridgeInfoProvider();
    }

    @Override
    public void handleVdpInterrupts68k() {
        this.mdBus.handleVdpInterrupts68k();
    }

    @Override
    public void handleVdpInterruptsZ80() {
        this.mdBus.handleVdpInterruptsZ80();
    }

    @Override
    public void ackInterrupt68k(int level) {
        this.mdBus.ackInterrupt68k(level);
    }

    @Override
    public void resetFrom68k() {
        this.mdBus.resetFrom68k();
    }

    @Override
    public boolean is68kRunning() {
        return this.mdBus.is68kRunning();
    }

    @Override
    public void setVdpBusyState(MdVdpProvider.VdpBusyState state) {
        this.mdBus.setVdpBusyState(state);
    }

    @Override
    public boolean isZ80Running() {
        return this.mdBus.isZ80Running();
    }

    @Override
    public boolean isZ80ResetState() {
        return this.mdBus.isZ80ResetState();
    }

    @Override
    public boolean isZ80BusRequested() {
        return this.mdBus.isZ80BusRequested();
    }

    @Override
    public void setZ80ResetState(boolean z80ResetState) {
        this.mdBus.setZ80ResetState(z80ResetState);
    }

    @Override
    public void setZ80BusRequested(boolean z80BusRequested) {
        this.mdBus.setZ80BusRequested(z80BusRequested);
    }

    @Override
    public PsgProvider getPsg() {
        return this.mdBus.getPsg();
    }

    @Override
    public FmProvider getFm() {
        return this.mdBus.getFm();
    }

    @Override
    public SystemProvider getSystem() {
        return this.mdBus.getSystem();
    }

    @Override
    public MdVdpProvider getVdp() {
        return this.mdBus.getVdp();
    }

    @Override
    public int readIoPort(int port) {
        return this.mdBus.readIoPort(port);
    }

    private int readHintVector(int addr, Size size) {
        assert (size != Size.LONG || addr == 0x400070);
        int res = Util.readData(this.memCtx.writeableHint, 0, Size.LONG);
        if (res != -1) {
            res = Util.readData(this.memCtx.writeableHint, addr & 3, size);
        }
        return res;
    }

    private int handleMegaCdExpRead(int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.WORD, Size.BYTE -> this.handleMegaCdExpReadInternal(address, size);
            case Size.LONG -> (this.handleMegaCdExpReadInternal(address, Size.WORD) & 0xFFFF) << 16 | this.handleMegaCdExpReadInternal(address + 2, Size.WORD) & 0xFFFF;
        };
    }

    private int handleMegaCdExpReadInternal(int address, Size size) {
        assert ((address & 0xFF) < 64);
        assert (size != Size.LONG);
        MegaCdDict.RegSpecMcd regSpec = MegaCdDict.getRegSpec(this.cpu, address);
        this.logAccess(regSpec, this.cpu, address, 0, size, true);
        if (regSpec == MegaCdDict.RegSpecMcd.INVALID) {
            LOG.error("M read unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            return 0;
        }
        MegaCdDict.checkRegLongAccess(regSpec, size);
        int res = BufferUtil.readBuffer(this.memCtx.getRegBuffer(this.cpu, regSpec), address & 0x3F, size);
        if (regSpec == MegaCdDict.RegSpecMcd.MCD_COMM_FLAGS) {
            // empty if block
        }
        if (regSpec == MegaCdDict.RegSpecMcd.MCD_CDC_HOST) {
            int addr = 1015808 + regSpec.addr + (address & 1);
            res = this.subCpuBus.read(addr, size);
        }
        return res;
    }

    private void handleMegaCdExpWrite(int address, int data, Size size) {
        assert ((address & 0xFF) < 64);
        MegaCdDict.RegSpecMcd regSpec = MegaCdDict.getRegSpec(this.cpu, address);
        MegaCdDict.logAccess(regSpec, this.cpu, address, data, size, false);
        if (regSpec == MegaCdDict.RegSpecMcd.INVALID) {
            LOG.error("M write unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            return;
        }
        switch (regSpec.deviceType) {
            case SYS: {
                this.handleSysRegWrite(regSpec, address, data, size);
                break;
            }
            case COMM: {
                this.handleCommWrite(regSpec, address, data, size);
                break;
            }
            default: {
                LOG.error("M illegal write MEGA_CD_EXP reg: {} ({}), {} {}", new Object[]{Util.th(address), regSpec, data, size});
            }
        }
    }

    private void handleSysRegWrite(MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        switch (size) {
            case WORD: 
            case BYTE: {
                this.handleSysRegWriteInternal(regSpec, address, data, size);
                break;
            }
            case LONG: {
                this.handleMegaCdExpWrite(address, data >> 16, Size.WORD);
                this.handleMegaCdExpWrite(address + 2, data, Size.WORD);
            }
        }
    }

    private void handleSysRegWriteInternal(MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        assert (size != Size.LONG);
        switch (regSpec) {
            case MCD_RESET: {
                this.handleReg0Write(address, data, size);
                break;
            }
            case MCD_MEM_MODE: {
                this.handleReg2Write(address, data, size);
                break;
            }
            case MCD_CDC_MODE: 
            case MCD_CDC_HOST: {
                assert (false) : regSpec;
                break;
            }
            case MCD_COMM_FLAGS: {
                LogHelper.logInfo(LOG, "M write COMM_FLAG {}: {} {}", new Object[]{Util.th(address &= 0xFFFFFFFE), Util.th(data), size});
                BufferUtil.writeBufferRaw(this.sysGateRegs, address & 0x3F, data, Size.BYTE);
                BufferUtil.writeBufferRaw(this.memCtx.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec), address & 0x3F, data, Size.BYTE);
                break;
            }
            case MCD_HINT_VECTOR: {
                int prev;
                assert (size == Size.WORD);
                if (BufferUtil.assertionsEnabled && (prev = Util.readData(this.memCtx.writeableHint, 2, Size.WORD)) != data) {
                    LOG.info("M write MCD_HINT_VECTOR: {} {}", (Object)Util.th(data), (Object)size);
                }
                BufferUtil.writeBufferRaw(this.sysGateRegs, regSpec.addr, data, size);
                Util.writeData(this.memCtx.writeableHint, 2, data, size);
                break;
            }
            default: {
                LOG.error("M write unknown MEGA_CD_EXP reg: {}", (Object)Util.th(address));
            }
        }
    }

    private void handleReg0Write(int address, int data, Size size) {
        boolean triggerReset;
        int curr = Util.readBufferWord(this.sysGateRegs, MegaCdDict.RegSpecMcd.MCD_RESET.addr);
        int res = this.memCtx.handleRegWrite(this.cpu, MegaCdDict.RegSpecMcd.MCD_RESET, address, data, size);
        int sreset = res & 1;
        int sbusreq = res >> 1 & 1;
        assert (this.subCpu != null && this.subCpuBus != null);
        this.handleIfl2(curr, res, address, size);
        if ((address & 1) == 0 && size == Size.BYTE) {
            return;
        }
        LogHelper.logInfo(LOG, "M SubCpu reset: {}, busReq: {}", sreset == 0 ? "Reset" : "Run", sbusreq == 0 ? "Cancel" : "Request");
        if ((curr & 3) == (res & 3)) {
            return;
        }
        boolean stopped = sreset == 0 || sbusreq > 0;
        boolean bl = triggerReset = (curr & 1) == 0 && sreset > 0;
        if (triggerReset) {
            this.subCpu.reset();
        }
        boolean prevStop = this.subCpu.isStopped();
        this.subCpu.setStop(stopped);
        if (prevStop != stopped) {
            LOG.info("M SubCpu stopped: {}", (Object)stopped);
        }
    }

    private void handleIfl2(int prev, int res, int address, Size size) {
        if ((address & 1) == 1 && size == Size.BYTE) {
            return;
        }
        int subIntReg = res >> 8 & 1;
        if (subIntReg > 0) {
            if ((prev >> 8 & 1) == 0) {
                ifl2Trigger = 1;
                LogHelper.logInfo(LOG, "M SubCpu int2 request", new Object[0]);
                this.subCpuBus.getInterruptHandler().raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_LEVEL2);
            }
        } else if (subIntReg == 0) {
            ifl2Trigger = 0;
        }
    }

    private void handleReg2Write(int address, int data, Size size) {
        int resWord = this.memCtx.handleRegWrite(this.cpu, MegaCdDict.RegSpecMcd.MCD_MEM_MODE, address, data, size);
        MegaCdMemoryContext.WramSetup prev = this.memCtx.wramSetup;
        MegaCdMemoryContext.WramSetup ws = this.memCtx.wramHelper.update(this.cpu, resWord);
        if (ws.mode == MegaCdMemoryContext.WordRamMode._2M) {
            int val = ws.cpu == BufferUtil.CpuDeviceAccess.M68K ? 1 : 0;
            McdRegBitUtil.setSharedBitBothCpu(this.memCtx, MegaCdDict.SharedBitDef.RET, val);
        }
        this.subCpuBus.handleWramSetupChange(prev, ws);
        int bval = resWord >> 6 & 3;
        if (bval != this.prgRamBankValue) {
            this.prgRamBankValue = bval;
            this.prgRamBankShift = this.prgRamBankValue << 17;
            LOG.info("M PRG_RAM bank set: {} {}", (Object)this.prgRamBankValue, (Object)Util.th(this.prgRamBankShift));
        }
    }

    private void handleCommWrite(MegaCdDict.RegSpecMcd regSpec, int address, int data, Size size) {
        if (address >= MegaCdDict.RegSpecMcd.MCD_COMM0.addr && address < MegaCdDict.RegSpecMcd.MCD_COMM8.addr) {
            LogHelper.logInfo(LOG, "M Write MEGA_CD_COMM: {}, {}, {}", new Object[]{Util.th(address), Util.th(data), size});
            BufferUtil.writeBufferRaw(this.commonGateRegs, address & 0x3F, data, size);
            return;
        }
        if (address >= MegaCdDict.RegSpecMcd.MCD_COMM8.addr && address < MegaCdDict.RegSpecMcd.MCD_TIMER_INT3.addr) {
            LOG.error("M illegal write read-only MEGA_CD_COMM reg: {}", (Object)Util.th(address));
            return;
        }
    }

    @Override
    public void setSubDevices(MC68000Wrapper subCpu, MegaCdSubCpuBusIntf subBus) {
        Objects.requireNonNull(subBus);
        Objects.requireNonNull(subCpu);
        this.subCpu = subCpu;
        this.subCpuBus = subBus;
    }

    @Override
    public boolean isEnableMode1() {
        return this.enableMode1;
    }

    @Override
    public void setEnableMode1(boolean enableMode1) {
        this.enableMode1 = enableMode1;
        this.maskMode1 = !enableMode1 ? 0x400000 : 0;
    }

    @Override
    public boolean isBios() {
        return this.isBios;
    }

    @Override
    public void setBios(ByteBuffer buffer) {
        this.bios = buffer;
    }

    public void logAccess(MegaCdDict.RegSpecMcd regSpec, BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size, boolean read) {
        this.logHelper.logWarningOnceWhenEnRepeat(LOG, "{} MCD reg {} {} ({}) {} {}", new Object[]{cpu, read ? "read" : "write", size, regSpec.getName(), Util.th(address), !read ? ": " + Util.th(value) : ""});
    }
}

