/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdd;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import m68k.cpu.Cpu;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.vdp.util.MemView;
import org.slf4j.Logger;

public class CdBiosHelper {
    private static final Logger LOG = LogHelper.getLogger(CdBiosHelper.class.getSimpleName());
    public static final String CDBIOS = "_CDBIOS";
    public static final String CDBOOT = "_CDBOOT";
    public static final String BURAM = "_BURAM";
    public static final String NO_ENTRY_POINT = "NONE";
    public static final String NO_FUNCTION = "ERROR";
    private static final Map<String, Integer> cdBiosEntryPointMap = new HashMap<String, Integer>();
    private static final Map<Integer, String> invCdBiosEntryPointMap;
    private static final Table<Integer, Integer, String> cdFunTable;
    private static final Map<Integer, CdMemRegion> subMemRegionMap;
    private static final Map<Integer, CdMemRegion> mainMemRegionMap;
    private static final int LOW_ENTRY;
    private static final int HIGH_ENTRY;
    public static final boolean enabled;
    private static final int MAX_AREA_SIZE = 65536;
    private static final int MAX_AREA_MASK = 65535;
    private static final int[][] memAreaHash;
    private static final StringBuilder sb;

    public static String getFunctionName(int pc, int code) {
        return cdFunTable.row((Object)pc).getOrDefault(code, NO_FUNCTION);
    }

    public static String getCdBiosEntryPointIfAny(int pc) {
        return invCdBiosEntryPointMap.getOrDefault(pc, NO_ENTRY_POINT);
    }

    public static void logCdPcInfo(int pc, Cpu m68k) {
        String res;
        if (!enabled) {
            return;
        }
        if (pc >= LOW_ENTRY && pc <= HIGH_ENTRY && (res = CdBiosHelper.getCdBiosEntryPointIfAny(pc)) != NO_ENTRY_POINT) {
            LOG.warn("calling sub_bios entry point {}({})", (Object)res, (Object)Util.th(pc));
            Map rowFunc = cdFunTable.row((Object)pc);
            if (rowFunc != null && !rowFunc.isEmpty()) {
                String fname = CdBiosHelper.getFunctionName(pc, m68k.getDataRegisterByte(0));
                assert (!NO_FUNCTION.equals(fname));
                CdBiosHelper.handleCdBiosCalls(fname, m68k);
                LOG.warn("calling fn {} #{}({})", new Object[]{res, fname, Util.th(pc)});
            }
        }
    }

    private static void handleCdBiosCalls(String fname, Cpu cpu) {
        if ("ROMREADN".equalsIgnoreCase(fname)) {
            int memAddr = cpu.getAddrRegisterLong(0);
            int firstSector = cpu.readMemoryLong(memAddr);
            int length = cpu.readMemoryLong(memAddr + 4);
            LOG.warn("CDBIOS {}, firstSector {}, length {}", new Object[]{fname, firstSector, length});
        }
    }

    private static void addToSubMemRegion(String name, int startInclusive, int len) {
        CdBiosHelper.addToMemRegion(subMemRegionMap, name, startInclusive, len);
    }

    private static void addToMainMemRegion(String name, int startInclusive, int len) {
        CdBiosHelper.addToMemRegion(mainMemRegionMap, name, startInclusive, len);
    }

    private static void addToMemRegion(Map<Integer, CdMemRegion> map, String name, int startInclusive, int len) {
        CdMemRegion r = new CdMemRegion();
        r.name = name;
        r.startInclusive = startInclusive;
        r.endInclusive = startInclusive + len;
        for (int i = startInclusive; i < r.endInclusive; ++i) {
            assert (map.get(i) == null) : name + "," + Util.th(i);
            map.put(i, r);
        }
    }

    public static void checkMainMemRegion(byte[] data, int address) {
        CdBiosHelper.checkMemRegion(BufferUtil.CpuDeviceAccess.M68K, data, address & 0xFFFFFF);
    }

    public static void checkSubMemRegion(byte[] data, int address) {
        CdBiosHelper.checkMemRegion(BufferUtil.CpuDeviceAccess.SUB_M68K, data, address);
    }

    public static void checkMemRegion(BufferUtil.CpuDeviceAccess cpu, byte[] data, int address) {
        if (!enabled) {
            return;
        }
        assert (cpu == BufferUtil.CpuDeviceAccess.M68K || cpu == BufferUtil.CpuDeviceAccess.SUB_M68K);
        Map<Integer, CdMemRegion> map = cpu == BufferUtil.CpuDeviceAccess.M68K ? mainMemRegionMap : subMemRegionMap;
        CdMemRegion r = map.get(address);
        if (r != null) {
            boolean bl = CdBiosHelper.printMemRegion(cpu, data, r);
        }
    }

    private static boolean printMemRegion(BufferUtil.CpuDeviceAccess cpu, byte[] data, CdMemRegion r) {
        boolean hasChanged;
        int startIncl = r.startInclusive & 0xFFFF;
        int endIncl = r.endInclusive & 0xFFFF;
        MemView.fillFormattedString(sb, data, startIncl, endIncl);
        int hc = sb.toString().hashCode();
        int[] areaHash = memAreaHash[cpu == BufferUtil.CpuDeviceAccess.M68K ? 0 : 1];
        boolean bl = hasChanged = areaHash[startIncl] == 0 || areaHash[startIncl] != hc;
        if (hasChanged) {
            LOG.info("{} {} update\n{}", new Object[]{cpu, r, sb});
            areaHash[startIncl] = hc;
        }
        sb.setLength(0);
        return hasChanged;
    }

    static {
        cdFunTable = HashBasedTable.create();
        subMemRegionMap = new HashMap<Integer, CdMemRegion>();
        mainMemRegionMap = new HashMap<Integer, CdMemRegion>();
        enabled = false;
        HashMap<String, Integer> cdBiosFunMap = new HashMap<String, Integer>();
        HashMap cdBootFunMap = new HashMap();
        HashMap cdBuramFunMap = new HashMap();
        HashMap<String, Integer> m = cdBiosFunMap;
        m.put("MSCSTOP", 2);
        m.put("MSCPAUSEON", 3);
        m.put("MSCPAUSEOFF", 4);
        m.put("MSCSCANFF", 5);
        m.put("MSCSCANFR", 6);
        m.put("MSCSCANOFF", 7);
        m.put("ROMPAUSEON", 8);
        m.put("ROMPAUSEOFF", 9);
        m.put("DRVOPEN", 10);
        m.put("DRVINIT", 16);
        m.put("MSCPLAY", 17);
        m.put("MSCPLAY1", 18);
        m.put("MSCPLAYR", 19);
        m.put("MSCPLAYT", 20);
        m.put("MSCSEEK", 21);
        m.put("MSCSEEKT", 22);
        m.put("ROMREAD", 23);
        m.put("ROMSEEK", 24);
        m.put("MSCSEEK1", 25);
        m.put("TESTENTRY", 30);
        m.put("TESTENTRYLOOP", 31);
        m.put("ROMREADN", 32);
        m.put("ROMREADE", 33);
        m.put("CDBCHK", 128);
        m.put("CDBSTAT", 129);
        m.put("CDBTOCWRITE", 130);
        m.put("CDBTOCREAD", 131);
        m.put("CDBPAUSE", 132);
        m.put("FDRSET", 133);
        m.put("FDRCHG", 134);
        m.put("CDCSTART", 135);
        m.put("CDCSTARTP", 136);
        m.put("CDCSTOP", 137);
        m.put("CDCSTAT", 138);
        m.put("CDCREAD", 139);
        m.put("CDCTRN", 140);
        m.put("CDCACK", 141);
        m.put("SCDINIT", 142);
        m.put("SCDSTART", 143);
        m.put("SCDSTOP", 144);
        m.put("SCDSTAT", 145);
        m.put("SCDREAD", 146);
        m.put("SCDPQ", 147);
        m.put("SCDPQL", 148);
        m.put("LEDSET", 149);
        m.put("CDCSETMODE", 150);
        m.put("WONDERREQ", 151);
        m.put("WONDERCHK", 152);
        m = cdBootFunMap;
        m.put("CBTINIT", 0);
        m.put("CBTINT", 1);
        m.put("CBTOPENDISC", 2);
        m.put("CBTOPENSTAT", 3);
        m.put("CBTCHKDISC", 4);
        m.put("CBTCHKSTAT", 5);
        m.put("CBTIPDISC", 6);
        m.put("CBTIPSTAT", 7);
        m.put("CBTSPDISC", 8);
        m.put("CBTSPSTAT", 9);
        m = cdBuramFunMap;
        m.put("BRMINIT", 0);
        m.put("BRMSTAT", 1);
        m.put("BRMSERCH", 2);
        m.put("BRMREAD", 3);
        m.put("BRMWRITE", 4);
        m.put("BRMDEL", 5);
        m.put("BRMFORMAT", 6);
        m.put("BRMDIR", 7);
        m.put("BRMVERIFY", 8);
        Map<String, Integer> m1 = cdBiosEntryPointMap;
        m1.put("_ADRERR", 24384);
        m1.put("_BOOTSTAT", 24224);
        m1.put(BURAM, 24342);
        m1.put(CDBIOS, 24354);
        m1.put(CDBOOT, 24348);
        m1.put("_CDSTAT", 24192);
        m1.put("_CHKERR", 24402);
        m1.put("_CODERR", 24390);
        m1.put("_DEVERR", 24396);
        m1.put("_LEVEL1", 24438);
        m1.put("_LEVEL2", 24444);
        m1.put("_LEVEL3(TIMER INTERRUPT)", 24450);
        m1.put("_LEVEL4", 24456);
        m1.put("_LEVEL5", 24462);
        m1.put("_LEVEL6", 24468);
        m1.put("_LEVEL7", 24474);
        m1.put("_NOCOD0", 24426);
        m1.put("_NOCOD1", 24432);
        m1.put("_SETJMPTBL", 24330);
        m1.put("_SPVERR", 24414);
        m1.put("_TRACE", 24420);
        m1.put("_TRAP00", 24480);
        m1.put("_TRAP01", 24486);
        m1.put("_TRAP02", 24492);
        m1.put("_TRAP03", 24498);
        m1.put("_TRAP04", 24504);
        m1.put("_TRAP05", 24510);
        m1.put("_TRAP06", 24516);
        m1.put("_TRAP07", 24522);
        m1.put("_TRAP08", 24528);
        m1.put("_TRAP09", 24534);
        m1.put("_TRAP10", 24540);
        m1.put("_TRAP11", 24546);
        m1.put("_TRAP12", 24552);
        m1.put("_TRAP13", 24558);
        m1.put("_TRAP14", 24564);
        m1.put("_TRAP15", 24570);
        m1.put("_TRPERR", 24408);
        m1.put("_USERCALL0(INIT)", 24360);
        m1.put("_USERCALL1(MAIN)", 24366);
        m1.put("_USERCALL2(VINT)", 24372);
        m1.put("_USERCALL3(NOT DEFINED)", 24378);
        m1.put("_USERMODE", 24230);
        m1.put("_WAITVSYNC", 24336);
        ImmutableBiMap invCdBiosFunMap = ImmutableBiMap.copyOf(cdBiosFunMap).inverse();
        ImmutableBiMap invCdBootFunMap = ImmutableBiMap.copyOf(cdBootFunMap).inverse();
        ImmutableBiMap invCdBuramFunMap = ImmutableBiMap.copyOf(cdBuramFunMap).inverse();
        CdBiosHelper.addToSubMemRegion("cddFlags0", 22538, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags1", 22539, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags2", 22540, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags3", 22541, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags4", 22542, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags5", 22543, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags6", 22544, 1);
        CdBiosHelper.addToSubMemRegion("cddFlags7", 22545, 1);
        CdBiosHelper.addToSubMemRegion("requestedTrackNumber", 22553, 1);
        CdBiosHelper.addToSubMemRegion("cddCommandWorkArea", 22570, 16);
        CdBiosHelper.addToSubMemRegion("cddCommandBuffer", 22586, 10);
        CdBiosHelper.addToSubMemRegion("cddStatusCache", 22596, 10);
        CdBiosHelper.addToSubMemRegion("cddStatusCode", 22606, 2);
        CdBiosHelper.addToSubMemRegion("cddFirstTrack", 22608, 1);
        CdBiosHelper.addToSubMemRegion("cddLastTrack", 22609, 1);
        CdBiosHelper.addToSubMemRegion("cddVersion", 22610, 2);
        CdBiosHelper.addToSubMemRegion("cddLeadOutTime", 22612, 4);
        CdBiosHelper.addToSubMemRegion("cddTocTable", 22616, 80);
        CdBiosHelper.addToSubMemRegion("cddTocCache", 23016, 4);
        CdBiosHelper.addToSubMemRegion("cddAbsFrameTime", 23020, 4);
        CdBiosHelper.addToSubMemRegion("cddRelFrameTime", 23024, 4);
        CdBiosHelper.addToSubMemRegion("currentTrackNumber", 23028, 1);
        CdBiosHelper.addToSubMemRegion("discControlCode", 23029, 1);
        CdBiosHelper.addToSubMemRegion("cddWatchdogCounter", 23042, 2);
        CdBiosHelper.addToSubMemRegion("cdcFlags0", 23046, 1);
        CdBiosHelper.addToSubMemRegion("cdcFlags1", 23047, 1);
        CdBiosHelper.addToSubMemRegion("cdcRegisterCache", 23048, 4);
        CdBiosHelper.addToSubMemRegion("cdcStatus", 23096, 2);
        CdBiosHelper.addToSubMemRegion("cdcFrameHeader", 23098, 4);
        CdBiosHelper.addToSubMemRegion("cdcStat0", 23104, 1);
        CdBiosHelper.addToSubMemRegion("cdcStat1", 23105, 1);
        CdBiosHelper.addToSubMemRegion("cdcStat2", 23106, 1);
        CdBiosHelper.addToSubMemRegion("cdcStat3", 23107, 1);
        CdBiosHelper.addToSubMemRegion("cdcRingBuffer", 23108, 60);
        CdBiosHelper.addToSubMemRegion("cdbStat", 23168, 4);
        CdBiosHelper.addToSubMemRegion("scdFlags0", 23172, 2);
        CdBiosHelper.addToSubMemRegion("scdPcktBuffer", 23184, 4);
        CdBiosHelper.addToSubMemRegion("scdPackBuffer", 23188, 4);
        CdBiosHelper.addToSubMemRegion("scdQcodBuffer", 23192, 4);
        CdBiosHelper.addToSubMemRegion("cddFaderCache", 23228, 2);
        CdBiosHelper.addToSubMemRegion("cdbCommand", 23240, 10);
        CdBiosHelper.addToSubMemRegion("cdbControlStatus", 23250, 2);
        CdBiosHelper.addToSubMemRegion("cdbResumeAddress", 23252, 4);
        CdBiosHelper.addToSubMemRegion("cdbDelayedRoutine", 23256, 4);
        CdBiosHelper.addToSubMemRegion("cdbCommandCache", 23264, 2);
        CdBiosHelper.addToSubMemRegion("cdbArg1Cache", 23266, 4);
        CdBiosHelper.addToSubMemRegion("cdbArg2Cache", 23270, 4);
        CdBiosHelper.addToSubMemRegion("cdbSpindownDelay", 23308, 2);
        CdBiosHelper.addToSubMemRegion("cbtFlags", 23332, 1);
        CdBiosHelper.addToSubMemRegion("cbtResumeAddress", 23334, 4);
        CdBiosHelper.addToSubMemRegion("cbtResumeData", 23338, 4);
        CdBiosHelper.addToSubMemRegion("cbtDeferredAddress", 23342, 4);
        CdBiosHelper.addToSubMemRegion("dataStartSector", 23346, 2);
        CdBiosHelper.addToSubMemRegion("readSectorStart", 23348, 4);
        CdBiosHelper.addToSubMemRegion("readSectorCount", 23352, 4);
        CdBiosHelper.addToSubMemRegion("readSectorLoopCount", 23356, 2);
        CdBiosHelper.addToSubMemRegion("bootHeaderAddress", 23358, 4);
        CdBiosHelper.addToSubMemRegion("ipDstAddress", 23362, 4);
        CdBiosHelper.addToSubMemRegion("spDstAddress", 23366, 4);
        CdBiosHelper.addToSubMemRegion("dataBufferAddress", 23370, 4);
        CdBiosHelper.addToSubMemRegion("headerBuffer", 23374, 4);
        CdBiosHelper.addToSubMemRegion("frameCheckValue", 23378, 1);
        CdBiosHelper.addToSubMemRegion("vBlankFlag", 24228, 1);
        CdBiosHelper.addToSubMemRegion("vblankFlag", 33599, 1);
        CdBiosHelper.addToSubMemRegion("mainCommDataCache", 33610, 16);
        CdBiosHelper.addToSubMemRegion("subCommDataBuffer", 33626, 16);
        CdBiosHelper.addToSubMemRegion("discType", 33662, 1);
        CdBiosHelper.addToSubMemRegion("biosStatus.currentStatus", 33664, 2);
        CdBiosHelper.addToSubMemRegion("biosStatus.previousStatus", 33666, 2);
        CdBiosHelper.addToSubMemRegion("biosStatus.absFrameTime", 33668, 4);
        CdBiosHelper.addToSubMemRegion("biosStatus.relFrameTime", 33672, 4);
        CdBiosHelper.addToSubMemRegion("biosStatus.trackNumber", 33676, 1);
        CdBiosHelper.addToSubMemRegion("biosStatus.flag", 33677, 1);
        CdBiosHelper.addToSubMemRegion("biosStatus.firstTrack", 33678, 1);
        CdBiosHelper.addToSubMemRegion("biosStatus.lastTrack", 33679, 1);
        CdBiosHelper.addToSubMemRegion("biosStatus.leadOutTime", 33680, 4);
        CdBiosHelper.addToSubMemRegion("biosStatus.cddStatusCode", 33684, 1);
        CdBiosHelper.addToSubMemRegion("cdcHeaderBuffer", 38552, 4);
        CdBiosHelper.addToSubMemRegion("cdcDataBuffer", 38556, 2336);
        CdBiosHelper.addToSubMemRegion("cdcDataBuffer??", 40892, 16);
        CdBiosHelper.addToSubMemRegion("oldGfxCompleteHandler", 40916, 4);
        CdBiosHelper.addToSubMemRegion("gfxCompleteFlag", 40922, 1);
        CdBiosHelper.addToSubMemRegion("gfxPrevCompleteFlag", 40923, 1);
        CdBiosHelper.addToSubMemRegion("gfxAllOpsComplete", 40926, 2);
        CdBiosHelper.addToMainMemRegion("jmpToUserVBlankHandler ", 16776616, 6);
        CdBiosHelper.addToMainMemRegion("vdpRegisterCache ", 16776628, 38);
        CdBiosHelper.addToMainMemRegion("mainCpuCommFlagCache ", 0xFFFDDE, 1);
        CdBiosHelper.addToMainMemRegion("subCpuCommFlagCache ", 0xFFFDDF, 1);
        CdBiosHelper.addToMainMemRegion("mainCpuCommRegsCache ", 16776672, 16);
        CdBiosHelper.addToMainMemRegion("subCpuCommRegsCache ", 0xFFFDF0, 16);
        CdBiosHelper.addToMainMemRegion("p1ButtonsHeld ", 16776736, 1);
        CdBiosHelper.addToMainMemRegion("p1ButtonsTapped ", 16776737, 1);
        CdBiosHelper.addToMainMemRegion("p2ButtonsHeld ", 0xFFFE22, 1);
        CdBiosHelper.addToMainMemRegion("p2ButtonsTapped ", 16776739, 1);
        CdBiosHelper.addToMainMemRegion("p1DirectionHoldTimer", 16776740, 1);
        CdBiosHelper.addToMainMemRegion("p1DirectionHoldTimer", 16776741, 1);
        CdBiosHelper.addToMainMemRegion("vBlankFlagsTemp", 16776742, 1);
        CdBiosHelper.addToMainMemRegion("userVBlankCounter", 16776743, 1);
        CdBiosHelper.addToMainMemRegion("disableVdpUpdatesAndUserVBlank", 16776744, 1);
        CdBiosHelper.addToMainMemRegion("paletteUpdateFlag", 16776745, 1);
        CdBiosHelper.addToMainMemRegion("randomRngSeed", 16776746, 2);
        CdBiosHelper.addToMainMemRegion("baseTileIdOfFont", 16776748, 2);
        CdBiosHelper.addToMainMemRegion("strideVdpPlane", 0xFFFE2E, 2);
        CdBiosHelper.addToMainMemRegion("pointerObjSpriteRamBuffer", 16776752, 4);
        CdBiosHelper.addToMainMemRegion("pointerObjIndexTable", 16776756, 4);
        CdBiosHelper.addToMainMemRegion("objSpriteLinkValue", 16776760, 2);
        CdBiosHelper.addToMainMemRegion("biosStatus", 16776762, 2);
        CdBiosHelper.addToMainMemRegion("absoluteDiscTime", 16776764, 2);
        CdBiosHelper.addToMainMemRegion("relativeDiscTime", 0xFFFE3E, 2);
        CdBiosHelper.addToMainMemRegion("endDiscTime", 16776768, 3);
        CdBiosHelper.addToMainMemRegion("currentDiscTrack", 16776771, 1);
        CdBiosHelper.addToMainMemRegion("firstDiscTrack", 0xFFFE44, 1);
        CdBiosHelper.addToMainMemRegion("lastDiscTrack", 16776773, 1);
        CdBiosHelper.addToMainMemRegion("paletteFadeInOffset", 16776774, 1);
        CdBiosHelper.addToMainMemRegion("paletteFadeInLen", 16776775, 1);
        CdBiosHelper.addToMainMemRegion("paletteFadeInIntensity", 16776776, 2);
        CdBiosHelper.addToMainMemRegion("paletteFadeInData", 16776778, 4);
        CdBiosHelper.addToMainMemRegion("msfTimeSubtractionMinuend", 0xFFFE4E, 2);
        CdBiosHelper.addToMainMemRegion("msfTimeSubtractionSubtrahend", 16776784, 2);
        invCdBiosEntryPointMap = ImmutableBiMap.copyOf(cdBiosEntryPointMap).inverse();
        invCdBiosFunMap.entrySet().stream().forEach(e -> cdFunTable.put((Object)cdBiosEntryPointMap.get(CDBIOS), (Object)((Integer)e.getKey()), (Object)((String)e.getValue())));
        invCdBootFunMap.entrySet().stream().forEach(e -> cdFunTable.put((Object)cdBiosEntryPointMap.get(CDBOOT), (Object)((Integer)e.getKey()), (Object)((String)e.getValue())));
        invCdBuramFunMap.entrySet().stream().forEach(e -> cdFunTable.put((Object)cdBiosEntryPointMap.get(BURAM), (Object)((Integer)e.getKey()), (Object)((String)e.getValue())));
        HIGH_ENTRY = (Integer)invCdBiosEntryPointMap.keySet().stream().max(Integer::compareTo).orElseThrow();
        LOW_ENTRY = (Integer)invCdBiosEntryPointMap.keySet().stream().min(Integer::compareTo).orElseThrow();
        memAreaHash = new int[2][65536];
        sb = new StringBuilder();
    }

    static class CdMemRegion {
        public String name;
        public int startInclusive;
        public int endInclusive;

        CdMemRegion() {
        }

        public String toString() {
            return this.name + " [" + Util.th(this.startInclusive) + "," + Util.th(this.endInclusive) + "]";
        }
    }
}

