/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdd;

import com.google.common.base.MoreObjects;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import mcd.cdd.CdModel;
import omegadrive.sound.msumd.CueFileParser;
import omegadrive.system.SysUtil;
import omegadrive.util.LogHelper;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.TrackData;
import org.slf4j.Logger;

public class ExtendedCueSheet
implements Closeable {
    private static final Logger LOG = LogHelper.getLogger(ExtendedCueSheet.class.getSimpleName());
    public static final String TEMPLATE_ISO_NAME_PH = "<iso_here>";
    public static final String TEMPLATE_CUE_FOR_ISO = "REM CD_ROM, 1 DATA TRACK MAPS TO ISO\nFILE \"<iso_here>\" BINARY\n  TRACK 01 MODE1/2048\n    INDEX 01 00:00:00";
    public final CueSheet cueSheet;
    public final Path cuePath;
    public SysUtil.RomFileType romFileType = SysUtil.RomFileType.UNKNOWN;
    private Optional<Path> isoPathCue = Optional.empty();
    public final List<CdModel.ExtendedTrackData> extTracks = new ArrayList<CdModel.ExtendedTrackData>();
    public int numTracks;
    public int sectorEnd;
    protected final Map<String, RandomAccessFile> fileCache = new HashMap<String, RandomAccessFile>();

    public ExtendedCueSheet(Path discImage, SysUtil.RomFileType rft) {
        Path path;
        assert (rft.isDiscImage());
        this.romFileType = rft;
        Path cp = path = discImage;
        if (rft == SysUtil.RomFileType.ISO) {
            AtomicReference<Path> ref = new AtomicReference<Path>();
            this.cueSheet = this.parseCueForIso(discImage, ref);
            this.cuePath = ref.get();
        } else {
            this.cueSheet = CueFileParser.parse(cp);
            this.cuePath = cp;
        }
        this.parseCueSheet();
        this.assertReady();
        if (this.romFileType == null || this.romFileType == SysUtil.RomFileType.UNKNOWN) {
            throw new IllegalArgumentException("Unsupported rom type: " + String.valueOf(path.toAbsolutePath()));
        }
    }

    private CueSheet parseCueForIso(Path path, AtomicReference<Path> ref) {
        CueSheet cs = null;
        Path mcp = Paths.get(path.toAbsolutePath().toString().replace(".iso", ".cue"), new String[0]);
        Path cp = path.resolveSibling(mcp);
        if (Files.exists(cp, new LinkOption[0])) {
            this.isoPathCue = Optional.of(cp);
            cs = CueFileParser.parse(this.isoPathCue.get());
            ref.set(this.isoPathCue.get());
            LOG.info("ISO file detected, using the following CUE file: {}", (Object)cp.toAbsolutePath());
        } else {
            String fakeCue = TEMPLATE_CUE_FOR_ISO.replace(TEMPLATE_ISO_NAME_PH, path.getFileName().toString());
            ByteArrayInputStream bais = new ByteArrayInputStream(fakeCue.getBytes());
            cs = CueFileParser.parse(bais);
            ref.set(path);
            LOG.info("ISO file detected, generating a synthetic CUE file: \n{}", (Object)fakeCue);
        }
        assert (cs != null);
        return cs;
    }

    private void parseCueSheet() {
        ExtendedCueSheet extCueSheet = this;
        assert (extCueSheet.fileCache.isEmpty());
        List tracks = extCueSheet.cueSheet.getAllTrackData();
        assert (!tracks.isEmpty());
        extCueSheet.numTracks = tracks.size();
        for (TrackData track : tracks) {
            this.parseTrack(extCueSheet, track.getNumber(), this.cuePath);
        }
    }

    private void parseTrack(ExtendedCueSheet extCueSheet, int trackNumber, Path cuePath) {
        TrackData trackData = ExtendedCueSheet.getTrack(extCueSheet.cueSheet, trackNumber);
        RandomAccessFile raf = ExtendedCueSheet.getDataFile(extCueSheet, trackData.getParent().getFile(), cuePath);
        CdModel.ExtendedTrackData extTrackData = new CdModel.ExtendedTrackData(trackData, raf);
        extTrackData.trackDataType = CdModel.TrackDataType.parse(trackData.getDataType());
        try {
            byte[] sec = new byte[512];
            raf.read(sec, 0, sec.length);
            List<CdModel.ExtendedTrackData> extTracks = extCueSheet.extTracks;
            int sectorStart = 0;
            if (!extTracks.isEmpty()) {
                sectorStart = extTracks.get((int)(extTracks.size() - 1)).absoluteSectorEnd;
            }
            CdModel.SectorSize sectorSize = extTrackData.trackDataType.size;
            extTrackData.lenBytes = (int)raf.length();
            extTrackData.absoluteSectorStart = sectorStart;
            extTrackData.absoluteSectorEnd = sectorStart + extTrackData.lenBytes / sectorSize.s_size;
            extTrackData.trackLenSectors = extTrackData.absoluteSectorEnd - extTrackData.absoluteSectorStart;
            extCueSheet.sectorEnd = extTrackData.absoluteSectorEnd;
            if (this.romFileType != SysUtil.RomFileType.ISO) {
                assert (sectorSize.s_size * (extTrackData.lenBytes / sectorSize.s_size) == extTrackData.lenBytes);
                assert (sectorSize.s_size >= 150);
            }
            extTracks.add(extTrackData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static RandomAccessFile getDataFile(ExtendedCueSheet extCueSheet, String key, Path file, Path cuePath) {
        if (!extCueSheet.fileCache.containsKey(key)) {
            try {
                extCueSheet.fileCache.put(key, new RandomAccessFile(file.toFile(), "r"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return extCueSheet.fileCache.get(key);
    }

    private static RandomAccessFile getDataFile(ExtendedCueSheet extCueSheet, String trackFileName, Path cuePath) {
        Path fp = cuePath.resolveSibling(trackFileName);
        String key = fp.getFileName().toString();
        return ExtendedCueSheet.getDataFile(extCueSheet, key, fp, cuePath);
    }

    private static TrackData getTrack(CueSheet cueSheet, int number) {
        assert (number > 0);
        TrackData td = (TrackData)cueSheet.getAllTrackData().get(number - 1);
        assert (td.getNumber() == number);
        return td;
    }

    public static CdModel.ExtendedTrackData getExtTrack(ExtendedCueSheet extCueSheet, int number) {
        assert (number > 0);
        int zeroBased = number - 1;
        CdModel.ExtendedTrackData td = CdModel.ExtendedTrackData.NO_TRACK;
        if (zeroBased >= 0 && zeroBased < extCueSheet.extTracks.size()) {
            td = extCueSheet.extTracks.get(zeroBased);
            assert (td.trackData.getNumber() == number);
        }
        return td;
    }

    public static boolean isAudioTrack(ExtendedCueSheet extCueSheet, int number) {
        assert (number > 0);
        return ExtendedCueSheet.getExtTrack((ExtendedCueSheet)extCueSheet, (int)number).trackDataType == CdModel.TrackDataType.AUDIO;
    }

    public byte[] getRomHeader() {
        assert (this.romFileType == SysUtil.RomFileType.BIN_CUE);
        byte[] dest = new byte[512];
        try {
            RandomAccessFile raf = this.extTracks.get((int)0).file;
            raf.seek(16L);
            raf.read(dest);
        }
        catch (Exception e) {
            LOG.error("Unable to parse MD header", (Throwable)e);
        }
        return dest;
    }

    public String toString() {
        String s = "\n\t" + this.extTracks.stream().map(Objects::toString).collect(Collectors.joining("\n\t")) + "\n";
        return MoreObjects.toStringHelper((Object)this).add("romFileType", (Object)this.romFileType).add("cueSheet", (Object)this.cueSheet).add("cuePath", (Object)this.cuePath).add("isoPath", this.isoPathCue).add("extTracks", (Object)s).add("numTracks", this.numTracks).add("sectorEnd", this.sectorEnd).toString();
    }

    public void assertReady() {
        assert (this.romFileType != null && this.romFileType != SysUtil.RomFileType.UNKNOWN);
        assert (this.cueSheet != null);
        assert (!this.extTracks.isEmpty());
        assert (this.numTracks > 0 && this.sectorEnd > 0);
        assert (!this.fileCache.isEmpty());
        assert (this.fileCache.values().stream().allMatch(r -> r.getChannel().isOpen()));
    }

    @Override
    public void close() throws IOException {
        this.extTracks.forEach(CdModel.ExtendedTrackData::closeQuietly);
        assert (this.fileCache.values().stream().noneMatch(r -> r.getChannel().isOpen()));
    }
}

