/*
 * Decompiled with CFR 0.152.
 */
package mcd.pcm;

import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.SourceDataLine;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.RegionDetector;
import omegadrive.util.SoundUtil;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.util.blipbuffer.BlipBufferIntf;
import s32x.util.blipbuffer.StereoBlipBuffer;

public class BlipPcmProvider
implements PcmProvider {
    private static final Logger LOG = LogHelper.getLogger(BlipPcmProvider.class.getSimpleName());
    private static final int BUF_SIZE_MS = 50;
    private final AtomicReference<BlipBufferContext> ref = new AtomicReference();
    private double deltaTime;
    private short prevLSample;
    private short prevRSample;
    private final SourceDataLine dataLine;
    private RegionDetector.Region region;
    private final double clockRate;
    private final ExecutorService exec;
    private final String instanceId;
    @Deprecated
    public static boolean mute = false;
    private int prevSampleAvail = 0;
    private final AtomicInteger sync = new AtomicInteger();

    public BlipPcmProvider(String name, RegionDetector.Region region, double clockRate) {
        this.ref.set(new BlipBufferContext());
        this.dataLine = SoundUtil.createDataLine(AbstractSoundManager.audioFormat);
        this.region = region;
        this.clockRate = clockRate;
        this.instanceId = name + "_" + (int)clockRate;
        this.exec = Executors.newSingleThreadExecutor(new PriorityThreadFactory(10, this.instanceId));
        this.setup();
    }

    private void setup() {
        StereoBlipBuffer blip = new StereoBlipBuffer(this.instanceId);
        blip.setSampleRate((int)AbstractSoundManager.audioFormat.getSampleRate(), 50);
        blip.setClockRate((int)this.clockRate);
        BlipBufferContext bbc = new BlipBufferContext();
        bbc.lineBuffer = new byte[0];
        bbc.blipBuffer = blip;
        this.ref.set(bbc);
        this.updateRegion(this.region);
        this.logInfo(bbc);
    }

    @Override
    public void playSample(int lsample, int rsample) {
        if (BufferUtil.assertionsEnabled) {
            if (Math.abs(lsample - this.prevLSample) > 53248) {
                LOG.info("{} L {} -> {}, absDiff: {}", new Object[]{this.instanceId, Util.th(this.prevLSample), Util.th((short)lsample), Util.th(Math.abs(lsample - this.prevLSample))});
            }
            if (Math.abs(rsample - this.prevRSample) > 53248) {
                LOG.info("{} R {} -> {}, absDiff: {}", new Object[]{this.instanceId, Util.th(this.prevRSample), Util.th((short)rsample), Util.th(Math.abs(rsample - this.prevRSample))});
            }
        }
        this.ref.get().blipBuffer.addDelta((int)this.deltaTime, (short)(lsample - this.prevLSample), (short)(rsample - this.prevRSample));
        this.prevLSample = (short)lsample;
        this.prevRSample = (short)rsample;
        this.deltaTime += 1.0;
    }

    @Override
    public int updateStereo16(int[] buf_lr, int offset, int countMono) {
        LogHelper.logWarnOnce(LOG, "{} Ignoring sample requests, using its own dataLine", this.instanceId);
        return countMono << 1;
    }

    @Override
    public void newFrame() {
        BlipBufferContext context = this.ref.get();
        BlipBufferIntf blip = context.blipBuffer;
        if (blip == null) {
            return;
        }
        assert (context.inputClocksForInterval.get() > 0);
        blip.endFrame(context.inputClocksForInterval.get());
        this.deltaTime = 0.0;
        int availMonoSamples = blip.samplesAvail();
        if (availMonoSamples + 5 < this.prevSampleAvail) {
            LOG.info("{} Audio underrun : {} -> {} samples", new Object[]{this.instanceId, this.prevSampleAvail, availMonoSamples});
        }
        if (context.lineBuffer.length < availMonoSamples << 2) {
            LOG.info("{} Audio buffer size: {} -> {} bytes", new Object[]{this.instanceId, context.lineBuffer.length, availMonoSamples << 2});
            context.lineBuffer = new byte[availMonoSamples << 2];
        }
        long current = this.sync.incrementAndGet();
        int stereoBytes = blip.readSamples16bitStereo(context.lineBuffer, 0, availMonoSamples) << 2;
        if (stereoBytes > 0 && !mute) {
            this.exec.submit(Util.wrapRunnableEx(() -> {
                SoundUtil.writeBufferInternal(this.dataLine, context.lineBuffer, 0, stereoBytes);
                if (BufferUtil.assertionsEnabled && current != (long)this.sync.get()) {
                    LOG.info("{} Blip audio thread too slow: {} vs {}", new Object[]{this.instanceId, current, this.sync.get()});
                }
            }));
        }
        this.prevSampleAvail = availMonoSamples;
    }

    @Override
    public void updateRegion(RegionDetector.Region region) {
        this.region = region;
        BlipBufferContext ctx = this.ref.get();
        ctx.inputClocksForInterval.set((int)(1.0 * (double)ctx.blipBuffer.clockRate() * region.getFrameIntervalMs() / 1000.0));
    }

    private void logInfo(BlipBufferContext ctx) {
        int outSamplesPerInterval = (int)((double)(AbstractSoundManager.audioFormat.getSampleRate() * 50.0f) / 1000.0);
        int inSamplesPerInterval = (int)((double)(ctx.blipBuffer.clockRate() * 50) / 1000.0);
        LOG.info("{}: {}\nOutput sampleRate: {}, Input sampleRate: {}, outputBufLenMs: {}, outputBufLenSamples: {}, inputBufLenSamples: {}", new Object[]{this.instanceId, ctx, Float.valueOf(AbstractSoundManager.audioFormat.getSampleRate()), ctx.blipBuffer.clockRate(), 50, outSamplesPerInterval, inSamplesPerInterval});
    }

    @Override
    public void close() {
        SoundUtil.close(this.dataLine);
        this.exec.shutdown();
    }

    @Override
    public void reset() {
        LOG.warn("TODO reset");
    }

    static class BlipBufferContext {
        BlipBufferIntf blipBuffer;
        byte[] lineBuffer;
        AtomicInteger inputClocksForInterval = new AtomicInteger();

        BlipBufferContext() {
        }

        public String toString() {
            return new StringJoiner(", ", BlipBufferContext.class.getSimpleName() + "[", "]").add("inputClocksForInterval=" + String.valueOf(this.inputClocksForInterval)).toString();
        }
    }
}

