/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.vdp.util.MemView;
import org.slf4j.Logger;

public class BuramHelper {
    private static final Logger LOG = LogHelper.getLogger(BuramHelper.class.getSimpleName());
    public static final byte[] BRAM_FORMAT_TAIL = new byte[]{83, 69, 71, 65, 95, 67, 68, 95, 82, 79, 77, 0, 1, 0, 0, 0, 82, 65, 77, 95, 67, 65, 82, 84, 82, 73, 68, 71, 69, 95, 95, 95};

    public static void main(String[] args) {
        ByteBuffer bb = ByteBuffer.allocate(8192);
        BuramHelper.check_format_bram(bb);
        BuramHelper.check_format_bram(bb);
        StringBuilder sb = new StringBuilder();
        MemView.fillFormattedString(sb, bb.array(), 0, bb.capacity());
        System.out.println(sb);
    }

    public static void check_format_bram(ByteBuffer buffer) {
        byte[] data = new byte[BRAM_FORMAT_TAIL.length];
        buffer.get(buffer.capacity() - BRAM_FORMAT_TAIL.length, data);
        if (!Arrays.equals(BRAM_FORMAT_TAIL, data)) {
            LOG.info("Formatting internal BRAM");
            BuramHelper.segacd_format_bram(buffer);
        }
    }

    public static int readBackupRam(ByteBuffer buffer, int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.BYTE -> {
                if ((address & 1) == 1) {
                    yield BufferUtil.readBuffer(buffer, (address & 0x3FFF) >> 1, Size.BYTE);
                }
                yield size.getMask();
            }
            case Size.WORD -> {
                if (!$assertionsDisabled && (address & 1) != 0) {
                    throw new AssertionError();
                }
                yield BufferUtil.readBuffer(buffer, (address & 0x3FFF) >> 1, Size.BYTE);
            }
            case Size.LONG -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield size.getMask();
            }
        };
    }

    public static void writeBackupRam(ByteBuffer buffer, int address, int data, Size size) {
        switch (size) {
            case BYTE: {
                if ((address & 1) != 1) break;
                BufferUtil.writeBufferRaw(buffer, (address & 0x3FFF) >> 1, data, Size.BYTE);
                break;
            }
            case WORD: {
                assert ((address & 1) == 0);
                BufferUtil.writeBufferRaw(buffer, (address & 0x3FFF) >> 1, data, Size.BYTE);
                break;
            }
            case LONG: {
                assert (false);
                break;
            }
        }
    }

    public static void segacd_format_bram(ByteBuffer buffer) {
        int len = buffer.capacity();
        for (int i = 0; i < len; ++i) {
            buffer.put(i, (byte)0);
        }
        int free_blocks = len / 64 - 3;
        int pos = len - 64;
        buffer.position(pos);
        buffer.put("___________".getBytes());
        buffer.position(buffer.position() + 4);
        buffer.put((byte)64);
        for (int i = 0; i < 4; ++i) {
            buffer.put((byte)(free_blocks >> 8));
            buffer.put((byte)free_blocks);
        }
        buffer.position(buffer.position() + 8);
        buffer.put(BRAM_FORMAT_TAIL);
    }
}

