/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import com.google.common.collect.ObjectArrays;
import java.util.function.BiFunction;
import mcd.McdDeviceHelper;
import mcd.bus.McdWordRamHelper;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.memory.ReadableByteMemory;
import omegadrive.util.BufferUtil;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.util.MemView;
import omegadrive.vdp.util.UpdatableViewer;
import omegadrive.vdp.util.VdpDebugView;

public class McdMemView
extends MemView {
    public static final MemView.MemViewData[] mcdMemViewData = (MemView.MemViewData[])ObjectArrays.concat((Object[])mdMemViewData, (Object[])McdMemViewType.values(), MemView.MemViewData.class);
    private static final int WAVE_DATA_OFFSET = -1442840576;
    private static final int WAVE_DATA_START = -1442840576;
    private static final int WAVE_DATA_END = -1442775040;
    private static final int WAVE_DATA_MASK = 65535;

    public static UpdatableViewer createInstance(MdMainBusProvider m, McdDeviceHelper.McdLaunchContext ctx, VdpMemoryInterface vdpMem) {
        return VdpDebugView.DEBUG_VIEWER_ENABLED ? new McdMemView(m, ctx, vdpMem) : NO_MEMVIEW;
    }

    protected McdMemView(MdMainBusProvider m, McdDeviceHelper.McdLaunchContext ctx, VdpMemoryInterface vdpMem) {
        super(mcdMemViewData, m, McdMemView.getReader(ctx), vdpMem);
    }

    private static ReadableByteMemory getReader(McdDeviceHelper.McdLaunchContext ctx) {
        return (a, size) -> {
            int res = 0;
            if (a >= 786432 && a < 917504) {
                res = Util.readDataMask(ctx.memoryContext.wordRam01[0], a, 131071, size);
            } else if (a >= 917504 && a < 0x100000) {
                res = Util.readDataMask(ctx.memoryContext.wordRam01[1], a, 131071, size);
            } else if (a >= 0 && a < 524288) {
                res = Util.readDataMask(ctx.memoryContext.prgRam, a, 524287, size);
            } else if (a >= -1442840576 && a < -1442775040) {
                res = BufferUtil.readBuffer(ctx.pcm.getWaveData(), a & 0xFFFF, size);
            } else if (a >= 524288 && a < 786432) {
                int addr = a & 0xFFFFFFFE;
                res = ctx.memoryContext.wramHelper.readWordRamBank(McdWordRamHelper.getBank(MegaCdMemoryContext.WramSetup.W_2M_SUB, BufferUtil.CpuDeviceAccess.SUB_M68K, addr), addr);
                if ((a & 1) == 0) {
                    res >>= 8;
                }
            }
            return res & size.getMask();
        };
    }

    @Override
    protected void doMemoryRead(MemView.MemViewData current, int len, BiFunction<MemView.MemViewData, Integer, Integer> readerFn) {
        int v = MdRuntimeData.getCpuDelayExt();
        super.doMemoryRead(current, len, readerFn);
    }

    static enum McdMemViewType implements MemView.MemViewData
    {
        MCD_PRG_RAM(MemView.MemViewOwner.MCD_SUB_CPU, 0, 524288),
        MCD_WRAM0(MemView.MemViewOwner.MCD_SUB_CPU, 786432, 917504),
        MCD_WRAM1(MemView.MemViewOwner.MCD_SUB_CPU, 917504, 0x100000),
        MCD_WRAM_2M(MemView.MemViewOwner.MCD_SUB_CPU, 524288, 786432),
        MCD_PCM_WAVE_DATA(MemView.MemViewOwner.MCD_SUB_CPU, -1442840576, -1442775040);

        public final int start;
        public final int end;
        public final MemView.MemViewOwner owner;

        private McdMemViewType(MemView.MemViewOwner c, int s, int e) {
            this.start = s;
            this.end = e;
            this.owner = c;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public MemView.MemViewOwner getOwner() {
            return this.owner;
        }
    }
}

