/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.S32xDict;

public class Md32xCommHelper {
    private static final Logger LOG = LogHelper.getLogger(Md32xCommHelper.class.getSimpleName());
    public static final int CYCLE_LOOKBACK = 50;
    private static Md32xCommHelper INSTANCE = new Md32xCommHelper();
    long currentFrame = 0L;
    private Table<Integer, S32xDict.RegSpecS32x, CommWriteInfo> t = TreeBasedTable.create();
    AtomicInteger currentCyclePrev = new AtomicInteger(-1);

    public static Md32xCommHelper getInstance() {
        return INSTANCE;
    }

    public void write(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int prevValue, int nextValue, Size size) {
        switch (size) {
            case BYTE: 
            case WORD: {
                this.writeWord(cpu, regSpec, prevValue, nextValue);
                break;
            }
            case LONG: {
                S32xDict.RegSpecS32x regSpec2 = S32xDict.getRegSpec(cpu, regSpec.addr + 2);
                this.writeWord(cpu, regSpec, prevValue >> 16, nextValue >> 16);
                this.writeWord(cpu, regSpec2, prevValue & 0xFFFF, nextValue & 0xFFFF);
            }
        }
    }

    private void writeWord(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int prevValue, int nextValue) {
        assert (MdRuntimeData.getAccessTypeExt() == cpu);
        SystemProvider.SystemClock clock = MdRuntimeData.getSystemClockExt();
        CommWriteInfo cwi = new CommWriteInfo();
        cwi.frame = clock.getFrameCounter();
        cwi.cycle = clock.getCycleCounter() + MdRuntimeData.getCpuDelayExt();
        cwi.cpu = cpu;
        cwi.regSpec = regSpec;
        cwi.size = Size.WORD;
        cwi.prevValue = prevValue & cwi.size.getMask();
        cwi.value = nextValue & cwi.size.getMask();
        if (this.currentFrame != cwi.frame) {
            this.t.clear();
            this.currentFrame = cwi.frame;
        }
        this.dropOldWrites(cwi.cycle);
        this.t.put((Object)cwi.cycle, (Object)regSpec, (Object)cwi);
        if (cpu == BufferUtil.CpuDeviceAccess.SLAVE && regSpec == S32xDict.RegSpecS32x.COMM1 && cwi.value == 225) {
            System.out.println("here");
        }
    }

    private void dropOldWrites(int cycle) {
        Iterator it = this.t.cellSet().iterator();
        while (it.hasNext()) {
            Table.Cell cell = (Table.Cell)it.next();
            if (cycle - (Integer)cell.getRowKey() <= 50) continue;
            it.remove();
        }
    }

    public int read(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int res, Size size) {
        int w1;
        if (size == Size.LONG) {
            w1 = this.readWord(cpu, regSpec, res >> 16);
            S32xDict.RegSpecS32x regSpec2 = S32xDict.getRegSpec(cpu, regSpec.addr + 2);
            int w2 = this.readWord(cpu, regSpec2, res & 0xFFFF);
            w1 = w1 << 16 & 0xFFFF0000 | w2 & 0xFFFF;
        } else {
            w1 = this.readWord(cpu, regSpec, res);
        }
        return w1;
    }

    private int readWord(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int res) {
        SystemProvider.SystemClock clock = MdRuntimeData.getSystemClockExt();
        long frame = clock.getFrameCounter();
        if (frame > this.currentFrame) {
            this.t.clear();
            return res;
        }
        int cycle = clock.getCycleCounter() + MdRuntimeData.getCpuDelayExt();
        this.currentCyclePrev.set(-1);
        AtomicReference refCell = new AtomicReference();
        this.t.cellSet().forEach(cell -> {
            int cellCycle = (Integer)cell.getRowKey();
            if (regSpec == cell.getColumnKey() && cycle - cellCycle < 50 && cycle < cellCycle && cellCycle > this.currentCyclePrev.get()) {
                refCell.set(cell);
                this.currentCyclePrev.set(cellCycle);
            }
        });
        int val = res;
        if (refCell.get() != null) {
            val = ((CommWriteInfo)((Table.Cell)refCell.get()).getValue()).prevValue;
            LOG.info("{} {} {}, Should be using value: {}\n{}", new Object[]{cpu, cycle, regSpec, Util.th(val), refCell});
        }
        return val;
    }

    static class CommWriteInfo {
        public BufferUtil.CpuDeviceAccess cpu;
        public S32xDict.RegSpecS32x regSpec;
        public int value;
        public int prevValue;
        public Size size;
        public int cycle;
        public long frame;

        CommWriteInfo() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cpu", (Object)this.cpu).add("regSpec", (Object)this.regSpec).add("value", (Object)Util.th(this.value)).add("prevValue", (Object)Util.th(this.prevValue)).add("size", (Object)this.size).add("cycle", this.cycle).add("frame", this.frame).toString();
        }
    }
}

