/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.md;

import omegadrive.bus.md.BusArbiter;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;

class BusArbiterImpl
implements BusArbiter {
    private static final Logger LOG = LogHelper.getLogger(BusArbiter.class.getSimpleName());
    private static final boolean verbose = false;
    private int vdpLevel = 0;
    private BusArbiter.IntState int68k = BusArbiter.IntState.NONE;
    private MdVdpProvider.VdpBusyState vdpBusyState = MdVdpProvider.VdpBusyState.NOT_BUSY;
    private BusArbiter.CpuState state68k = BusArbiter.CpuState.RUNNING;
    private BusArbiter.IntState z80Int = BusArbiter.IntState.NONE;
    private BusArbiter.InterruptEvent z80IntLineVdp = BusArbiter.InterruptEvent.Z80_INT_OFF;
    protected MdVdpProvider vdp;
    protected M68kProvider m68k;
    protected Z80Provider z80;
    private Runnable runLater68k;
    private boolean hip;
    private boolean vip;
    private int ieVdp;
    private boolean vint;
    private boolean hint;
    private boolean anyHint;

    protected BusArbiterImpl() {
    }

    @Override
    public MdVdpProvider.VdpBusyState getVdpBusyState() {
        return this.vdpBusyState;
    }

    @Override
    public void setVdpBusyState(MdVdpProvider.VdpBusyState state) {
        if (this.vdpBusyState != state) {
            this.state68k = state == MdVdpProvider.VdpBusyState.MEM_TO_VRAM ? BusArbiter.CpuState.HALTED : BusArbiter.CpuState.RUNNING;
            this.vdpBusyState = state;
            if (this.state68k == BusArbiter.CpuState.RUNNING && this.vdpBusyState == MdVdpProvider.VdpBusyState.NOT_BUSY && this.runLater68k != null) {
                Runnable runnable = this.runLater68k;
                this.runLater68k = null;
                runnable.run();
            }
        }
    }

    @Override
    public void handleInterrupts(BufferUtil.CpuDeviceAccess cpu) {
        switch (cpu) {
            case M68K: {
                this.handleInterrupts68k();
                break;
            }
            case Z80: {
                this.handleInterruptZ80();
                break;
            }
            default: {
                LOG.error("Unable to handle interrupts: {}", (Object)cpu);
            }
        }
    }

    private void handleInterruptZ80() {
        boolean vIntExpired;
        boolean bl = vIntExpired = this.z80Int == BusArbiter.IntState.ASSERTED && this.z80IntLineVdp == BusArbiter.InterruptEvent.Z80_INT_OFF;
        if (this.z80IntLineVdp == BusArbiter.InterruptEvent.Z80_INT_ON) {
            this.raiseInterruptsZ80();
        } else if (vIntExpired) {
            this.resetZ80Int();
        }
    }

    private void resetZ80Int() {
        this.z80Int = BusArbiter.IntState.NONE;
        this.z80.interrupt(false);
    }

    private void raiseInterruptsZ80() {
        this.z80.interrupt(true);
        if (this.z80Int != BusArbiter.IntState.ASSERTED) {
            this.z80Int = BusArbiter.IntState.ASSERTED;
        }
    }

    @Override
    public boolean is68kRunning() {
        return this.state68k == BusArbiter.CpuState.RUNNING;
    }

    private void setZ80Int(BusArbiter.InterruptEvent event) {
        this.z80IntLineVdp = event;
    }

    @Override
    public void addCyclePenalty(BusArbiter.CpuType cpuType, int value) {
        switch (cpuType) {
            case M68K: {
                this.m68k.addCyclePenalty(value);
                break;
            }
            case Z80: {
                this.z80.addCyclePenalty(value);
            }
        }
    }

    private void handleInterrupts68k() {
        switch (this.int68k) {
            case NONE: {
                this.checkInterrupts68k();
                break;
            }
            case PENDING: {
                this.raiseInterrupts68k();
            }
        }
    }

    private void raiseInterrupts68k() {
        boolean res = this.m68k.raiseInterrupt(this.getLevel68k());
    }

    @Override
    public void ackInterrupt68k(int level) {
        int ackLevel = this.vdpLevel | level;
        if (ackLevel != level) {
            LOG.warn("68k level: {} but vdp thinks: {}, setting {}=false", new Object[]{level, ackLevel, ackLevel == 6 ? "vip" : "hip"});
        }
        switch (ackLevel) {
            case 6: {
                this.vdp.setVip(false);
                this.vdpLevel = 0;
                break;
            }
            case 4: {
                this.vdp.setHip(false);
                this.vdpLevel = 0;
                break;
            }
            default: {
                LOG.error("Unexpected vdpLevel {}, 68kLevel: {}", (Object)this.vdpLevel, (Object)level);
            }
        }
        this.int68k = BusArbiter.IntState.NONE;
    }

    private void checkInterrupts68k() {
        if (this.anyHint) {
            this.int68k = BusArbiter.IntState.PENDING;
            this.vdpLevel |= this.vint ? 6 : (this.hint ? 4 : 0);
        }
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        boolean doRecalc = false;
        switch (event) {
            case INTERRUPT: {
                BusArbiter.InterruptEvent ievent = (BusArbiter.InterruptEvent)((Object)value);
                this.setZ80Int(ievent);
                break;
            }
            case VDP_VINT_PENDING: {
                this.vip = (Boolean)value;
                doRecalc = true;
                break;
            }
            case VDP_HINT_PENDING: {
                this.hip = (Boolean)value;
                doRecalc = true;
                break;
            }
            case VDP_IE0_VINT: 
            case VDP_IE1_HINT: 
            case VDP_IE2_EXT_INT: {
                this.ieVdp = Util.setBit(this.ieVdp, MdVdpProvider.eventMap.get((Object)event).ordinal(), (Boolean)value != false ? 1 : 0);
                doRecalc = true;
            }
        }
        if (doRecalc) {
            this.recalc();
        }
    }

    private void recalc() {
        this.hint = Util.bitSetTest(this.ieVdp, MdVdpProvider.VDP_INT.IE1.ordinal()) && this.hip;
        this.vint = Util.bitSetTest(this.ieVdp, MdVdpProvider.VDP_INT.IE0.ordinal()) && this.vip;
        this.anyHint = this.hint || this.vint;
    }

    @Override
    public void runLater68k(Runnable r) {
        this.runLater68k = r;
        this.state68k = BusArbiter.CpuState.HALTED;
    }

    private int getLevel68k() {
        return this.vint ? 6 : (this.hint ? 4 : 0);
    }

    private void logInfo(String str, Object ... args) {
        LOG.info("{}{}", (Object)LogHelper.formatMessage(str, args), (Object)this.vdp.getVdpStateString());
    }
}

