/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.md;

import omegadrive.Device;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.md.BusArbiter;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.bus.model.MdZ80BusProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.memory.IMemoryRam;
import omegadrive.sound.fm.FmProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MdZ80BusProviderImpl
extends DeviceAwareBus
implements MdZ80BusProvider {
    private static final Logger LOG = LogHelper.getLogger(MdZ80BusProviderImpl.class.getSimpleName());
    private static final boolean verbose = false;
    private int romBank68kSerial;
    private MdMainBusProvider mainBusProvider;
    private BusArbiter busArbiter;
    private FmProvider fmProvider;
    private byte[] ram;
    private int ramMask;

    @Override
    public BaseBusProvider attachDevice(Device device) {
        if (device instanceof MdMainBusProvider) {
            this.mainBusProvider = (MdMainBusProvider)device;
            this.mainBusProvider.getBusDeviceIfAny(BusArbiter.class).ifPresent(this::attachDevice);
        }
        if (device instanceof IMemoryRam) {
            IMemoryRam z80Memory = (IMemoryRam)device;
            this.ram = z80Memory.getRamData();
            this.ramMask = this.ram.length - 1;
        }
        if (device instanceof BusArbiter) {
            this.busArbiter = (BusArbiter)device;
        }
        super.attachDevice(device);
        return this;
    }

    @Override
    public int read(int address, Size size) {
        assert (size == Size.BYTE);
        int data = 255;
        if (address <= 16383) {
            data = this.ram[address & this.ramMask];
        } else if (address >= 16384 && address <= 24575) {
            if (this.mainBusProvider.isZ80ResetState()) {
                LOG.warn("FM read while Z80 reset");
                data = 1;
            } else {
                data = this.getFm().read();
            }
        } else if (address >= 24576 && address <= 32511) {
            LogHelper.logWarnOnce(LOG, "Z80 read bank switching/unused: {}", Util.th(address));
        } else if (address >= 32512 && address <= 32543) {
            int vdpAddress = 0xC00000 + address;
            data = this.mainBusProvider.read(vdpAddress, Size.BYTE);
        } else if (address >= 32768 && address <= 65535) {
            this.busArbiter.addCyclePenalty(BusArbiter.CpuType.Z80, 4);
            this.busArbiter.addCyclePenalty(BusArbiter.CpuType.M68K, 11);
            int addressB = this.romBank68kSerial | address & Short.MAX_VALUE;
            if (addressB >= 0xE00000 && addressB < 0xFFFFFF) {
                LOG.warn("Z80 reading from 68k RAM");
            } else {
                data = this.mainBusProvider.read(addressB, Size.BYTE);
            }
        } else {
            LOG.error("Illegal Z80 memory read: {}", (Object)Util.th(address));
        }
        return data;
    }

    @Override
    public void write(int address, int dataInt, Size size) {
        assert (size == Size.BYTE);
        if (address <= 16383) {
            this.ram[address & this.ramMask] = (byte)dataInt;
        } else if (address >= 16384 && address <= 24575) {
            if (this.mainBusProvider.isZ80ResetState()) {
                LOG.warn("Illegal write to FM while Z80 reset");
                return;
            }
            this.getFm().write(address, dataInt);
        } else if (address >= 24576 && address <= 24831) {
            this.romBanking(dataInt);
        } else if (address >= 24832 && address <= 32511) {
            LOG.warn("Write to unused memory: {}", (Object)Util.th(address));
        } else if (address >= 32512 && address <= 32543) {
            int vdpAddress = 0xC00000 + address;
            this.mainBusProvider.write(vdpAddress, dataInt, Size.BYTE);
        } else if (address > 32543 && address <= Short.MAX_VALUE) {
            LOG.error("Machine should be locked, write to address: {}", (Object)Util.th(address));
        } else if (address >= 32768 && address <= 65535) {
            this.busArbiter.addCyclePenalty(BusArbiter.CpuType.Z80, 4);
            this.busArbiter.addCyclePenalty(BusArbiter.CpuType.M68K, 11);
            this.mainBusProvider.write(this.romBank68kSerial | address & Short.MAX_VALUE, dataInt, Size.BYTE);
        } else {
            LOG.error("Illegal Z80 memory write:  {}, {}", (Object)Util.th(address), (Object)dataInt);
        }
    }

    private FmProvider getFm() {
        if (this.fmProvider == null) {
            this.fmProvider = this.mainBusProvider.getFm();
            assert (this.busArbiter != BusArbiter.NO_OP);
        }
        return this.fmProvider;
    }

    @Override
    public void reset() {
        super.reset();
        this.romBank68kSerial = 0;
    }

    private void romBanking(int data) {
        this.romBank68kSerial = (this.romBank68kSerial >> 1 | (data & 1) << 23) & 0xFF8000;
    }

    @Override
    public void setRomBank68kSerial(int romBank68kSerial) {
        this.romBank68kSerial = romBank68kSerial;
    }

    @Override
    public int getRomBank68kSerial() {
        return this.romBank68kSerial;
    }

    @Override
    public void handleInterrupts(Z80Provider.Interrupt type) {
        LOG.warn("Ignored Z80 interrupt: {} ", (Object)type);
    }
}

