/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import omegadrive.cart.MediaInfoProvider;
import omegadrive.cart.header.MdHeader;
import omegadrive.cart.loader.MdLoader;
import omegadrive.cart.loader.MdRomDbModel;
import omegadrive.cart.mapper.md.MdMapperType;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MdCartInfoProvider
extends MediaInfoProvider {
    public static final MdHeader.MdRomHeaderField[] rhf = MdHeader.MdRomHeaderField.values();
    public static final long DEFAULT_SRAM_START_ADDRESS = 0x200000L;
    public static final long DEFAULT_SRAM_END_ADDRESS = 0x20FFFFL;
    public static final int DEFAULT_SRAM_BYTE_SIZE = 65536;
    public static final int SVP_SV_TOKEN_ADDRESS = MdHeader.MdRomHeaderField.RESERVED1.startOffset;
    public static final String SVP_SV_TOKEN = "SV";
    private static final Logger LOG = LogHelper.getLogger(MdCartInfoProvider.class.getSimpleName());
    public static final int SRAM_FLAG_ADDRESS = MdHeader.MdRomHeaderField.EXTRA_MEMORY.startOffset;
    public static final int SRAM_START_ADDRESS = 436;
    public static final int SRAM_END_ADDRESS = 440;
    public static final String EXTERNAL_RAM_FLAG_VALUE = "RA";
    public static final int HEADER_SIZE = 512;
    private ByteBuffer headerBuf;
    private long sramStart;
    private long sramEnd;
    private boolean sramEnabled;
    private String systemType;
    private String region = "";
    private Set<MdHeader.DeviceSupportField> deviceSupport = Collections.emptySet();
    private String headerInfo = "";
    private MdMapperType forceMapper = null;
    private MdRomDbModel.RomDbEntry entry = MdRomDbModel.NO_ENTRY;
    private boolean isSvp;
    private String serial = "MISSING";
    public static final MdCartInfoProvider NO_PROVIDER = new MdCartInfoProvider();

    public int getSramSizeBytes() {
        return (int)(this.sramEnd - this.sramStart + 1L);
    }

    public boolean isSramEnabled() {
        return this.sramEnabled;
    }

    @Override
    public int getChecksumStartAddress() {
        return MdHeader.MdRomHeaderField.ROM_CHECKSUM.startOffset;
    }

    @Override
    protected void init() {
        super.init();
        this.initMemoryLayout();
        this.entry = MdLoader.getEntry(this.serial);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.systemType).append(", serial: ").append(this.serial);
        sb.append(", SRAM flag: ").append(this.sramEnabled).append("\n");
        sb.append(super.toString());
        if (this.sramEnabled) {
            sb.append("\nSRAM size: ").append(this.getSramSizeBytes()).append(" bytes, start-end: ").append(Util.th(this.sramStart)).append(" - ").append(Util.th(this.sramEnd));
        }
        if (this.entry != MdRomDbModel.NO_ENTRY) {
            sb.append("\n").append(this.entry);
        }
        return sb.append(this.headerInfo).toString();
    }

    public static MdCartInfoProvider createMdInstance(RandomAccessFile raf) {
        MdCartInfoProvider m = new MdCartInfoProvider(raf);
        m.init();
        return m;
    }

    public static MdCartInfoProvider createMdInstance(byte[] header) {
        assert (header.length >= 512);
        MdCartInfoProvider m = new MdCartInfoProvider();
        m.headerBuf = ByteBuffer.wrap(header, 0, 512);
        m.init();
        m.romSize = header.length;
        return m;
    }

    protected MdCartInfoProvider() {
    }

    protected MdCartInfoProvider(RandomAccessFile raf) {
        byte[] hd = new byte[512];
        try {
            raf.seek(0L);
            raf.read(hd);
            this.headerBuf = ByteBuffer.wrap(hd);
            this.romSize = (int)raf.length();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSramUsedWithBrokenHeader(long address) {
        boolean noOverlapBetweenRomAndSram = 0x200001L > (long)this.romSize;
        return noOverlapBetweenRomAndSram && address >= 0x200000L && address <= 0x20FFFFL;
    }

    public String getSerial() {
        return this.serial;
    }

    private void initMemoryLayout() {
        this.detectHeaderMetadata(this.headerBuf.array());
        this.detectSram();
    }

    private void detectSram() {
        Object sramFlag = String.valueOf((char)this.headerBuf.get(SRAM_FLAG_ADDRESS));
        boolean externalRamEnabled = EXTERNAL_RAM_FLAG_VALUE.equals(sramFlag = (String)sramFlag + (char)this.headerBuf.get(SRAM_FLAG_ADDRESS + 1));
        if (externalRamEnabled) {
            boolean isSramType;
            byte byte1 = this.headerBuf.get(SRAM_FLAG_ADDRESS + 2);
            byte byte2 = this.headerBuf.get(SRAM_FLAG_ADDRESS + 3);
            boolean isBackup = Util.bitSetTest(byte1, 7);
            boolean bl = isSramType = (byte2 & 0x20) == 32;
            if (isBackup) {
                this.sramEnabled = true;
                this.sramStart = Util.readData(this.headerBuf.array(), 436, Size.LONG);
                this.sramEnd = Util.readData(this.headerBuf.array(), 440, Size.LONG);
                if (this.sramEnd - this.sramStart < 0L) {
                    LOG.error("Unexpected SRAM setup: {}", (Object)this);
                    this.sramStart = 0x200000L;
                    this.sramEnd = 0x20FFFFL;
                }
            } else if (isSramType) {
                LOG.warn("Volatile SRAM? {}", (Object)"TODO romName");
            }
        }
    }

    private void detectHeaderMetadata(byte[] romHeader) {
        int send = MdHeader.MdRomHeaderField.SERIAL_NUMBER.startOffset + MdHeader.MdRomHeaderField.SERIAL_NUMBER.len;
        if (romHeader.length < send) {
            return;
        }
        assert (romHeader.length >= 512);
        StringBuilder sb = new StringBuilder("\nRom header:\n");
        for (MdHeader.MdRomHeaderField f : rhf) {
            Object sv = f.getStringView(romHeader);
            if (f == MdHeader.MdRomHeaderField.DEVICE_SUPPORT) {
                this.processDeviceSupport(romHeader);
                if (!this.deviceSupport.isEmpty()) {
                    sv = (String)sv + "\n\t" + Arrays.toString(this.deviceSupport.stream().map(df -> df.explain).toArray());
                }
            }
            sb.append((String)sv).append("\n");
        }
        this.headerInfo = sb.toString();
        this.systemType = MdHeader.MdRomHeaderField.SYSTEM_TYPE.getValue(romHeader).trim();
        this.region = MdHeader.MdRomHeaderField.REGION_SUPPORT.getValue(romHeader);
        this.forceMapper = MdMapperType.getMdMapperType(this.systemType);
        this.serial = MdHeader.MdRomHeaderField.SERIAL_NUMBER.getValue(romHeader);
        if (romHeader.length > SVP_SV_TOKEN_ADDRESS + 1) {
            this.isSvp = SVP_SV_TOKEN.equals(new String(romHeader, SVP_SV_TOKEN_ADDRESS, 2).trim());
        }
    }

    private void processDeviceSupport(byte[] romHeader) {
        String str = MdHeader.MdRomHeaderField.DEVICE_SUPPORT.getValue(romHeader).trim();
        LinkedHashSet set = new LinkedHashSet();
        for (int i = 0; i < str.length(); ++i) {
            String s = "" + str.charAt(i);
            if (s.trim().isEmpty()) continue;
            MdHeader.DeviceSupportField.getDeviceMappingIfAny(s).ifPresent(set::add);
        }
        this.deviceSupport = Collections.unmodifiableSet(set);
    }

    public MdRomDbModel.RomDbEntry getEntry() {
        return this.entry;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public boolean isSsfMapper() {
        return this.forceMapper != null;
    }

    public boolean isSvp() {
        return this.isSvp;
    }

    public Set<MdHeader.DeviceSupportField> getDeviceSupport() {
        return this.deviceSupport;
    }

    public boolean adjustSramLimits(long address) {
        boolean adjust = this.sramEnd < 0x20FFFFL;
        if (adjust &= address > this.sramEnd && address < 0x20FFFFL) {
            LOG.warn("Adjusting SRAM limit from: {} to: {}", (Object)Util.th(this.sramEnd), (Object)Util.th(0x20FFFFL));
            this.sramEnd = 0x20FFFFL;
        }
        return adjust;
    }
}

