/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.cheat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import omegadrive.cart.cheat.BasicMdRawCode;
import omegadrive.cart.cheat.GameGenieHelper;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class CheatCodeHelper {
    private static final Logger LOG = LogHelper.getLogger(CheatCodeHelper.class.getSimpleName());
    public static final Pattern MD_RAW_PATTERN = Pattern.compile("^([A-Fa-f0-9]{1,6}):([A-Fa-f0-9]{1,4})$");

    public static BasicMdRawCode parseCheatCode(String str) {
        BasicMdRawCode result = BasicMdRawCode.INVALID_CODE;
        if (GameGenieHelper.isValidGGLine(str) && GameGenieHelper.isValidCode(str.substring(0, 9))) {
            result = GameGenieHelper.decode(str.substring(0, 9));
        } else if (CheatCodeHelper.isValidRawCode(str)) {
            Matcher m = MD_RAW_PATTERN.matcher(str.substring(0, 10));
            if (m.matches()) {
                int address = Integer.parseInt(m.group(1), 16);
                int value = Integer.parseInt(m.group(2), 16);
                result = new BasicMdRawCode(address, value);
            } else {
                LOG.error("Invalid cheat code: {}", (Object)str);
            }
        } else {
            LOG.error("Invalid cheat code: {}", (Object)str);
        }
        return result;
    }

    private static boolean isValidRawCode(String str) {
        if (str.contains(":") && str.length() >= 11) {
            return MD_RAW_PATTERN.matcher(str.substring(0, 10)).matches();
        }
        return false;
    }

    public static boolean isRamPatch(BasicMdRawCode code) {
        return code.getAddress() >= 0xE00000 && code.getAddress() <= 0xFFFFFF;
    }

    public static boolean isRomPatch(BasicMdRawCode code) {
        return !CheatCodeHelper.isRamPatch(code);
    }
}

