/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.header;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import java.util.Optional;

public class MdHeader {
    public static Charset SHIFT_JIS;

    static {
        try {
            SHIFT_JIS = Charset.forName("SHIFT-JIS");
        }
        catch (Exception e) {
            System.out.println("Charset SHIFT-JIS not supported");
            SHIFT_JIS = null;
        }
    }

    public static enum MdRomHeaderField {
        SYSTEM_TYPE(256, 16),
        COPYRIGHT_RELEASE_DATE(272, 16),
        TITLE_DOMESTIC(288, 48),
        TITLE_OVERSEAS(336, 48),
        SERIAL_NUMBER(384, 14),
        ROM_CHECKSUM(398, 2, true),
        DEVICE_SUPPORT(400, 16),
        ROM_ADDR_RANGE(416, 8, true),
        RAM_ADDR_RANGE(424, 8, true),
        EXTRA_MEMORY(432, 12),
        MODEM_SUPPORT(444, 12),
        RESERVED1(456, 40),
        REGION_SUPPORT(496, 3),
        RESERVED2(499, 13);

        static final HexFormat hf;
        public final int startOffset;
        public final int len;
        public final boolean rawNumber;

        private MdRomHeaderField(int so, int l) {
            this(so, l, false);
        }

        private MdRomHeaderField(int so, int l, boolean rn) {
            this.startOffset = so;
            this.len = l;
            this.rawNumber = rn;
        }

        public String getValue(byte[] data) {
            if (this == EXTRA_MEMORY) {
                return MdRomHeaderField.extraMemStr(data);
            }
            if (this == TITLE_DOMESTIC) {
                return MdRomHeaderField.titleDomesticStr(data);
            }
            return this.rawNumber ? hf.formatHex(data, this.startOffset, this.startOffset + this.len).trim() : new String(data, this.startOffset, this.len, StandardCharsets.US_ASCII);
        }

        public String getStringView(byte[] data) {
            return String.valueOf((Object)this) + ": " + this.getValue(data);
        }

        private static String titleDomesticStr(byte[] data) {
            String s2;
            String s1 = new String(data, MdRomHeaderField.TITLE_DOMESTIC.startOffset, MdRomHeaderField.TITLE_DOMESTIC.len);
            if (SHIFT_JIS != null && !s1.equals(s2 = new String(data, MdRomHeaderField.TITLE_DOMESTIC.startOffset, MdRomHeaderField.TITLE_DOMESTIC.len, SHIFT_JIS))) {
                s1 = s2;
            }
            return s1;
        }

        private static String extraMemStr(byte[] data) {
            int skipRaOffset = 2;
            String s = new String(data, MdRomHeaderField.EXTRA_MEMORY.startOffset, skipRaOffset) + " ";
            if (s.trim().isEmpty()) {
                skipRaOffset = 0;
            }
            s = s + hf.formatHex(data, MdRomHeaderField.EXTRA_MEMORY.startOffset + skipRaOffset, MdRomHeaderField.EXTRA_MEMORY.startOffset + MdRomHeaderField.EXTRA_MEMORY.len).trim();
            return s;
        }

        static {
            hf = HexFormat.of().withSuffix(" ");
        }
    }

    public static enum DeviceSupportField {
        J("3-button controller"),
        _6("6", "6-button controller"),
        _0("0", "Master System controller"),
        A("Analog joystick"),
        _4("4", "Multitap"),
        G("Lightgun"),
        L("Activator"),
        M("Mouse"),
        B("Trackball"),
        T("Tablet"),
        V("Paddle"),
        K("Keyboard or keypad"),
        R("RS-232"),
        P("Printer"),
        C("CD-ROM (Sega CD)"),
        F("Floppy drive"),
        D("Download?");

        public final String code;
        public final String explain;

        private DeviceSupportField(String name) {
            this.code = this.name();
            this.explain = name;
        }

        private DeviceSupportField(String code, String name) {
            this.code = code;
            this.explain = name;
        }

        public static Optional<DeviceSupportField> getDeviceMappingIfAny(String s) {
            Optional<DeviceSupportField> dsf = Optional.empty();
            try {
                dsf = Optional.of(DeviceSupportField.valueOf(s));
            }
            catch (Exception e) {
                try {
                    dsf = Optional.of(DeviceSupportField.valueOf("_" + s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dsf;
        }
    }
}

