/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.loader;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omegadrive.SystemLoader;
import omegadrive.cart.mapper.MapperSelector;
import omegadrive.cart.mapper.sms.SmsMapper;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class SmsLoader {
    static final String fileName = "res/romdb/meka.nam";
    static final Map<String, String> mapperIdMap = ImmutableMap.of((Object)SmsMapper.Type.CODEM.name(), (Object)"/EMU_MAPPER=3", (Object)SmsMapper.Type.KOREA.name(), (Object)"/EMU_MAPPER=9");
    private static final Logger LOG = LogHelper.getLogger(SmsLoader.class.getSimpleName());

    public static void main(String[] args) {
        Map<String, MapperSelector.Entry> m = SmsLoader.loadData(SystemLoader.SystemType.SMS);
        System.out.println(m);
    }

    public static Map<String, MapperSelector.Entry> loadData(SystemLoader.SystemType systemType) {
        HashMap<String, MapperSelector.Entry> map = new HashMap<String, MapperSelector.Entry>();
        long start = System.currentTimeMillis();
        try {
            Path p = Paths.get(fileName, new String[0]);
            List<String> smsList = Files.readAllLines(p).stream().filter(l -> l.startsWith(systemType.name())).toList();
            for (Map.Entry<String, String> e : mapperIdMap.entrySet()) {
                smsList.stream().filter(l -> l.contains((CharSequence)e.getValue())).forEach(l -> {
                    MapperSelector.Entry en = SmsLoader.getEntry(l, (String)e.getKey());
                    map.put(en.crc32, en);
                });
            }
        }
        catch (Exception e) {
            LOG.error("Unable to parse: {}", (Object)fileName, (Object)e);
        }
        LOG.info("Data loaded in ms: {}", (Object)(System.currentTimeMillis() - start));
        return map;
    }

    private static MapperSelector.Entry getEntry(String str, String mapper) {
        String baseTok = str.split("/")[0];
        String[] tok = baseTok.split("\\s+");
        String[] tok1 = baseTok.split(" {2}");
        MapperSelector.Entry e = new MapperSelector.Entry();
        e.title = tok1[tok1.length - 1].trim();
        e.crc32 = tok[1].trim();
        e.mapperName = mapper;
        return e;
    }
}

