/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md;

import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.md.Ssf2Mapper;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class ExSsfMapper
extends Ssf2Mapper {
    private static final Logger LOG = LogHelper.getLogger(ExSsfMapper.class.getSimpleName());
    private static final boolean verbose = false;
    public static final int BANK_SET_START_ADDRESS = 10563824;
    public static final int BANK_SET_END_ADDRESS = 10563838;

    @Override
    public int readData(int address, Size size) {
        if ((address &= 0xFFFFFF) >= 524288 && address <= 0x3FFFFF) {
            return super.readData(address, size);
        }
        if (address < 524288) {
            int addressI = this.banks[0] << 19 | address & 0x7FFFF;
            return Util.readDataMask(this.memory.getRomData(), addressI, this.memory.getRomMask(), size);
        }
        return this.baseMapper.readData(address, size);
    }

    public static ExSsfMapper createInstance(RomMapper baseMapper, IMemoryProvider memoryProvider) {
        ExSsfMapper mapper = new ExSsfMapper();
        mapper.baseMapper = baseMapper;
        mapper.memory = memoryProvider;
        LOG.info("ExSsfMapper created and enabled");
        return mapper;
    }

    @Override
    public void writeData(int address, int data, Size size) {
        if ((address &= 0xFFFFFF) >= 10563824 && address <= 10563838) {
            int ctrlNum = address & 7;
            if ((ctrlNum & 1) == 1) {
                assert (size == Size.BYTE);
                this.writeBankData(address, data);
            } else {
                assert (size != Size.LONG);
                if (size == Size.BYTE) {
                    if (ctrlNum == 0) {
                        this.writeBankDataExSsf(address, data);
                    } else {
                        this.writeBankData(address + 1, data & 0xFF);
                    }
                } else if (size == Size.WORD) {
                    this.writeBankData(address + 1, data & 0xFF);
                }
            }
            return;
        }
        super.writeData(address, data, size);
    }

    private void writeBankDataExSsf(int addressL, int data) {
        int dataI;
        int val = addressL & 0xF;
        int index = val >> 1;
        this.banks[0] = dataI = data & this.bankSelMask;
    }
}

