/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md;

import java.util.Optional;
import omegadrive.SystemLoader;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cart.loader.MdRomDbModel;
import omegadrive.cart.mapper.BackupMemoryMapper;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.md.MdT5740Mapper;
import omegadrive.cart.mapper.md.eeprom.EepromBase;
import omegadrive.cart.mapper.md.eeprom.I2cEeprom;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MdBackupMemoryMapper
extends BackupMemoryMapper
implements RomMapper {
    private static final Logger LOG = LogHelper.getLogger(MdBackupMemoryMapper.class.getSimpleName());
    public static final boolean allowSramWritesWhenReadOnly = Boolean.parseBoolean(System.getProperty("md.sram.always.allow.writes", "true"));
    private static final boolean verbose = false;
    private static final String fileType = "srm";
    private RomMapper baseMapper;
    private RomMapper.SramMode sramMode = RomMapper.SramMode.DISABLE;
    private MdRomDbModel.RomDbEntry.EepromEntry eepromDbEntry = MdRomDbModel.NO_EEPROM;
    private EepromBase eeprom = EepromBase.NO_OP;

    private MdBackupMemoryMapper(String romName, int size) {
        super(SystemLoader.SystemType.MD, fileType, romName, size);
    }

    public static RomMapper createInstance(RomMapper baseMapper, MdCartInfoProvider cart, MdRomDbModel.RomDbEntry entry) {
        return MdBackupMemoryMapper.createInstance(baseMapper, cart, RomMapper.SramMode.DISABLE, entry);
    }

    public static RomMapper createInstance(RomMapper baseMapper, MdCartInfoProvider cart, RomMapper.SramMode sramMode, MdRomDbModel.RomDbEntry entry) {
        boolean isStm95;
        boolean bl = entry.hasEeprom() ? entry.eeprom.getEepromType() == MdRomDbModel.EepromType.STM_95 : (isStm95 = false);
        if (isStm95) {
            return MdT5740Mapper.createInstance(cart.getRomName(), baseMapper);
        }
        int size = !entry.hasEeprom() ? 65536 : entry.eeprom.getEepromSize();
        MdBackupMemoryMapper mapper = new MdBackupMemoryMapper(cart.getRomName(), size);
        mapper.baseMapper = baseMapper;
        mapper.sramMode = RomMapper.SramMode.READ_WRITE;
        mapper.eepromDbEntry = Optional.ofNullable(entry.eeprom).orElse(MdRomDbModel.NO_EEPROM);
        mapper.eeprom = I2cEeprom.createInstance(entry, mapper.sram);
        LOG.info("BackupMemoryMapper created, using folder: {}", (Object)mapper.sramFolder);
        mapper.initBackupFileIfNecessary();
        return mapper;
    }

    @Override
    public void setSramMode(RomMapper.SramMode sramMode) {
        if (this.sramMode != sramMode) {
            LOG.info("SramMode from: {} to: {}", (Object)this.sramMode, (Object)sramMode);
        }
        this.sramMode = sramMode;
    }

    @Override
    public int readData(int address, Size size) {
        return this.eepromDbEntry == MdRomDbModel.NO_EEPROM ? this.readDataSram(address, size) : this.readDataEeprom(address, size);
    }

    @Override
    public void writeData(int address, int data, Size size) {
        if (this.eepromDbEntry == MdRomDbModel.NO_EEPROM) {
            this.writeDataSram(address, data, size);
        } else {
            this.writeDataEeprom(address, data, size);
        }
    }

    private int readDataSram(int address, Size size) {
        boolean sramRead = this.sramMode != RomMapper.SramMode.DISABLE;
        if (sramRead &= (long)(address &= 0xFFFFFF) >= 0x200000L && (long)address <= 0x20FFFFL) {
            this.initBackupFileIfNecessary();
            int res = Util.readDataMask(this.sram, address, this.sramMask, size);
            if (size != Size.BYTE && (address & 1) == 1) {
                LOG.error("sram read: {} {}, val: {}", new Object[]{Util.th(address), size, Util.th(res)});
            }
            return res;
        }
        return this.baseMapper.readData(address, size);
    }

    private void writeDataSram(int address, int data, Size size) {
        boolean sramWrite = allowSramWritesWhenReadOnly || this.sramMode == RomMapper.SramMode.READ_WRITE;
        if (!(sramWrite &= (long)(address &= 0xFFFFFF) >= 0x200000L && (long)address <= 0x20FFFFL)) {
            this.baseMapper.writeData(address, data, size);
        } else {
            this.initBackupFileIfNecessary();
            Util.writeDataMask(this.sram, address, data, this.sramMask, size);
            if (size != Size.BYTE && (address & 1) == 1) {
                LOG.error("sram write: {} {}, val: {}", new Object[]{Util.th(address), size, Util.th(data)});
            }
        }
    }

    private int readDataEeprom(int address, Size size) {
        boolean eepromRead = this.sramMode != RomMapper.SramMode.DISABLE && size != Size.LONG;
        if (eepromRead &= (long)(address &= 0xFFFFFF) == 0x200000L || (long)address == 0x200001L) {
            this.initBackupFileIfNecessary();
            int res = this.eeprom.readEeprom(address, size);
            return res;
        }
        return this.baseMapper.readData(address, size);
    }

    private void writeDataEeprom(int address, int data, Size size) {
        boolean eepromWrite = this.sramMode == RomMapper.SramMode.READ_WRITE;
        if (eepromWrite &= (long)(address &= 0xFFFFFF) == 0x200000L || (long)address == 0x200001L) {
            this.initBackupFileIfNecessary();
            this.eeprom.writeEeprom(address, data & 0xFF, size);
        } else {
            this.baseMapper.writeData(address, data, size);
        }
    }

    @Override
    protected void initBackupFileIfNecessary() {
        super.initBackupFileIfNecessary();
        this.eeprom.setSram(this.sram);
    }

    @Override
    public void closeRom() {
        this.writeFile();
    }
}

