/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.msx;

import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.msx.MsxAsciiMapper;
import omegadrive.util.Size;

class AsciiMapperImpl
implements RomMapper {
    final int pageNum;
    final int pageSize;
    final int readShiftMask;
    final int[] pageBlockMapper;
    final byte[] rom;
    final MsxAsciiMapper.AsciiType type;

    protected AsciiMapperImpl(byte[] rom, MsxAsciiMapper.AsciiType type) {
        this.rom = rom;
        this.type = type;
        this.pageNum = type == MsxAsciiMapper.AsciiType.ASCII8 ? 4 : 2;
        this.pageSize = 32768 / this.pageNum;
        this.pageBlockMapper = new int[this.pageNum];
        this.readShiftMask = type == MsxAsciiMapper.AsciiType.ASCII8 ? 57344 : 49152;
    }

    @Override
    public int readData(int addressL, Size size) {
        int res = 255;
        int address = addressL & 0xFFFF;
        if (address < 16384 || address > 49151) {
            return -1;
        }
        int pagePointer = this.getPageRead(address);
        if (pagePointer >= 0 && pagePointer < this.pageNum) {
            int shift = address & this.readShiftMask;
            int blockPointer = this.pageBlockMapper[pagePointer];
            int index = address - shift + blockPointer * this.pageSize;
            res = this.rom[index];
        }
        return res;
    }

    @Override
    public void writeData(int addressL, int data, Size size) {
        if (!this.isMapperWrite(addressL)) {
            return;
        }
        int pagePointer = this.getPageWrite(addressL);
        if (pagePointer >= 0 && pagePointer < this.pageNum) {
            int blockPointer;
            this.pageBlockMapper[pagePointer] = blockPointer = (data & 0xFF) % 32;
        }
    }

    private boolean isMapperWrite(long addressL) {
        return this.type == MsxAsciiMapper.AsciiType.ASCII8 ? addressL >= 24576L && addressL < 32768L : addressL >= 24576L && addressL < 26624L || addressL >= 28672L && addressL < 30720L;
    }

    private int getPageWrite(int addressL) {
        int address = addressL & Short.MAX_VALUE;
        return this.type == MsxAsciiMapper.AsciiType.ASCII8 ? (address & 0x7800) >> 11 & 3 : (address & 0x7000) >> 12 & 1;
    }

    private int getPageRead(int address) {
        return this.type == MsxAsciiMapper.AsciiType.ASCII8 ? (address & 0x8000) >> 14 | (address & 0x2000) >> 13 : (address & 0x8000) >> 15;
    }
}

