/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.msx;

import java.util.function.Predicate;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.msx.KonamiMapper;
import omegadrive.util.Size;

class KonamiMapperImpl
implements RomMapper {
    static final Predicate<Integer> isMapperWriteKonami = add -> add >= 24576 && add < 49152;
    static final Predicate<Integer> isMapperWriteKonamiScc = add -> add >= 20480 && add < 47104;
    final Predicate<Integer> isMapperWrite;
    final int pageNum;
    final int pageSize;
    final int readShiftMask;
    final int[] pageBlockMapper;
    final byte[] rom;
    final KonamiMapper.KonamiType type;

    protected KonamiMapperImpl(byte[] rom, KonamiMapper.KonamiType type) {
        this.rom = rom;
        this.type = type;
        this.pageNum = 4;
        this.pageSize = 32768 / this.pageNum;
        this.pageBlockMapper = new int[this.pageNum];
        this.readShiftMask = 57344;
        this.isMapperWrite = type == KonamiMapper.KonamiType.KONAMI ? isMapperWriteKonami : isMapperWriteKonamiScc;
    }

    @Override
    public int readData(int addressL, Size size) {
        int res = 255;
        int address = addressL & 0xFFFF;
        if (address < 16384 || address > 49151) {
            return -1;
        }
        int pagePointer = this.getPageRead(address);
        if (pagePointer >= 0 && pagePointer < this.pageNum) {
            int shift = address & this.readShiftMask;
            int blockPointer = this.pageBlockMapper[pagePointer];
            int index = address - shift + blockPointer * this.pageSize;
            res = this.rom[index];
        }
        return res;
    }

    @Override
    public void writeData(int addressL, int data, Size size) {
        if (!this.isMapperWrite.test(addressL)) {
            return;
        }
        int pagePointer = this.getPageWrite(addressL);
        if (pagePointer >= 0 && pagePointer < this.pageNum) {
            int blockPointer;
            this.pageBlockMapper[pagePointer] = blockPointer = (data & 0xFF) % 32;
        }
    }

    private int getPageWrite(int addressL) {
        int address = (addressL & this.readShiftMask) >> 13;
        return address - 2;
    }

    private int getPageRead(int address) {
        address = (address & this.readShiftMask) >> 13;
        return address - 2;
    }
}

