/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.m68k;

import m68k.memory.AddressSpace;
import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.util.Size;

public class MC68000AddressSpace
implements AddressSpace {
    private MdM68kBusProvider busProvider;

    public static AddressSpace createInstance(MdM68kBusProvider busProvider) {
        MC68000AddressSpace m = new MC68000AddressSpace();
        m.busProvider = busProvider;
        return m;
    }

    public void reset() {
    }

    public int getStartAddress() {
        return 0;
    }

    public int getEndAddress() {
        return 64;
    }

    public int readByte(int addr) {
        return this.busProvider.read(addr, Size.BYTE);
    }

    public int readWord(int addr) {
        return this.busProvider.read(addr, Size.WORD);
    }

    public int readLong(int addr) {
        return this.busProvider.read(addr, Size.LONG);
    }

    public void writeByte(int addr, int value) {
        this.busProvider.write(addr, value, Size.BYTE);
    }

    public void writeWord(int addr, int value) {
        this.busProvider.write(addr, value, Size.WORD);
    }

    public void writeLong(int addr, int value) {
        this.busProvider.write(addr, value, Size.LONG);
    }

    public int internalReadByte(int addr) {
        return this.readByte(addr);
    }

    public int internalReadWord(int addr) {
        return this.readWord(addr);
    }

    public int internalReadLong(int addr) {
        return this.readLong(addr);
    }

    public void internalWriteByte(int addr, int value) {
        this.writeByte(addr, value);
    }

    public void internalWriteWord(int addr, int value) {
        this.writeWord(addr, value);
    }

    public void internalWriteLong(int addr, int value) {
        this.writeLong(addr, value);
    }

    public int size() {
        return 0x1000000;
    }
}

