/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.m68k;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import m68k.cpu.Cpu;
import m68k.cpu.DisassembledInstruction;
import m68k.cpu.Instruction;
import m68k.cpu.MC68000;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MC68000Helper {
    private static final Logger LOG = LogHelper.getLogger(MC68000Helper.class.getSimpleName());
    public static final boolean STOP_ON_EXCEPTION = Boolean.parseBoolean(System.getProperty("68k.stop.on.exception", "true"));
    public static final boolean M68K_DEBUG = Boolean.parseBoolean(System.getProperty("68k.debug", "false"));
    public static final int OVERCLOCK_FACTOR = Integer.parseInt(System.getProperty("68k.overclock.factor", "0"));
    private static final Set<String> instSet;

    private static StringBuilder dumpOp(StringBuilder sb, Cpu cpu, int pc, int opcode) {
        int wrapPc = pc & 0xFFFFFF;
        if (wrapPc >= 0) {
            Instruction i = cpu.getInstructionFor(opcode);
            DisassembledInstruction di = i.disassemble(wrapPc, opcode);
            di.formatInstruction(sb);
        } else {
            sb.append(String.format("%08x   ????", wrapPc));
        }
        return sb;
    }

    private static StringBuilder dumpOp(StringBuilder sb, Cpu cpu, int pc) {
        int wrapPc = pc & 0xFFFFFF;
        if (wrapPc >= 0) {
            int opcode = cpu.readMemoryWord(wrapPc);
            Instruction i = cpu.getInstructionFor(opcode);
            DisassembledInstruction di = i.disassemble(wrapPc, opcode);
            di.formatInstruction(sb);
        } else {
            sb.append(String.format("%08x   ????", wrapPc));
        }
        return sb;
    }

    public static String dumpOp(Cpu cpu, int pc, int opcode) {
        return MC68000Helper.dumpOp(new StringBuilder(), cpu, pc, opcode).toString();
    }

    public static String dumpOp(Cpu cpu, int pc) {
        return MC68000Helper.dumpOp(new StringBuilder(), cpu, pc).toString();
    }

    public static String dumpInfo(Cpu cpu, int pc, boolean showBytes) {
        StringBuilder sb = new StringBuilder("\n");
        int wrapPc = pc & 0xFFFFFF;
        sb.append(String.format("D0: %08x   D4: %08x   A0: %08x   A4: %08x     PC:  %08x\n", cpu.getDataRegisterLong(0), cpu.getDataRegisterLong(4), cpu.getAddrRegisterLong(0), cpu.getAddrRegisterLong(4), wrapPc));
        sb.append(String.format("D1: %08x   D5: %08x   A1: %08x   A5: %08x     SR:  %04x %s\n", cpu.getDataRegisterLong(1), cpu.getDataRegisterLong(5), cpu.getAddrRegisterLong(1), cpu.getAddrRegisterLong(5), cpu.getSR(), MC68000Helper.makeFlagView(cpu)));
        sb.append(String.format("D2: %08x   D6: %08x   A2: %08x   A6: %08x     USP: %08x\n", cpu.getDataRegisterLong(2), cpu.getDataRegisterLong(6), cpu.getAddrRegisterLong(2), cpu.getAddrRegisterLong(6), cpu.getUSP()));
        sb.append(String.format("D3: %08x   D7: %08x   A3: %08x   A7: %08x     SSP: %08x\n\n", cpu.getDataRegisterLong(3), cpu.getDataRegisterLong(7), cpu.getAddrRegisterLong(3), cpu.getAddrRegisterLong(7), cpu.getSSP()));
        StringBuilder sb2 = new StringBuilder();
        if (wrapPc >= 0 && wrapPc < 0x1000000) {
            int opcode = cpu.readMemoryWord(wrapPc);
            Instruction i = cpu.getInstructionFor(opcode);
            DisassembledInstruction di = i.disassemble(wrapPc, opcode);
            if (showBytes) {
                di.formatInstruction(sb2);
            } else {
                di.shortFormat(sb2);
            }
        } else {
            sb2.append(String.format("%08x   ????", wrapPc));
        }
        return sb.append(String.format("\n==> %s\n\n", sb2)).toString();
    }

    public static String dumpInfoShort(int pc, Cpu cpu) {
        int j;
        int wrapPc = pc & 0xFFFFFF;
        int opcode = cpu.readMemoryWord(wrapPc);
        Instruction i = cpu.getInstructionFor(opcode);
        DisassembledInstruction di = i.disassemble(wrapPc, opcode);
        StringBuilder sb = new StringBuilder("CPU  ");
        MC68000Helper.formatInstruction(di, sb);
        sb.append("\t");
        for (j = 0; j < 8; ++j) {
            sb.append("d" + j + ":" + String.format("%08x", cpu.getDataRegisterLong(j)) + " ");
        }
        for (j = 0; j < 8; ++j) {
            sb.append("a" + j + ":" + String.format("%08x", cpu.getAddrRegisterLong(j)) + " ");
        }
        sb.append("ssp:" + String.format("%08x", cpu.getSSP()));
        sb.append(" t" + (cpu.isSupervisorMode() ? "S" : "s"));
        sb.append(cpu.getSR() >> 8 & 0xF);
        sb.append(cpu.isFlagSet(1) ? (char)'C' : 'c');
        sb.append(cpu.isFlagSet(2) ? (char)'V' : 'v');
        sb.append(cpu.isFlagSet(4) ? (char)'Z' : 'z');
        sb.append(cpu.isFlagSet(8) ? (char)'N' : 'n');
        sb.append(cpu.isFlagSet(16) ? (char)'X' : 'x');
        return sb.toString();
    }

    public static void formatInstruction(DisassembledInstruction di, StringBuilder buffer) {
        buffer.append(String.format("%06x  %04x  ", di.address, di.opcode));
        String instName = String.format("%-9s", di.instruction);
        Object str = instName;
        switch (di.num_operands) {
            case 1: {
                str = (String)str + di.op1.operand;
                break;
            }
            case 2: {
                str = (String)str + di.op1.operand + "," + di.op2.operand;
            }
        }
        buffer.append(String.format("%-30s", str));
    }

    public static String dumpInfo(Cpu cpu, M68kState state, int memorySize) {
        StringBuilder sb = new StringBuilder("\n");
        int wrapPc = state.pc & 0xFFFFFF;
        sb.append("D0: ").append(Util.th(state.dr[0])).append("   D4: ").append(Util.th(state.dr[4])).append("   A0: ").append(Util.th(state.ar[0])).append("   A4: ").append(Util.th(state.ar[4])).append("     PC: ").append(Util.th(wrapPc)).append("\n");
        sb.append("D1: ").append(Util.th(state.dr[1])).append("   D5: ").append(Util.th(state.dr[5])).append("   A1: ").append(Util.th(state.ar[1])).append("   A5: ").append(Util.th(state.ar[5])).append("     SR: ").append(MC68000Helper.toHex(state.sr, 4)).append(" ").append(MC68000Helper.makeFlagView(cpu)).append("\n");
        sb.append("D2: ").append(Util.th(state.dr[2])).append("   D6: ").append(Util.th(state.dr[6])).append("   A2: ").append(Util.th(state.ar[2])).append("   A6: ").append(Util.th(state.ar[6])).append("    USP: ").append(Util.th(state.usp)).append("\n");
        sb.append("D3: ").append(Util.th(state.dr[3])).append("   D7: ").append(Util.th(state.dr[7])).append("   A3: ").append(Util.th(state.ar[3])).append("   A7: ").append(Util.th(state.ar[7])).append("    SSP: ").append(Util.th(state.ssp)).append("\n");
        StringBuilder sb2 = new StringBuilder();
        if (wrapPc >= 0 && wrapPc < memorySize) {
            int opcode = cpu.readMemoryWord(wrapPc);
            Instruction i = cpu.getInstructionFor(opcode);
            DisassembledInstruction di = i.disassemble(wrapPc, opcode);
            di.formatInstruction(sb2);
        }
        sb.append("\n==> ").append((CharSequence)sb2).append("\n\n");
        sb.append(state.memAccess);
        return sb.toString();
    }

    public static String toHex(int val, int digits) {
        return Strings.padStart((String)Util.th(val), (int)digits, (char)'0');
    }

    protected static String makeFlagView(Cpu cpu) {
        StringBuilder sb = new StringBuilder(5);
        sb.append(cpu.isFlagSet(16) ? (char)'X' : '-');
        sb.append(cpu.isFlagSet(8) ? (char)'N' : '-');
        sb.append(cpu.isFlagSet(4) ? (char)'Z' : '-');
        sb.append(cpu.isFlagSet(2) ? (char)'V' : '-');
        sb.append(cpu.isFlagSet(1) ? (char)'C' : '-');
        return sb.toString();
    }

    public static boolean addToInstructionSet(MC68000 cpu) {
        int wrapPc = cpu.getPC() & 0xFFFFFF;
        int opcode = cpu.readMemoryWord(wrapPc);
        Instruction i = cpu.getInstructionFor(opcode);
        String name = i.getClass().getTypeName();
        String str = name.substring(name.lastIndexOf(46) + 1);
        return instSet.add(str);
    }

    public static String dumpInstructionSet() {
        return "Instruction set: " + instSet.size() + "\n" + Arrays.toString(instSet.toArray());
    }

    public static String getCpuState(Cpu cpu, String head) {
        try {
            return head + MC68000Helper.dumpInfo(cpu, cpu.getPC(), true);
        }
        catch (Exception e) {
            String pc = Util.th(cpu.getPC() & 0xFFFFFF);
            LOG.warn("Unable to dump the state, pc: {}", (Object)pc, (Object)e);
            return "????";
        }
    }

    public static void printCpuState(Cpu cpu, String head) {
        LOG.info("{}{}", (Object)head, (Object)MC68000Helper.getCpuState(cpu, head));
    }

    static {
        if (M68K_DEBUG) {
            LOG.info("68k debug mode: true");
        }
        if (OVERCLOCK_FACTOR > 0) {
            LOG.info("68k overclock factor: {}", (Object)OVERCLOCK_FACTOR);
        }
        instSet = new TreeSet<String>();
    }

    public static class M68kState {
        public int sr;
        public int pc;
        public int ssp;
        public int usp;
        public int opcode;
        public final int[] dr = new int[8];
        public final int[] ar = new int[8];
        public String memAccess;

        public String toString() {
            return "M68kState{sr=" + Util.th(this.sr) + ", pc=" + Util.th(this.pc) + ", ssp=" + Util.th(this.ssp) + ", usp=" + Util.th(this.usp) + ", opcode=" + Util.th(this.opcode) + ", dr=" + Arrays.toString(this.dr) + ", ar=" + Arrays.toString(this.ar) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            M68kState state = (M68kState)o;
            if (this.sr != state.sr) {
                return false;
            }
            if (this.pc != state.pc) {
                return false;
            }
            if (this.ssp != state.ssp) {
                return false;
            }
            if (this.usp != state.usp) {
                return false;
            }
            if (this.opcode != state.opcode) {
                return false;
            }
            if (!Arrays.equals(this.dr, state.dr)) {
                return false;
            }
            return Arrays.equals(this.ar, state.ar);
        }

        public int hashCode() {
            int result = this.sr;
            result = 31 * result + this.pc;
            result = 31 * result + this.ssp;
            result = 31 * result + this.usp;
            result = 31 * result + this.opcode;
            result = 31 * result + Arrays.hashCode(this.dr);
            result = 31 * result + Arrays.hashCode(this.ar);
            return result;
        }
    }
}

