/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.m68k;

import m68k.cpu.Cpu;
import m68k.cpu.CpuConfig;
import m68k.cpu.MC68000;
import m68k.memory.AddressSpace;
import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.m68k.MC68000AddressSpace;
import omegadrive.cpu.m68k.MC68000Helper;
import omegadrive.cpu.m68k.debug.MC68000WrapperFastDebug;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MC68000Wrapper
implements M68kProvider {
    private static final Logger LOG = LogHelper.getLogger(MC68000Wrapper.class.getSimpleName());
    protected final MC68000 m68k;
    protected final AddressSpace addressSpace;
    protected final MdM68kBusProvider busProvider;
    protected final BufferUtil.CpuDeviceAccess cpu;
    private boolean stop;
    protected int currentPC;
    protected int instCycles = 0;
    public static boolean subCpuBusHalt = false;
    private static final CpuConfig tasBrokenConfig = new CpuConfig(true, false, false);

    public MC68000Wrapper(BufferUtil.CpuDeviceAccess cpu, MdM68kBusProvider busProvider) {
        this.cpu = cpu;
        this.m68k = this.createCpu(cpu == BufferUtil.CpuDeviceAccess.M68K ? tasBrokenConfig : CpuConfig.DEFAULT_CONFIG);
        this.busProvider = busProvider;
        this.addressSpace = this.createAddressSpace();
        this.m68k.setAddressSpace(this.addressSpace);
    }

    public static MC68000Wrapper createInstance(MdM68kBusProvider busProvider) {
        return MC68000Wrapper.createInstance(BufferUtil.CpuDeviceAccess.M68K, busProvider);
    }

    public static MC68000Wrapper createInstance(BufferUtil.CpuDeviceAccess cpu, MdM68kBusProvider busProvider) {
        return MC68000Helper.M68K_DEBUG ? new MC68000WrapperFastDebug(cpu, busProvider) : new MC68000Wrapper(cpu, busProvider);
    }

    @Override
    public int runInstruction() {
        int res;
        block2: {
            res = 0;
            try {
                this.currentPC = this.m68k.getPC();
                res = this.m68k.execute() + this.instCycles;
                this.instCycles = 0;
            }
            catch (Exception e) {
                LOG.error("68k error", (Throwable)e);
                this.m68k.raiseException(4);
                if (!MC68000Helper.STOP_ON_EXCEPTION) break block2;
                LOG.error(MC68000Helper.getCpuState((Cpu)this.m68k, ""));
                throw e;
            }
        }
        return res >> MC68000Helper.OVERCLOCK_FACTOR;
    }

    protected AddressSpace createAddressSpace() {
        return MC68000AddressSpace.createInstance(this.busProvider);
    }

    @Override
    public int getPrefetchWord() {
        return this.addressSpace.readWord(this.m68k.getPC());
    }

    @Override
    public void addCyclePenalty(int value) {
        this.instCycles += value;
    }

    @Override
    public int getPC() {
        return this.m68k.getPC();
    }

    public void setStop(boolean value) {
        if (this.stop != value) {
            LogHelper.logWarnOnceWhenEn(LOG, "{} stop: {}", new Object[]{this.cpu, value});
        }
        this.stop = value;
    }

    @Override
    public boolean isStopped() {
        return this.stop;
    }

    @Override
    public boolean raiseInterrupt(int level) {
        int ilev = this.m68k.getInterruptLevel();
        this.m68k.raiseInterrupt(level);
        return ilev != level && this.m68k.getInterruptLevel() == level;
    }

    @Override
    public void reset() {
        BufferUtil.CpuDeviceAccess prev = MdRuntimeData.setAccessTypeExt(this.cpu);
        this.m68k.reset();
        MdRuntimeData.setAccessTypeExt(prev);
    }

    @Override
    public void softReset() {
        this.reset();
        this.instCycles += 132;
        this.setStop(false);
    }

    @Override
    public String getInfo() {
        return MC68000Helper.dumpOp((Cpu)this.m68k, this.currentPC);
    }

    public MC68000 getM68k() {
        return this.m68k;
    }

    private MC68000 createCpu(CpuConfig config) {
        return new MC68000(config){

            public void raiseException(int vector) {
                super.raiseException(vector);
                MC68000Wrapper.this.handleIntAck(vector);
                MC68000Wrapper.this.setStop(false);
            }

            public void resetExternal() {
                LOG.info("{} Reset External", (Object)MC68000Wrapper.this.cpu);
                MC68000Wrapper.this.busProvider.resetFrom68k();
            }

            public void reset() {
                super.reset();
                this.resetExternal();
                LOG.info("{} Reset, PC: {}, SP: {}", new Object[]{MC68000Wrapper.this.cpu, Util.th(MC68000Wrapper.this.m68k.getPC()), Util.th(MC68000Wrapper.this.m68k.getSSP())});
            }

            public void stop() {
                MC68000Wrapper.this.setStop(true);
                LogHelper.logWarnOnce(LOG, "{} Stop: true", new Object[]{MC68000Wrapper.this.cpu});
            }
        };
    }

    private void handleIntAck(int vector) {
        if (vector == 28 || vector == 30) {
            this.instCycles += 44;
            this.busProvider.ackInterrupt68k(vector - 24);
            this.stop = false;
        }
    }
}

