/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.ssp16;

import java.util.HashSet;
import java.util.Set;
import omegadrive.cpu.ssp16.Ssp16;
import omegadrive.cpu.ssp16.Ssp16Disasm;
import omegadrive.cpu.ssp16.Ssp16Types;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class Ssp16Impl
implements Ssp16 {
    private static final Logger LOG = LogHelper.getLogger(Ssp16Impl.class.getSimpleName());
    public static final boolean LOG_SVP = false;
    static final int SSP_FLAG_L = 4096;
    static final int SSP_FLAG_Z = 8192;
    static final int SSP_FLAG_V = 16384;
    static final int SSP_FLAG_N = 32768;
    final Set<Integer> pcSet = new HashSet<Integer>();
    private int g_cycles;
    private Ssp16Types.Cart cart = null;
    private Ssp16Types.Ssp1601_t sspCtx = null;
    private Ssp16Types.Svp_t svpCtx = null;
    private int PC;
    private int cartPC;
    Ssp16Types.Ssp_reg_t rX;
    Ssp16Types.Ssp_reg_t rY;
    Ssp16Types.Ssp_reg_t rA;
    Ssp16Types.Ssp_reg_t rST;
    Ssp16Types.Ssp_reg_t rSTACK;
    Ssp16Types.Ssp_reg_t rPC;
    Ssp16Types.Ssp_reg_t rP;
    Ssp16Types.Ssp_reg_t rPM0;
    Ssp16Types.Ssp_reg_t rPM1;
    Ssp16Types.Ssp_reg_t rPM2;
    Ssp16Types.Ssp_reg_t rXST;
    Ssp16Types.Ssp_reg_t rPM4;
    Ssp16Types.Ssp_reg_t rPMC;
    Ssp16Types.Ssp_reg_t rAL;
    Ssp16Types.Ssp_reg_t rA32;
    static final int CHECK32_FALSE = Integer.MIN_VALUE;

    public static Ssp16Impl createInstance(Ssp16Types.Svp_t svp, Ssp16Types.Cart cart) {
        Ssp16Impl s = new Ssp16Impl();
        s.cart = cart;
        s.loadSvpContext(svp);
        s.cartPC = cart.rom.length > 255 ? cart.rom[255] : 1024;
        return s;
    }

    static int overwrite_write(int currentVal, int newVal) {
        if ((newVal & 0xF000) > 0) {
            currentVal &= 0xFFFF0FFF;
            currentVal |= newVal & 0xF000;
        }
        if ((newVal & 0xF00) > 0) {
            currentVal &= 0xFFFFF0FF;
            currentVal |= newVal & 0xF00;
        }
        if ((newVal & 0xF0) > 0) {
            currentVal &= 0xFFFFFF0F;
            currentVal |= newVal & 0xF0;
        }
        if ((newVal & 0xF) > 0) {
            currentVal &= 0xFFFFFFF0;
            currentVal |= newVal & 0xF;
        }
        return currentVal;
    }

    static int get_inc(int mode) {
        int inc = mode >> 11 & 7;
        if (inc != 0) {
            if (inc != 7) {
                --inc;
            }
            inc = 1 << inc;
            if ((mode & 0x8000) > 0) {
                inc = -inc;
            }
        }
        return inc;
    }

    int IJind(int op) {
        return op >> 6 & 4 | op & 3;
    }

    private void init() {
        this.rX = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_X.ordinal()];
        this.rY = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_Y.ordinal()];
        this.rA = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_A.ordinal()];
        this.rST = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_ST.ordinal()];
        this.rSTACK = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_STACK.ordinal()];
        this.rPC = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PC.ordinal()];
        this.rP = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_P.ordinal()];
        this.rPM0 = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PM0.ordinal()];
        this.rPM1 = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PM1.ordinal()];
        this.rPM2 = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PM2.ordinal()];
        this.rXST = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_XST.ordinal()];
        this.rPM4 = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PM4.ordinal()];
        this.rPMC = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PMC.ordinal()];
        this.rAL = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_A.ordinal()];
        this.rA32 = this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_A.ordinal()];
    }

    @Override
    public void ssp1601_reset(Ssp16Types.Ssp1601_t l_ssp) {
        this.sspCtx = l_ssp;
        this.sspCtx.emu_status = 0;
        this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_GR0.ordinal()].setV(0xFFFF0000L);
        this.rPC.setH(this.cartPC);
        this.rSTACK.setH(0);
        this.rST.setH(0);
    }

    @Override
    public Ssp16Types.Svp_t getSvpContext() {
        return this.svpCtx;
    }

    @Override
    public void loadSvpContext(Ssp16Types.Svp_t svpCtx) {
        this.svpCtx = svpCtx;
        this.sspCtx = svpCtx.ssp1601;
        int limit = Math.min(svpCtx.iram_rom.length, this.cart.rom.length);
        if (limit - 1024 >= 0) {
            System.arraycopy(this.cart.rom, 1024, svpCtx.iram_rom, 1024, limit - 1024);
        }
        this.init();
        this.SET_PC(this.rPC.h);
    }

    final int GET_PC() {
        return this.PC;
    }

    int GET_PPC_OFFS() {
        return this.PC - 1;
    }

    final int SET_PC(int d) {
        this.PC = d & 0xFFFF;
        return this.PC;
    }

    private void UPD_ACC_ZN() {
        this.rST.setH(this.rST.h & 0xFFFF5FFF);
        if (this.rA32.v == 0) {
            this.rST.setH(this.rST.h | 0x2000);
        } else {
            this.rST.setH(this.rST.h | this.rA32.v >> 16 & 0x8000);
        }
    }

    void UPD_LZVN() {
        this.rST.setH(this.rST.h & 0xFFFF0FFF);
        if (this.rA32.v == 0) {
            this.rST.setH(this.rST.h | 0x2000);
        } else {
            this.rST.setH(this.rST.h | this.rA32.v >> 16 & 0x8000);
        }
    }

    int COND_CHECK(int op) {
        int cond = 0;
        switch (op & 0xF0) {
            case 0: {
                cond = 1;
                break;
            }
            case 80: {
                cond = ((this.rST.h ^ op << 5) & 0x2000) == 0 ? 1 : 0;
                break;
            }
            case 112: {
                cond = ((this.rST.h ^ op << 7) & 0x8000) == 0 ? 1 : 0;
                break;
            }
        }
        return cond;
    }

    void OP_LDA(int x) {
        this.rA.setH(x);
    }

    void OP_LDA32(int x) {
        this.rA32.setV(x);
    }

    void OP_SUBA(int x) {
        this.rA32.setV(this.rA32.v - (x << 16));
        this.UPD_LZVN();
    }

    void OP_SUBA32(int x) {
        this.rA32.setV(this.rA32.v - x);
        this.UPD_LZVN();
    }

    void OP_CMPA(int x) {
        int t = this.rA32.v - (x << 16);
        this.rST.setH(this.rST.h & 0xFFFF0FFF);
        if (t == 0) {
            this.rST.setH(this.rST.h | 0x2000);
        } else {
            this.rST.setH(this.rST.h | t >> 16 & 0x8000);
        }
    }

    void OP_CMPA32(int x) {
        int t = this.rA32.v - x;
        this.rST.setH(this.rST.h & 0xFFFF0FFF);
        if (t == 0) {
            this.rST.setH(this.rST.h | 0x2000);
        } else {
            this.rST.setH(this.rST.h | t >> 16 & 0x8000);
        }
    }

    void OP_ADDA(int x) {
        this.rA32.setV(this.rA32.v + (x << 16));
        this.UPD_LZVN();
    }

    void OP_ADDA32(int x) {
        this.rA32.setV(this.rA32.v + x);
        this.UPD_LZVN();
    }

    void OP_ANDA(int x) {
        this.rA32.setV(this.rA32.v & x << 16);
        this.UPD_ACC_ZN();
    }

    void OP_ANDA32(int x) {
        this.rA32.setV(this.rA32.v & x);
        this.UPD_ACC_ZN();
    }

    void OP_ORA(int x) {
        this.rA32.setV(this.rA32.v | x << 16);
        this.UPD_ACC_ZN();
    }

    void OP_ORA32(int x) {
        this.rA32.setV(this.rA32.v | x);
        this.UPD_ACC_ZN();
    }

    void OP_EORA(int x) {
        this.rA32.setV(this.rA32.v ^ x << 16);
        this.UPD_ACC_ZN();
    }

    void OP_EORA32(int x) {
        this.rA32.setV(this.rA32.v ^ x);
        this.UPD_ACC_ZN();
    }

    int OP_CHECK32(int op) {
        if ((op & 0xF) == Ssp16Types.Ssp16Reg.SSP_P.ordinal()) {
            this.read_P();
            return this.rP.v;
        }
        if ((op & 0xF) == Ssp16Types.Ssp16Reg.SSP_A.ordinal()) {
            return this.rA32.v;
        }
        return Integer.MIN_VALUE;
    }

    public int read_unknown() {
        LOG.error(String.format("ssp FIXME: unknown read @ %04x", this.GET_PPC_OFFS()));
        return 0;
    }

    void write_unknown(int d) {
        LOG.error(String.format("ssp FIXME: unknown write @ %04x", this.GET_PPC_OFFS()));
    }

    void write_ST(int d) {
        this.rST.setH(d);
    }

    final int REG_READ(int r) {
        if (r <= 4) {
            return this.sspCtx.gr[r].h;
        }
        return this.invokeReadHandler(r);
    }

    final void REG_WRITE(int r, int d) {
        if (r >= 4) {
            this.invokeWriteHandler(r, d);
        } else if (r > 0) {
            this.sspCtx.gr[r].setH(d);
        }
    }

    int read_PC() {
        return this.GET_PC();
    }

    void write_PC(int d) {
        this.SET_PC(d);
        --this.g_cycles;
    }

    int read_STACK() {
        this.rSTACK.setH(this.rSTACK.h - 1);
        if (this.rSTACK.h < 0) {
            this.rSTACK.setH(5);
        }
        return this.sspCtx.stack[this.rSTACK.h];
    }

    void write_STACK(int d) {
        if (this.rSTACK.h >= 6) {
            this.rSTACK.setH(0);
            return;
        }
        this.sspCtx.stack[this.rSTACK.h] = (short)d;
        this.rSTACK.setH(this.rSTACK.h + 1);
    }

    int read_P() {
        this.rP.setV(this.rX.h * this.rY.h << 1);
        return this.rP.h;
    }

    int read_PM0() {
        int d = this.pm_io(0, 0, 0);
        if (d != -1) {
            return d;
        }
        d = this.rPM0.h;
        if ((d & 2) == 0 && (this.GET_PPC_OFFS() == 1024 || this.GET_PPC_OFFS() == 49807)) {
            this.sspCtx.emu_status |= 0x2000;
        }
        this.rPM0.setH(this.rPM0.h & 0xFFFFFFFD);
        return d;
    }

    void write_PM0(int d) {
        int r = this.pm_io(0, 1, d);
        if (r != -1) {
            return;
        }
        this.rPM0.setH(d);
    }

    int read_PM1() {
        int d = this.pm_io(1, 0, 0);
        if (d != -1) {
            return d;
        }
        return this.rPM1.h;
    }

    void write_PM1(int d) {
        int r = this.pm_io(1, 1, d);
        if (r != -1) {
            return;
        }
        this.rPM1.setH(d);
    }

    int read_PM2() {
        int d = this.pm_io(2, 0, 0);
        if (d != -1) {
            return d;
        }
        return this.rPM2.h;
    }

    void write_PM2(int d) {
        int r = this.pm_io(2, 1, d);
        if (r != -1) {
            return;
        }
        this.rPM2.setH(d);
    }

    int read_XST() {
        int d = this.pm_io(3, 0, 0);
        if (d != -1) {
            return d;
        }
        return this.rXST.h;
    }

    void write_XST(int d) {
        int r = this.pm_io(3, 1, d);
        if (r != -1) {
            return;
        }
        this.rPM0.setH(this.rPM0.h | 1);
        this.rXST.setH(d);
    }

    int read_PM4() {
        int d = this.pm_io(4, 0, 0);
        if (d == 0) {
            switch (this.GET_PPC_OFFS()) {
                case 1066: {
                    this.sspCtx.emu_status |= 0x8000;
                    break;
                }
                case 10121: {
                    this.sspCtx.emu_status |= 0x4000;
                }
            }
        }
        if (d != -1) {
            return d;
        }
        return this.rPM4.h;
    }

    void write_PM4(int d) {
        int r = this.pm_io(4, 1, d);
        if (r != -1) {
            return;
        }
        this.rPM4.setH(d);
    }

    int read_PMC() {
        if ((this.sspCtx.emu_status & 1) > 0) {
            this.sspCtx.emu_status |= 2;
            this.sspCtx.emu_status &= 0xFFFFFFFE;
            short val = this.rPMC.l;
            return val << 4 & 0xFFF0 | val >> 4 & 0xF;
        }
        this.sspCtx.emu_status |= 1;
        return this.rPMC.l;
    }

    void write_PMC(int d) {
        if ((this.sspCtx.emu_status & 1) > 0) {
            this.sspCtx.emu_status |= 2;
            this.sspCtx.emu_status &= 0xFFFFFFFE;
            this.rPMC.setH(d);
        } else {
            this.sspCtx.emu_status |= 1;
            this.rPMC.setL(d);
        }
    }

    int pm_io(int reg, int write, int d) {
        if ((this.sspCtx.emu_status & 2) > 0) {
            int opcode = this.svpCtx.iram_rom[this.PC - 1];
            if ((opcode & 0xFF0F) > 0 && (opcode & 0xFFF0) > 0) {
                this.sspCtx.emu_status &= 0xFFFFFFFD;
                return 0;
            }
            this.sspCtx.pmac[write][reg] = this.rPMC.v;
            this.sspCtx.emu_status &= 0xFFFFFFFD;
            return 0;
        }
        if ((this.sspCtx.emu_status & 1) > 0) {
            this.sspCtx.emu_status &= 0xFFFFFFFE;
        }
        if (reg == 4 || (this.rST.h & 0x60) > 0) {
            d &= 0xFFFF;
            int mode = this.sspCtx.pmac[write][reg] >> 16 & 0xFFFF;
            int addr = this.sspCtx.pmac[write][reg] & 0xFFFF;
            if (write > 0) {
                if ((mode & 0x43FF) == 24) {
                    int inc = Ssp16Impl.get_inc(mode);
                    if ((mode & 0x400) > 0) {
                        int currentVal = this.svpCtx.dram[addr];
                        d = Ssp16Impl.overwrite_write(currentVal, d);
                    }
                    this.svpCtx.dram[addr] = d;
                    int[] nArray = this.sspCtx.pmac[write];
                    int n = reg;
                    nArray[n] = nArray[n] + inc;
                } else if ((mode & 0xFBFF) == 16408) {
                    if ((mode & 0x400) > 0) {
                        int currentVal = this.svpCtx.dram[addr];
                        d = Ssp16Impl.overwrite_write(currentVal, d);
                    }
                    this.svpCtx.dram[addr] = d;
                    int[] nArray = this.sspCtx.pmac[write];
                    int n = reg;
                    nArray[n] = nArray[n] + ((addr & 1) > 0 ? 31 : 1);
                } else if ((mode & 0x47FF) == 28) {
                    int inc = Ssp16Impl.get_inc(mode);
                    this.svpCtx.iram_rom[addr & 0x3FF] = d;
                    int[] nArray = this.sspCtx.pmac[write];
                    int n = reg;
                    nArray[n] = nArray[n] + inc;
                } else {
                    LOG.info(String.format("ssp FIXME: PM%x unhandled write mode %04x, [%06x] %04x @ %04x", reg, mode, 0, d, this.GET_PPC_OFFS()));
                }
            } else if ((mode & 0xFFF0) == 2048) {
                if ((this.sspCtx.pmac[0][reg] & 0xFFFF) == -1) {
                    int[] nArray = this.sspCtx.pmac[0];
                    int n = reg;
                    nArray[n] = nArray[n] + 65536;
                }
                int[] nArray = this.sspCtx.pmac[0];
                int n = reg;
                nArray[n] = nArray[n] + 1;
                int romAddr = addr | (mode & 0xF) << 16;
                d = this.cart.rom[romAddr];
            } else if ((mode & 0x47FF) == 24) {
                int inc = Ssp16Impl.get_inc(mode);
                d = this.svpCtx.dram[addr];
                int[] nArray = this.sspCtx.pmac[0];
                int n = reg;
                nArray[n] = nArray[n] + inc;
            } else {
                LOG.info(String.format("ssp FIXME: PM%x unhandled read  mode %04x, [%06x] @ %04x", reg, mode, 0, this.GET_PPC_OFFS()));
                d = 0;
            }
            this.rPMC.setV(this.sspCtx.pmac[write][reg]);
            return d;
        }
        return -1;
    }

    int read_AL() {
        if (this.svpCtx.iram_rom[this.PC - 1] == 15) {
            this.sspCtx.emu_status &= 0xFFFFFFFC;
        }
        return this.rAL.l;
    }

    void write_AL(int d) {
        this.rAL.setL(d);
    }

    final int invokeReadHandler(int ordinal) {
        switch (ordinal) {
            case 8: {
                return this.read_PM0();
            }
            case 5: {
                return this.read_STACK();
            }
            case 12: {
                return this.read_PM4();
            }
            case 14: {
                return this.read_PMC();
            }
            case 15: {
                return this.read_AL();
            }
            case 6: {
                return this.read_PC();
            }
            case 7: {
                return this.read_P();
            }
            case 9: {
                return this.read_PM1();
            }
            case 10: {
                return this.read_PM2();
            }
            case 11: {
                return this.read_XST();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                return this.read_unknown();
            }
        }
        LOG.info("invokeReadHandler error: {}", (Object)ordinal);
        return 255;
    }

    final void invokeWriteHandler(int ordinal, int value) {
        switch (ordinal) {
            case 12: {
                this.write_PM4(value);
                break;
            }
            case 6: {
                this.write_PC(value);
                break;
            }
            case 14: {
                this.write_PMC(value);
                break;
            }
            case 15: {
                this.write_AL(value);
                break;
            }
            case 4: {
                this.write_ST(value);
                break;
            }
            case 5: {
                this.write_STACK(value);
                break;
            }
            case 8: {
                this.write_PM0(value);
                break;
            }
            case 9: {
                this.write_PM1(value);
                break;
            }
            case 10: {
                this.write_PM2(value);
                break;
            }
            case 11: {
                this.write_XST(value);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 13: {
                this.write_unknown(value);
                break;
            }
            default: {
                LOG.info("invokeWriteHandler error: {}", (Object)ordinal);
            }
        }
    }

    final int ptr1_read(int op) {
        return this.ptr1_read_(op & 3, op >> 6 & 4, op << 1 & 0x18);
    }

    final int ptr1_read_(int ri, int isj2, int modi3) {
        int add = 0;
        int t = ri | isj2 | modi3;
        int rpPtr = 0;
        switch (t) {
            case 0: 
            case 1: 
            case 2: {
                return this.sspCtx.mem.bank.RAM0[this.sspCtx.ptr.bank.r0[t & 3]];
            }
            case 3: {
                return this.sspCtx.mem.bank.RAM0[0];
            }
            case 4: 
            case 5: 
            case 6: {
                return this.sspCtx.mem.bank.RAM1[this.sspCtx.ptr.bank.r1[t & 3]];
            }
            case 7: {
                return this.sspCtx.mem.bank.RAM1[0];
            }
            case 8: 
            case 9: 
            case 10: {
                int val = this.sspCtx.ptr.bank.r0[t & 3];
                this.sspCtx.ptr.bank.r0[t & 3] = val + 1 & 0xFF;
                return this.sspCtx.mem.bank.RAM0[val];
            }
            case 11: {
                return this.sspCtx.mem.bank.RAM0[1];
            }
            case 12: 
            case 13: 
            case 14: {
                int val = this.sspCtx.ptr.bank.r1[t & 3];
                this.sspCtx.ptr.bank.r1[t & 3] = val + 1 & 0xFF;
                return this.sspCtx.mem.bank.RAM1[val];
            }
            case 15: {
                return this.sspCtx.mem.bank.RAM1[1];
            }
            case 16: 
            case 17: 
            case 18: {
                rpPtr = this.sspCtx.ptr.bank.r0[t & 3];
                int res = this.sspCtx.mem.bank.RAM0[rpPtr];
                if ((this.rST.h & 7) == 0) {
                    this.sspCtx.ptr.bank.r0[t & 3] = rpPtr - 1 & 0xFF;
                    return res;
                }
                add = -1;
                int mask = (1 << (this.rST.h & 7)) - 1;
                rpPtr = rpPtr & ~mask | rpPtr + add & mask;
                this.sspCtx.ptr.bank.r0[t & 3] = rpPtr & 0xFF;
                return res;
            }
            case 19: {
                return this.sspCtx.mem.bank.RAM0[2];
            }
            case 20: 
            case 21: 
            case 22: {
                rpPtr = this.sspCtx.ptr.bank.r1[t & 3];
                int res = this.sspCtx.mem.bank.RAM1[rpPtr];
                if ((this.rST.h & 7) == 0) {
                    this.sspCtx.ptr.bank.r1[t & 3] = rpPtr - 1 & 0xFF;
                    return res;
                }
                add = -1;
                int mask = (1 << (this.rST.h & 7)) - 1;
                rpPtr = rpPtr & ~mask | rpPtr + add & mask;
                this.sspCtx.ptr.bank.r1[t & 3] = rpPtr & 0xFF;
                return res;
            }
            case 23: {
                return this.sspCtx.mem.bank.RAM1[2];
            }
            case 24: 
            case 25: 
            case 26: {
                rpPtr = this.sspCtx.ptr.bank.r0[t & 3];
                int res = this.sspCtx.mem.bank.RAM0[rpPtr];
                if ((this.rST.h & 7) == 0) {
                    this.sspCtx.ptr.bank.r0[t & 3] = rpPtr + 1 & 0xFF;
                    return res;
                }
                add = 1;
                int mask = (1 << (this.rST.h & 7)) - 1;
                rpPtr = rpPtr & ~mask | rpPtr + add & mask;
                this.sspCtx.ptr.bank.r0[t & 3] = rpPtr & 0xFF;
                return res;
            }
            case 27: {
                return this.sspCtx.mem.bank.RAM0[3];
            }
            case 28: 
            case 29: 
            case 30: {
                rpPtr = this.sspCtx.ptr.bank.r1[t & 3];
                int res = this.sspCtx.mem.bank.RAM1[rpPtr];
                if ((this.rST.h & 7) == 0) {
                    this.sspCtx.ptr.bank.r1[t & 3] = rpPtr + 1 & 0xFF;
                    return res;
                }
                add = 1;
                int mask = (1 << (this.rST.h & 7)) - 1;
                rpPtr = rpPtr & ~mask | rpPtr + add & mask;
                this.sspCtx.ptr.bank.r1[t & 3] = rpPtr & 0xFF;
                return res;
            }
            case 31: {
                return this.sspCtx.mem.bank.RAM1[3];
            }
        }
        return 0;
    }

    final int ptr2_read(int op) {
        int mv = 0;
        int t = op & 3 | op >> 6 & 4 | op << 1 & 0x18;
        switch (t) {
            case 0: 
            case 1: 
            case 2: {
                mv = this.sspCtx.mem.bank.RAM0[this.sspCtx.ptr.bank.r0[t & 3]];
                this.sspCtx.mem.bank.RAM0[this.sspCtx.ptr.bank.r0[t & 3]] = mv + 1 & 0xFFFF;
                break;
            }
            case 3: {
                mv = this.sspCtx.mem.bank.RAM0[0];
                this.sspCtx.mem.bank.RAM0[0] = mv + 1 & 0xFFFF;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                mv = this.sspCtx.mem.bank.RAM1[this.sspCtx.ptr.bank.r1[t & 3]];
                this.sspCtx.mem.bank.RAM1[this.sspCtx.ptr.bank.r1[t & 3]] = mv + 1 & 0xFFFF;
                break;
            }
            case 7: {
                mv = this.sspCtx.mem.bank.RAM1[0];
                this.sspCtx.mem.bank.RAM1[0] = mv + 1 & 0xFFFF;
                break;
            }
            case 11: {
                mv = this.sspCtx.mem.bank.RAM0[1];
                this.sspCtx.mem.bank.RAM0[1] = mv + 1 & 0xFFFF;
                break;
            }
            case 15: {
                mv = this.sspCtx.mem.bank.RAM1[1];
                this.sspCtx.mem.bank.RAM1[1] = mv + 1 & 0xFFFF;
                break;
            }
            case 19: {
                mv = this.sspCtx.mem.bank.RAM0[2];
                this.sspCtx.mem.bank.RAM0[2] = mv + 1 & 0xFFFF;
                break;
            }
            case 23: {
                mv = this.sspCtx.mem.bank.RAM1[2];
                this.sspCtx.mem.bank.RAM1[2] = mv + 1 & 0xFFFF;
                break;
            }
            case 27: {
                mv = this.sspCtx.mem.bank.RAM0[3];
                this.sspCtx.mem.bank.RAM0[3] = mv + 1 & 0xFFFF;
                break;
            }
            case 31: {
                mv = this.sspCtx.mem.bank.RAM1[3];
                this.sspCtx.mem.bank.RAM1[3] = mv + 1 & 0xFFFF;
                break;
            }
            default: {
                return 0;
            }
        }
        return this.svpCtx.iram_rom[mv];
    }

    void ptr1_write(int op, int d) {
        int t = op & 3 | op >> 6 & 4 | op << 1 & 0x18;
        d &= 0xFFFF;
        switch (t) {
            case 0: 
            case 1: 
            case 2: {
                this.sspCtx.mem.bank.RAM0[this.sspCtx.ptr.bank.r0[t & 3]] = d;
                return;
            }
            case 3: {
                this.sspCtx.mem.bank.RAM0[0] = d;
                return;
            }
            case 4: 
            case 5: 
            case 6: {
                this.sspCtx.mem.bank.RAM1[this.sspCtx.ptr.bank.r1[t & 3]] = d;
                return;
            }
            case 7: {
                this.sspCtx.mem.bank.RAM1[0] = d;
                return;
            }
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: {
                int val = this.sspCtx.ptr.bank.r0[t & 3];
                this.sspCtx.ptr.bank.r0[t & 3] = val + 1 & 0xFF;
                this.sspCtx.mem.bank.RAM0[val] = d;
                return;
            }
            case 11: {
                this.sspCtx.mem.bank.RAM0[1] = d;
                return;
            }
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                int val = this.sspCtx.ptr.bank.r1[t & 3];
                this.sspCtx.ptr.bank.r1[t & 3] = val + 1 & 0xFF;
                this.sspCtx.mem.bank.RAM1[val] = d;
                return;
            }
            case 15: {
                this.sspCtx.mem.bank.RAM1[1] = d;
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                int val = this.sspCtx.ptr.bank.r0[t & 3];
                this.sspCtx.ptr.bank.r0[t & 3] = val - 1 & 0xFF;
                this.sspCtx.mem.bank.RAM0[val] = d;
                return;
            }
            case 19: {
                this.sspCtx.mem.bank.RAM0[2] = d;
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                int val = this.sspCtx.ptr.bank.r1[t & 3];
                this.sspCtx.ptr.bank.r1[t & 3] = val - 1 & 0xFF;
                this.sspCtx.mem.bank.RAM1[val] = d;
                return;
            }
            case 23: {
                this.sspCtx.mem.bank.RAM1[2] = d;
                return;
            }
            case 27: {
                this.sspCtx.mem.bank.RAM0[3] = d;
                return;
            }
            case 31: {
                this.sspCtx.mem.bank.RAM1[3] = d;
                return;
            }
        }
    }

    private void logNewPc() {
        if (this.pcSet.add(this.PC)) {
            StringBuilder sb = new StringBuilder();
            int opcode = this.svpCtx.iram_rom[this.PC] & 0xFFFF;
            sb.setLength(0);
            sb.append("PC: ").append(Util.th(this.PC)).append(", opcode: ").append(Util.th(opcode));
            Ssp16Disasm.dasm_ssp1601(sb.append(" - "), this.PC, this.svpCtx.iram_rom);
            LOG.info(sb.toString());
        }
    }

    @Override
    public void ssp1601_run(int cycles) {
        this.SET_PC(this.rPC.h);
        this.g_cycles = cycles;
        block68: do {
            int op = this.svpCtx.iram_rom[this.PC] & 0xFFFF;
            this.PC = this.PC + 1 & 0xFFFF;
            switch (op >> 9) {
                case 0: {
                    if (op == 0) continue block68;
                    if (op == (Ssp16Types.Ssp16Reg.SSP_A.ordinal() << 4 | Ssp16Types.Ssp16Reg.SSP_P.ordinal())) {
                        this.read_P();
                        this.rA32.setV(this.rP.v);
                        break;
                    }
                    int tmpv = this.REG_READ(op & 0xF);
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 1: {
                    int tmpv = this.ptr1_read(op);
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 2: {
                    int tmpv = this.REG_READ((op & 0xF0) >> 4);
                    this.ptr1_write(op, tmpv);
                    break;
                }
                case 4: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 5: {
                    int tmpv = this.ptr2_read(op);
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 6: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.ptr1_write(op, tmpv);
                    break;
                }
                case 7: {
                    this.sspCtx.mem.setRAM(op & 0x1FF, this.rA.h);
                    break;
                }
                case 9: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(op & 3 | op >> 6 & 4);
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 10: {
                    this.sspCtx.ptr.setPointerVal(op & 3 | op >> 6 & 4, this.REG_READ((op & 0xF0) >> 4));
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.sspCtx.ptr.setPointerVal(op >> 8 & 7, op);
                    break;
                }
                case 36: {
                    int new_PC;
                    int cond = this.COND_CHECK(op);
                    if (cond > 0) {
                        new_PC = this.svpCtx.iram_rom[this.PC];
                        this.PC = this.PC + 1 & 0xFFFF;
                        this.write_STACK(this.GET_PC());
                        this.write_PC(new_PC);
                        break;
                    }
                    this.PC = this.PC + 1 & 0xFFFF;
                    break;
                }
                case 37: {
                    int tmpv = this.svpCtx.iram_rom[this.rA.h & 0xFFFF];
                    this.REG_WRITE((op & 0xF0) >> 4, tmpv);
                    break;
                }
                case 38: {
                    int new_PC;
                    int cond = this.COND_CHECK(op);
                    if (cond > 0) {
                        new_PC = this.svpCtx.iram_rom[this.PC];
                        this.PC = this.PC + 1 & 0xFFFF;
                        this.write_PC(new_PC);
                        break;
                    }
                    this.PC = this.PC + 1 & 0xFFFF;
                    break;
                }
                case 72: {
                    int cond = this.COND_CHECK(op);
                    if (cond <= 0) continue block68;
                    int val = this.rA32.v;
                    switch (op & 7) {
                        case 2: {
                            this.rA32.setV(val >> 1);
                            break;
                        }
                        case 3: {
                            this.rA32.setV(val << 1);
                            break;
                        }
                        case 6: {
                            this.rA32.setV(-val);
                            break;
                        }
                        case 7: {
                            if (val >= 0) break;
                            this.rA32.setV(-val);
                            break;
                        }
                    }
                    this.UPD_ACC_ZN();
                    break;
                }
                case 27: {
                    this.read_P();
                    this.rA32.setV(this.rA32.v - this.rP.v);
                    this.UPD_ACC_ZN();
                    this.rX.setH(this.ptr1_read_(op & 3, 0, op << 1 & 0x18));
                    this.rY.setH(this.ptr1_read_(op >> 4 & 3, 4, op >> 3 & 0x18));
                    break;
                }
                case 75: {
                    this.read_P();
                    this.rA32.setV(this.rA32.v + this.rP.v);
                    this.UPD_ACC_ZN();
                    this.rX.setH(this.ptr1_read_(op & 3, 0, op << 1 & 0x18));
                    this.rY.setH(this.ptr1_read_(op >> 4 & 3, 4, op >> 3 & 0x18));
                    break;
                }
                case 91: {
                    this.rA32.setV(0L);
                    this.rST.setH(this.rST.h & 0xFFF);
                    this.rX.setH(this.ptr1_read_(op & 3, 0, op << 1 & 0x18));
                    this.rY.setH(this.ptr1_read_(op >> 4 & 3, 4, op >> 3 & 0x18));
                    break;
                }
                case 16: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_SUBA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 48: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_CMPA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 64: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_ADDA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 80: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_ANDA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 96: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_ORA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_ORA(tmpv);
                    break;
                }
                case 112: {
                    int tmpv = this.OP_CHECK32(op);
                    if (tmpv != Integer.MIN_VALUE) {
                        this.OP_EORA32(tmpv);
                        break;
                    }
                    tmpv = this.REG_READ(op & 0xF);
                    this.OP_EORA(tmpv);
                    break;
                }
                case 17: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 49: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 65: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 81: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 97: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_ORA(tmpv);
                    break;
                }
                case 113: {
                    int tmpv = this.ptr1_read(op);
                    this.OP_EORA(tmpv);
                    break;
                }
                case 3: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_LDA(tmpv);
                    break;
                }
                case 19: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 51: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 67: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 83: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 99: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_ORA(tmpv);
                    break;
                }
                case 115: {
                    int tmpv = this.sspCtx.mem.readRAM(op & 0x1FF);
                    this.OP_EORA(tmpv);
                    break;
                }
                case 20: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 52: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 68: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 84: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 100: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_ORA(tmpv);
                    break;
                }
                case 116: {
                    int tmpv = this.svpCtx.iram_rom[this.PC];
                    this.PC = this.PC + 1 & 0xFFFF;
                    this.OP_EORA(tmpv);
                    break;
                }
                case 21: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 53: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 69: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 85: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 101: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_ORA(tmpv);
                    break;
                }
                case 117: {
                    int tmpv = this.ptr2_read(op);
                    this.OP_EORA(tmpv);
                    break;
                }
                case 25: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_SUBA(tmpv);
                    break;
                }
                case 57: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_CMPA(tmpv);
                    break;
                }
                case 73: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_ADDA(tmpv);
                    break;
                }
                case 89: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_ANDA(tmpv);
                    break;
                }
                case 105: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_ORA(tmpv);
                    break;
                }
                case 121: {
                    int tmpv = this.sspCtx.ptr.getPointerVal(this.IJind(op));
                    this.OP_EORA(tmpv);
                    break;
                }
                case 28: {
                    this.OP_SUBA(op & 0xFF);
                    break;
                }
                case 60: {
                    this.OP_CMPA(op & 0xFF);
                    break;
                }
                case 76: {
                    this.OP_ADDA(op & 0xFF);
                    break;
                }
                case 92: {
                    this.OP_ANDA(op & 0xFF);
                    break;
                }
                case 108: {
                    this.OP_ORA(op & 0xFF);
                    break;
                }
                case 124: {
                    this.OP_EORA(op & 0xFF);
                    break;
                }
                default: {
                    LOG.error("ssp FIXME unhandled op {} @ {}", (Object)op, (Object)this.GET_PPC_OFFS());
                }
            }
        } while (--this.g_cycles > 0 && (this.sspCtx.emu_status & 0xF000) == 0);
        this.read_P();
        this.rPC.setH(this.GET_PC());
    }

    void debug_dump(boolean force) {
        if (!force) {
            return;
        }
        String sb = "\n\n" + String.format("GR0:   %04x    X: %04x    Y: %04x  A: %08x\n", this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_GR0.ordinal()].h, this.rX.h, this.rY.h, this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_A.ordinal()].v) + String.format("PC:    %04x  (%04x)                P: %08x\n", this.GET_PC(), this.GET_PC() << 1, this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_P.ordinal()].v) + String.format("PM0:   %04x  PM1: %04x  PM2: %04x\n", this.rPM0.h, this.rPM1.h, this.rPM2.h) + String.format("XST:   %04x  PM4: %04x  PMC: %08x\n", this.rXST.h, this.rPM4.h, this.sspCtx.gr[Ssp16Types.Ssp16Reg.SSP_PMC.ordinal()].v) + String.format(" ST:   %04x  %c%c%c%c,  GP0_0 %x,  GP0_1 %x\n", this.rST.h, Character.valueOf((this.rST.h & 0x8000) > 0 ? (char)'N' : 'n'), Character.valueOf((this.rST.h & 0x4000) > 0 ? (char)'V' : 'v'), Character.valueOf((this.rST.h & 0x2000) > 0 ? (char)'Z' : 'z'), Character.valueOf((this.rST.h & 0x1000) > 0 ? (char)'L' : 'l'), this.rST.h >> 5 & 1, this.rST.h >> 6 & 1) + String.format("STACK: %d %04x %04x %04x %04x %04x %04x\n", this.rSTACK.h, this.sspCtx.stack[0], this.sspCtx.stack[1], this.sspCtx.stack[2], this.sspCtx.stack[3], this.sspCtx.stack[4], this.sspCtx.stack[5]) + String.format("r0-r2: %02x %02x %02x  r4-r6: %02x %02x %02x\n", this.sspCtx.ptr.getPointerVal(0), this.sspCtx.ptr.getPointerVal(1), this.sspCtx.ptr.getPointerVal(2), this.sspCtx.ptr.getPointerVal(4), this.sspCtx.ptr.getPointerVal(5), this.sspCtx.ptr.getPointerVal(6)) + String.format("cycles: %d, emu_status: %x\n\n", this.g_cycles, this.sspCtx.emu_status);
        LOG.info(sb);
    }

    void debug_dump_mem() {
        LOG.info("RAM0\n");
        for (int h = 0; h < 32; ++h) {
            if (h == 16) {
                LOG.info("RAM1\n");
            }
            LOG.info(String.format("%03x:", h * 16));
            for (int i = 0; i < 16; ++i) {
                LOG.info(String.format(" %04x", this.sspCtx.mem.readRAM(h * 16 + i)));
            }
            LOG.info("\n");
        }
    }
}

