/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.ssp16;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.stream.IntStream;

public interface Ssp16Types {
    public static final Svp_t NO_SVP_CONTEXT = new Svp_t(new Ssp1601_t());

    public static class Svp_t
    implements Serializable {
        public Ssp1601_t ssp1601;
        public transient int[] iram_rom = new int[65536];
        public int[] dram = new int[65536];
        private int[] iramSerial = new int[1024];

        protected Svp_t(Ssp1601_t ssp1601) {
            this.ssp1601 = ssp1601;
        }

        public void writeRamWord(int addressWord, int value) {
            this.dram[addressWord & 0xFFFF] = value & 0xFFFF;
        }

        public int readRamWord(int addressWord) {
            return this.dram[addressWord & 0xFFFF] & 0xFFFF;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            System.arraycopy(this.iram_rom, 0, this.iramSerial, 0, 1024);
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.iram_rom = new int[65536];
            System.arraycopy(this.iramSerial, 0, this.iram_rom, 0, 1024);
        }
    }

    public static class Ssp1601_t
    implements Serializable {
        public mem mem = new mem();
        public ptr ptr = new ptr();
        public Ssp_reg_t[] gr = new Ssp_reg_t[16];
        public short[] stack = new short[6];
        public int emu_status;
        public int[][] pmac = new int[2][6];

        public Ssp1601_t() {
            IntStream.range(0, this.gr.length).forEach(i -> {
                this.gr[i] = new Ssp_reg_t();
            });
        }

        public byte[] getR() {
            return null;
        }

        public int[] getR(boolean zero) {
            return zero ? this.ptr.bank.r0 : this.ptr.bank.r1;
        }

        public int getEmu_status() {
            return this.emu_status;
        }

        public void setEmu_status(int emu_status) {
            this.emu_status = emu_status;
        }

        public void setRegisterValue(Ssp16Reg reg, int value) {
            this.gr[reg.ordinal()].h = (short)value;
        }

        public int getRegisterValue(Ssp16Reg reg) {
            return this.gr[reg.ordinal()].h;
        }

        class mem
        implements Serializable {
            bank bank = new bank();

            mem() {
            }

            public void setRAM(int addr, int val) {
                if (addr < 256) {
                    this.bank.RAM0[addr] = val;
                } else {
                    this.bank.RAM1[addr & 0xFF] = val;
                }
            }

            public int readRAM(int addr) {
                if (addr < 256) {
                    return this.bank.RAM0[addr];
                }
                return this.bank.RAM1[addr & 0xFF];
            }

            class bank
            implements Serializable {
                int[] RAM0 = new int[256];
                int[] RAM1 = new int[256];

                bank() {
                }
            }
        }

        public class ptr
        implements Serializable {
            static final int REGS_PER_BANK = 4;
            public bank bank = new bank();

            public int getPointerVal(int pos) {
                return pos < 4 ? this.bank.r0[pos] : this.bank.r1[pos - 4];
            }

            public void setPointerVal(int pos, int val) {
                int pos1 = pos % 4;
                if (pos1 == 3) {
                    return;
                }
                int[] rg = pos < 4 ? this.bank.r0 : this.bank.r1;
                rg[pos1] = val & 0xFF;
            }

            public class bank
            implements Serializable {
                public int[] r0 = new int[4];
                public int[] r1 = new int[4];
            }
        }
    }

    public static class Cart {
        public transient int[] rom;
    }

    public static class Ssp_reg_t
    implements Serializable {
        public int v;
        public short l;
        public short h;

        public void setV(long v) {
            this.v = (int)v;
            this.h = (short)(this.v >> 16);
            this.l = (short)(this.v & 0xFFFF);
        }

        public final void setH(int h) {
            this.h = (short)h;
            this.v = h << 16 | this.v & 0xFFFF;
        }

        public void setL(int l) {
            this.l = (short)l;
            this.v = this.v & 0xFFFF0000 | l & 0xFFFF;
        }
    }

    public static enum Ssp16Reg {
        SSP_GR0,
        SSP_X,
        SSP_Y,
        SSP_A,
        SSP_ST,
        SSP_STACK,
        SSP_PC,
        SSP_P,
        SSP_PM0,
        SSP_PM1,
        SSP_PM2,
        SSP_XST,
        SSP_PM4,
        SSP_gr13,
        SSP_PMC,
        SSP_AL;

    }
}

