/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.z80.debug;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.cpu.z80.Z80CoreWrapper;
import omegadrive.cpu.z80.Z80Helper;
import omegadrive.cpu.z80.disasm.Z80Dasm;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import z80core.Z80State;

public class Z80CoreWrapperFastDebug
extends Z80CoreWrapper
implements CpuFastDebug.CpuDebugInfoProvider {
    private static final Logger LOG = LogHelper.getLogger(Z80CoreWrapperFastDebug.class.getSimpleName());
    private static final int debugMode = Integer.parseInt(System.getProperty("helios.z80.debug.mode", "0"));
    private static final Map<Integer, Integer> areaMaskMap = ImmutableMap.of((Object)0, (Object)65535);
    protected Z80Dasm z80Disasm;
    private CpuFastDebug fastDebug;
    private int pc;
    private int opcode;
    public static final Predicate<Integer> isLoopOpcode = op -> {
        int byte2 = 0;
        if (op == 203 || op == 221 || op == 237 || op == 253) {
            return false;
        }
        return Z80Helper.isBusyLoop(op, byte2);
    };
    public static final Predicate<Integer> isIgnoreOpcode = op -> op == 203 || op == 221 || op == 237 || op == 253;

    @Override
    protected Z80CoreWrapper setupInternal(Z80State z80State) {
        super.setupInternal(z80State);
        this.z80Disasm = new Z80Dasm();
        this.fastDebug = new CpuFastDebug(this, this.createContext());
        return this;
    }

    @Override
    public int executeInstruction() {
        this.printDebugMaybe();
        return this.fastDebug.isBusyLoop(this.pc, this.opcode) + super.executeInstruction();
    }

    private void printDebugMaybe() {
        this.pc = this.z80Core.getRegPC();
        this.opcode = this.memIoOps.fetchOpcode(this.pc);
        this.fastDebug.printDebugMaybe();
    }

    private CpuFastDebug.CpuDebugContext createContext() {
        CpuFastDebug.CpuDebugContext ctx = new CpuFastDebug.CpuDebugContext(areaMaskMap);
        ctx.pcAreaShift = 31;
        ctx.isLoopOpcode = isLoopOpcode;
        ctx.isIgnoreOpcode = isIgnoreOpcode;
        ctx.debugMode = debugMode;
        ctx.cpuCode = BufferUtil.CpuDeviceAccess.Z80.cpuShortCode;
        return ctx;
    }

    @Override
    public String getInstructionOnly(int pc) {
        return Z80Helper.dumpInfo(this.z80Disasm, this.memIoOps, pc);
    }

    @Override
    public String getInstructionOnly(int pc, int opcode) {
        return Z80Helper.dumpInfo(this.z80Disasm, this.memIoOps, pc);
    }

    @Override
    public String getCpuState(String head) {
        return head + this.getInstructionOnly() + "\n" + Z80Helper.toString(this.z80Core.getZ80State());
    }

    @Override
    public int getPc() {
        return this.pc;
    }

    @Override
    public int getOpcode() {
        return this.opcode;
    }
}

