/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import omegadrive.input.InputProvider;
import omegadrive.joypad.BasePadAdapter;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class ColecoPad
extends BasePadAdapter {
    private static final Logger LOG = LogHelper.getLogger(ColecoPad.class.getSimpleName());
    private final Map<JoypadProvider.JoypadButton, JoypadProvider.JoypadAction> stateMapKeypad = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.K0, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K1, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K2, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K3, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K4, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K5, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K6, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K7, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K8, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K9, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K_AST, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.K_HASH, (Object)JoypadProvider.JoypadAction.RELEASED).build());
    private final Map<JoypadProvider.JoypadButton, Integer> valueMapKeypad = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.K0, (Object)10).put((Object)JoypadProvider.JoypadButton.K1, (Object)13).put((Object)JoypadProvider.JoypadButton.K2, (Object)7).put((Object)JoypadProvider.JoypadButton.K3, (Object)12).put((Object)JoypadProvider.JoypadButton.K4, (Object)2).put((Object)JoypadProvider.JoypadButton.K5, (Object)3).put((Object)JoypadProvider.JoypadButton.K6, (Object)14).put((Object)JoypadProvider.JoypadButton.K7, (Object)5).put((Object)JoypadProvider.JoypadButton.K8, (Object)1).put((Object)JoypadProvider.JoypadButton.K9, (Object)11).put((Object)JoypadProvider.JoypadButton.K_AST, (Object)9).put((Object)JoypadProvider.JoypadButton.K_HASH, (Object)6).build());
    private boolean mode80 = false;

    @Override
    public void init() {
        this.p1Type = JoypadProvider.JoypadType.BUTTON_2;
        this.p2Type = JoypadProvider.JoypadType.BUTTON_2;
        LOG.info("Joypad1: {} - Joypad2: {}", (Object)this.p1Type, (Object)this.p2Type);
        this.stateMap1 = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.D, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.U, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.L, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.R, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.A, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.B, (Object)JoypadProvider.JoypadAction.RELEASED).build());
        this.stateMap2 = Maps.newHashMap((Map)this.stateMap1);
    }

    public void writeDataRegister1(long data) {
        this.mode80 = (data & 0xC0L) != 192L;
    }

    public int readDataRegister1() {
        return this.mode80 ? this.getMode80(InputProvider.PlayerNumber.P1) : this.getModeC0(InputProvider.PlayerNumber.P1);
    }

    public int readDataRegister2() {
        return this.mode80 ? this.getMode80(InputProvider.PlayerNumber.P2) : this.getModeC0(InputProvider.PlayerNumber.P2);
    }

    @Override
    public void setButtonAction(InputProvider.PlayerNumber number, JoypadProvider.JoypadButton button, JoypadProvider.JoypadAction action) {
        JoypadProvider.JoypadAction res = this.getMap(number).computeIfPresent(button, (k, v) -> action);
        if (res == null && InputProvider.PlayerNumber.P1 == number) {
            this.stateMapKeypad.computeIfPresent(button, (k, v) -> action);
        }
    }

    private int getModeC0(InputProvider.PlayerNumber number) {
        return 0x30 | this.getValue(number, JoypadProvider.JoypadButton.A) << 6 | this.getValue(number, JoypadProvider.JoypadButton.L) << 3 | this.getValue(number, JoypadProvider.JoypadButton.D) << 2 | this.getValue(number, JoypadProvider.JoypadButton.R) << 1 | this.getValue(number, JoypadProvider.JoypadButton.U);
    }

    private int getMode80(InputProvider.PlayerNumber number) {
        int res = 0x30 | this.getValue(number, JoypadProvider.JoypadButton.B) << 6;
        if (number == InputProvider.PlayerNumber.P1) {
            Optional<JoypadProvider.JoypadButton> pressedBtn = this.stateMapKeypad.entrySet().stream().filter(e -> e.getValue() == JoypadProvider.JoypadAction.PRESSED).map(Map.Entry::getKey).findFirst();
            res |= pressedBtn.map(this.valueMapKeypad::get).orElse(15).intValue();
        } else {
            res |= 0xF;
        }
        return res;
    }
}

