/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import omegadrive.util.Util;

public class MdInputModel {
    public static final int DATA_TH_LOW = 0;
    public static final int DATA_TH_HIGH = 64;
    public static final int TH_MASK = 64;
    public static final int CTRL_PIN_INPUT = 0;
    public static final int CTRL_PIN_OUTPUT = 64;
    public static final Predicate<Integer> isCtrlThInput = v -> (v & 0x40) == 0;
    public static final Predicate<Integer> isDataThHigh = v -> (v & 0x40) == 64;
    public static final BiFunction<Integer, Integer, PeripheralId> toPeripheralId = (b1, b2) -> {
        byte res1 = (byte)b1.intValue();
        byte res2 = (byte)b2.intValue();
        int val = (Util.getBitFromByte(res1, 3) | Util.getBitFromByte(res1, 2)) << 3 | (Util.getBitFromByte(res1, 1) | Util.getBitFromByte(res1, 0)) << 2 | (Util.getBitFromByte(res2, 3) | Util.getBitFromByte(res2, 2)) << 1 | (Util.getBitFromByte(res2, 1) | Util.getBitFromByte(res2, 0)) << 0;
        return PeripheralId.values()[val];
    };

    public static enum PeripheralId {
        MENACER,
        JUSTIFIER,
        NONE2(false),
        MOUSE,
        NONE4(false),
        SATURN_OTHER,
        NONE6(false),
        SEGA_MULTITAP,
        NONE8(false),
        NONE9(false),
        PRINTER,
        SATURN_PAD,
        MD_PAD11,
        MD_PAD,
        NONE15(false),
        UNDETECTABLE(false);

        public final boolean valid;

        private PeripheralId(boolean v) {
            this.valid = v;
        }

        private PeripheralId() {
            this(true);
        }
    }

    public static class MdPadContext {
        int control = 0;
        int data;
        int readMask;
        int readStep;
        final int player;
        int latestWriteCycleCounter;

        MdPadContext(int p) {
            this.player = p;
        }

        public String toString() {
            return new StringJoiner(", ", MdPadContext.class.getSimpleName() + "[", "]").add("control=" + this.control).add("data=" + this.data).add("readMask=" + this.readMask).add("readStep=" + this.readStep).add("player=" + this.player).add("latestWriteCycleCounter=" + this.latestWriteCycleCounter).toString();
        }
    }

    public static enum SixButtonState {
        CBRLDU_0,
        SA00DU_1,
        CBRLDU_2,
        SA00DU_3,
        CBRLDU_4,
        SA0000_5,
        CBMXYZ_6,
        SA1111_7;

        public static final SixButtonState[] vals;

        static {
            vals = SixButtonState.values();
        }
    }
}

