/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.Maps;
import java.util.Map;
import omegadrive.input.InputProvider;
import omegadrive.joypad.BasePadAdapter;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class TwoButtonsJoypad
extends BasePadAdapter {
    private static final Logger LOG = LogHelper.getLogger(TwoButtonsJoypad.class.getSimpleName());
    private int pauseButton1 = 1;
    private int pauseButton2 = 1;

    @Override
    public void init() {
        this.p1Type = JoypadProvider.JoypadType.BUTTON_2;
        this.p2Type = JoypadProvider.JoypadType.BUTTON_2;
        LOG.info("Joypad1: {} - Joypad2: {}", (Object)this.p1Type, (Object)this.p2Type);
        this.stateMap1 = Maps.newHashMap((Map)releasedMap);
        this.stateMap2 = Maps.newHashMap((Map)releasedMap);
    }

    public int readDataRegister1() {
        return this.value1;
    }

    public int readDataRegister2() {
        return this.value2;
    }

    public int readDataRegister3() {
        return this.pauseButton1 + this.pauseButton2;
    }

    private int get2D_2U_1B_1A_1R_1L_1D_1U() {
        return this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.D) << 7 | this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.U) << 6 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.B) << 5 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.A) << 4 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.R) << 3 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.L) << 2 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.D) << 1 | this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.U);
    }

    private int getR_2B_2A_2R_2L() {
        return 0xF0 | this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.B) << 3 | this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.A) << 2 | this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.R) << 1 | this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.L);
    }

    @Override
    public void newFrame() {
        this.value1 = this.get2D_2U_1B_1A_1R_1L_1D_1U();
        this.value2 = this.getR_2B_2A_2R_2L();
        this.pauseButton1 = this.getValue(InputProvider.PlayerNumber.P1, JoypadProvider.JoypadButton.S);
        this.pauseButton2 = this.getValue(InputProvider.PlayerNumber.P2, JoypadProvider.JoypadButton.S);
    }
}

