/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.savestate.GshStateHandler;
import omegadrive.savestate.MekaStateHandler;
import omegadrive.savestate.NesStateHandler;
import omegadrive.savestate.Z80StateBaseHandler;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import s32x.savestate.Gs32xStateHandler;

public interface BaseStateHandler {
    public static final Logger LOG = LogHelper.getLogger(BaseStateHandler.class.getSimpleName());
    public static final BaseStateHandler EMPTY_STATE = new BaseStateHandler(){

        @Override
        public Type getType() {
            return null;
        }

        @Override
        public String getFileName() {
            return null;
        }

        @Override
        public ByteBuffer getDataBuffer() {
            return null;
        }
    };

    public Type getType();

    public String getFileName();

    public ByteBuffer getDataBuffer();

    public static BaseStateHandler createInstance(SystemLoader.SystemType systemType, Path filePath, Type type, Set<Device> devices) {
        return BaseStateHandler.createInstance(systemType, filePath.toAbsolutePath().toString(), type, devices);
    }

    public static BaseStateHandler createInstance(SystemLoader.SystemType systemType, String fileName, Type type, Set<Device> devices) {
        BaseStateHandler h = EMPTY_STATE;
        switch (systemType) {
            case MD: {
                h = GshStateHandler.createInstance(fileName, type, devices);
                break;
            }
            case S32X: {
                h = Gs32xStateHandler.createInstance(fileName, type, devices);
                break;
            }
            case SMS: 
            case GG: {
                h = MekaStateHandler.createInstance(systemType, fileName, type, devices);
                break;
            }
            case MSX: 
            case COLECO: 
            case SG_1000: {
                h = Z80StateBaseHandler.createInstance(fileName, systemType, type, devices);
                break;
            }
            case NES: {
                h = NesStateHandler.createInstance(fileName, type);
                break;
            }
            default: {
                LOG.error("{} doesn't support savestates", (Object)systemType);
            }
        }
        return h;
    }

    default public void processState() {
    }

    default public byte[] getData() {
        return this.getDataBuffer().array();
    }

    default public void storeData() {
        LOG.info("Persisting savestate to: {}", (Object)this.getFileName());
        FileUtil.writeFileSafe(Paths.get(this.getFileName(), new String[0]), this.getData());
    }

    public static enum Type {
        SAVE,
        LOAD;

    }
}

