/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import m68k.cpu.MC68000;
import omegadrive.Device;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.bus.model.MdZ80BusProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.memory.IMemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.savestate.StateUtil;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.util.LogHelper;
import omegadrive.vdp.model.BaseVdpProvider;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import org.slf4j.Logger;
import z80core.Z80;
import z80core.Z80State;

public class GstStateHandler
implements BaseStateHandler {
    private static final Logger LOG = LogHelper.getLogger(GstStateHandler.class.getSimpleName());
    private static final int FM_REG_OFFSET = 484;
    public static final int FM_DATA_SIZE = 512;
    private static final int VDP_REG_OFFSET = 250;
    private static final int CRAM_DATA_OFFSET = 274;
    private static final int VRAM_DATA_OFFSET = 74872;
    private static final int VSRAM_DATA_OFFSET = 402;
    private static final int Z80_RAM_DATA_OFFSET = 1140;
    private static final int M68K_RAM_DATA_OFFSET = 9336;
    private static final int M68K_REGD_OFFSET = 128;
    private static final int M68K_REGA_OFFSET = 160;
    public static final int M68K_SSP_OFFSET = 210;
    public static final int M68K_USP_OFFSET = 214;
    protected static final int VERSION_OFFSET = 80;
    protected static final int SWID_OFFSET = 81;
    public static final int FILE_SIZE = 140408;
    protected static final String extension = ".gs";
    private static final Set<Class<? extends Device>> deviceClassSet = ImmutableSet.of(Z80Provider.class, MdVdpProvider.class, IMemoryProvider.class, MdMainBusProvider.class, SoundProvider.class, MC68000Wrapper.class, (Object[])new Class[0]);
    protected ByteBuffer buffer;
    protected int version;
    protected int softwareId;
    protected String fileName;
    protected BaseStateHandler.Type type;
    protected boolean runAhead;
    private List<Device> deviceList = Collections.emptyList();

    protected GstStateHandler() {
    }

    public void setData(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
    }

    @Override
    public BaseStateHandler.Type getType() {
        return this.type;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    @Override
    public void processState() {
        MdMainBusProvider bus = StateUtil.getInstanceOrThrow(this.deviceList, MdMainBusProvider.class);
        BaseVdpProvider vdp = StateUtil.getInstanceOrThrow(this.deviceList, BaseVdpProvider.class);
        Z80Provider z80 = StateUtil.getInstanceOrThrow(this.deviceList, Z80Provider.class);
        IMemoryProvider mem2 = StateUtil.getInstanceOrThrow(this.deviceList, IMemoryProvider.class);
        MC68000Wrapper cpu = StateUtil.getInstanceOrThrow(this.deviceList, MC68000Wrapper.class);
        SoundProvider sound = StateUtil.getInstanceOrThrow(this.deviceList, SoundProvider.class);
        if (this.type == BaseStateHandler.Type.LOAD) {
            this.loadFmState(sound.getFm());
            this.loadVdpState(vdp);
            this.loadZ80(z80, bus);
            this.load68k(cpu, mem2);
        } else {
            this.saveFm(sound.getFm());
            this.saveZ80(z80, bus);
            this.save68k(cpu, mem2);
            this.saveVdp(vdp);
        }
        if (this.type == BaseStateHandler.Type.LOAD) {
            LOG.info("Savestate loaded from: {}", (Object)this.fileName);
        }
    }

    protected void setDevicesWithContext(Set<Device> devs) {
        if (!this.deviceList.isEmpty()) {
            LOG.warn("Overwriting device list: {}", (Object)Arrays.toString(this.deviceList.toArray()));
        }
        this.deviceList = StateUtil.getDeviceOrderList(deviceClassSet, devs);
    }

    public void loadFmState(FmProvider fm) {
        int limit = 256;
        this.buffer.position(484);
        for (int reg = 0; reg < limit; ++reg) {
            fm.write(0, reg & 0xFF);
            fm.write(1, this.buffer.get(484 + reg) & 0xFF);
            do {
                fm.tick();
            } while ((fm.read() & 0x40) > 0);
            fm.write(2, reg & 0xFF);
            fm.write(3, this.buffer.get(484 + limit + reg) & 0xFF);
            do {
                fm.tick();
            } while ((fm.read() & 0x40) > 0);
        }
    }

    protected void loadVdpState(BaseVdpProvider vdp) {
        IntStream.range(0, 24).forEach(i -> vdp.updateRegisterData(i, this.buffer.get(i + 250) & 0xFF));
        this.loadVdpMemory(vdp.getVdpMemory());
        vdp.reload();
    }

    protected void loadVdpMemory(VdpMemoryInterface vmi) {
        for (int i = 0; i < 65536; i += 2) {
            vmi.writeVideoRamByte(MdVdpProvider.VdpRamType.VRAM, i, this.buffer.get(i + 74872));
            vmi.writeVideoRamByte(MdVdpProvider.VdpRamType.VRAM, i + 1, this.buffer.get(i + 74872 + 1));
        }
        byte[] cram = vmi.getCram().array();
        for (int i = 0; i < 128; i += 2) {
            cram[i] = this.buffer.get(i + 274 + 1);
            cram[i + 1] = this.buffer.get(i + 274);
        }
        byte[] vsram = vmi.getVsram().array();
        for (int i = 0; i < 80; i += 2) {
            vsram[i] = this.buffer.get(i + 402);
            vsram[i + 1] = this.buffer.get(i + 402 + 1);
        }
    }

    protected void loadZ80(Z80Provider z80, MdMainBusProvider bus) {
        boolean isReset;
        int z80BankInt = StateUtil.getInt4Fn.apply(this.buffer, 1084);
        MdZ80BusProvider.setRomBank68kSerial(z80, z80BankInt);
        bus.setZ80BusRequested((this.buffer.get(1081) & 0xFF) > 0);
        bus.setZ80ResetState(false);
        boolean bl = isReset = (this.buffer.get(1080) & 0xFF) > 0;
        if (isReset && this.runAhead) {
            LOG.warn("Z80 should be reset, not doing it!");
            bus.setZ80ResetState(true);
            z80.reset();
        }
        IntStream.range(0, 8192).forEach(i -> z80.writeMemory(i, this.buffer.get(i + 1140) & 0xFF));
        Z80State z80State = StateUtil.loadZ80StateGst(this.buffer);
        z80State.setIM(Z80.IntMode.IM1);
        z80.loadZ80State(z80State);
    }

    protected void load68k(MC68000Wrapper m68kProvider, IMemoryProvider memoryProvider) {
        for (int i2 = 0; i2 < 65536; i2 += 2) {
            memoryProvider.writeRamByte(i2, this.buffer.get(i2 + 9336));
            memoryProvider.writeRamByte(i2 + 1, this.buffer.get(i2 + 9336 + 1));
        }
        MC68000 m68k = m68kProvider.getM68k();
        m68k.setSR(StateUtil.getInt2Fn.apply(this.buffer, 208).intValue());
        IntStream.range(0, 8).forEach(i -> m68k.setDataRegisterLong(i, StateUtil.getInt4Fn.apply(this.buffer, 128 + i * 4).intValue()));
        IntStream.range(0, 8).forEach(i -> m68k.setAddrRegisterLong(i, StateUtil.getInt4Fn.apply(this.buffer, 160 + i * 4).intValue()));
        m68k.setPC(StateUtil.getInt4Fn.apply(this.buffer, 200).intValue());
        int ssp = StateUtil.getInt4Fn.apply(this.buffer, 210);
        int usp = StateUtil.getInt4Fn.apply(this.buffer, 214);
        if (usp > 0) {
            LOG.warn("USP is not 0: {}", (Object)usp);
        }
        if (ssp > 0) {
            LOG.warn("SSP is not 0: {}", (Object)ssp);
        }
    }

    protected void saveFm(FmProvider fm) {
        int limit = 256;
        for (int i = 0; i < limit; ++i) {
            this.buffer.put(484 + i, (byte)fm.readRegister(0, i));
            this.buffer.put(484 + i + limit, (byte)fm.readRegister(1, i));
        }
    }

    protected void saveVdp(BaseVdpProvider vdp) {
        VdpMemoryInterface vdpMemoryInterface = vdp.getVdpMemory();
        byte[] vram = vdpMemoryInterface.getVram().array();
        for (int i2 = 0; i2 < 65536; i2 += 2) {
            this.buffer.put(i2 + 74872, vram[i2]);
            this.buffer.put(i2 + 74872 + 1, vram[i2 + 1]);
        }
        byte[] cram = vdpMemoryInterface.getCram().array();
        for (int i3 = 0; i3 < 128; i3 += 2) {
            this.buffer.put(i3 + 274 + 1, cram[i3]);
            this.buffer.put(i3 + 274, cram[i3 + 1]);
        }
        byte[] vsram = vdpMemoryInterface.getVsram().array();
        for (int i4 = 0; i4 < 80; i4 += 2) {
            this.buffer.put(i4 + 402, vsram[i4]);
            this.buffer.put(i4 + 402 + 1, vsram[i4 + 1]);
        }
        IntStream.range(0, 24).forEach(i -> this.buffer.put(i + 250, (byte)vdp.getRegisterData(i)));
    }

    protected void saveZ80(Z80Provider z80, MdMainBusProvider bus) {
        IntStream.range(0, 8192).forEach(i -> this.buffer.put(1140 + i, (byte)z80.readMemory(i)));
        this.buffer.put(1080, (byte)(bus.isZ80ResetState() ? 1 : 0));
        this.buffer.put(1081, (byte)(bus.isZ80BusRequested() ? 1 : 0));
        int romBankSerial = MdZ80BusProvider.getRomBank68kSerial(z80);
        if (romBankSerial >= 0) {
            StateUtil.setInt4LEFn(this.buffer, 1084, romBankSerial);
        }
        StateUtil.saveZ80StateGst(this.buffer, z80.getZ80State());
    }

    protected void save68k(MC68000Wrapper mc68000Wrapper, IMemoryProvider memoryProvider) {
        for (int i2 = 0; i2 < 65536; i2 += 2) {
            this.buffer.put(i2 + 9336, memoryProvider.readRamByte(i2));
            this.buffer.put(i2 + 1 + 9336, memoryProvider.readRamByte(i2 + 1));
        }
        MC68000 m68k = mc68000Wrapper.getM68k();
        StateUtil.setInt4LEFn(this.buffer, 200, m68k.getPC());
        StateUtil.setInt2LEFn(this.buffer, 208, m68k.getSR());
        StateUtil.setInt4LEFn(this.buffer, 210, m68k.getSSP());
        StateUtil.setInt4LEFn(this.buffer, 214, m68k.getUSP());
        IntStream.range(0, 8).forEach(i -> StateUtil.setInt4LEFn(this.buffer, 128 + i * 4, m68k.getDataRegisterLong(i)));
        IntStream.range(0, 8).forEach(i -> StateUtil.setInt4LEFn(this.buffer, 160 + i * 4, m68k.getAddrRegisterLong(i)));
    }
}

