/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound;

import javax.sound.sampled.AudioFormat;
import omegadrive.Device;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.SoundUtil;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import org.slf4j.Logger;

public interface SoundProvider
extends Device,
BaseVdpAdapterEventSupport.VdpEventListener,
SoundDevice.MutableDevice {
    public static final Logger LOG = LogHelper.getLogger(SoundProvider.class.getSimpleName());
    public static final long PAL_PSG_CLOCK = 3546894L;
    public static final long NTSC_PSG_CLOCK = 3579545L;
    public static final long NTSC_FM_CLOCK = 7670453L;
    public static final long PAL_FM_CLOCK = 7600489L;
    public static final int SAMPLE_RATE_HZ = Integer.parseInt(System.getProperty("audio.sample.rate.hz", "44100"));
    public static final int DEFAULT_BUFFER_SIZE_MS = 50;
    public static final int AUDIO_BUFFER_LEN_MS = Integer.parseInt(System.getProperty("audio.buffer.length.ms", String.valueOf(50)));
    public static final boolean ENABLE_SOUND = Boolean.parseBoolean(System.getProperty("helios.enable.sound", "true"));
    public static final boolean JAL_SOUND_MGR = Boolean.parseBoolean(System.getProperty("helios.jal.sound.mgr", "false"));
    public static final SoundProvider NO_SOUND = new SoundProvider(){

        @Override
        public PsgProvider getPsg() {
            return PsgProvider.NO_SOUND;
        }

        @Override
        public FmProvider getFm() {
            return FmProvider.NO_SOUND;
        }

        @Override
        public PwmProvider getPwm() {
            return PwmProvider.NO_SOUND;
        }

        @Override
        public PcmProvider getPcm() {
            return PcmProvider.NO_SOUND;
        }

        @Override
        public void init(RegionDetector.Region region) {
        }

        @Override
        public void onNewFrame() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isMute() {
            return false;
        }

        @Override
        public void setEnabled(boolean mute) {
        }

        @Override
        public void setEnabled(Device device, boolean mute) {
        }
    };

    public void init(RegionDetector.Region var1);

    public PsgProvider getPsg();

    public FmProvider getFm();

    public PwmProvider getPwm();

    public PcmProvider getPcm();

    public static int getPsgBufferByteSize(AudioFormat audioFormat) {
        return SoundProvider.getFmBufferIntSize(audioFormat) >> 1;
    }

    public static int getFmBufferIntSize(AudioFormat audioFormat) {
        return SoundUtil.getStereoSamplesBufferSize(audioFormat);
    }

    public static double getPsgSoundClock(RegionDetector.Region r) {
        return RegionDetector.Region.EUROPE != r ? 3579545L : 3546894L;
    }

    public static double getFmSoundClock(RegionDetector.Region r) {
        return RegionDetector.Region.EUROPE != r ? 7670453L : 7600489L;
    }

    public void setEnabled(Device var1, boolean var2);

    @Override
    public void close();

    @Deprecated
    default public void addExternalSoundSource(SoundDevice.MutableDevice mutableDevice) {
        LOG.warn("Ignoring: {}", mutableDevice.getClass());
    }

    default public boolean isRecording() {
        return false;
    }

    default public void setRecording(boolean recording) {
    }
}

