/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm;

import javax.sound.sampled.AudioFormat;
import omegadrive.sound.fm.AudioRateControl;
import omegadrive.sound.fm.GenericAudioProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public abstract class VariableSampleRateSource
extends GenericAudioProvider {
    private static final Logger LOG = LogHelper.getLogger(VariableSampleRateSource.class.getSimpleName());
    static final int DEFAULT_AUDIO_SCALE_BITS = 5;
    protected double microsPerOutputSample;
    protected double microsPerInputSample;
    protected double sourceSampleRate;
    protected volatile double fmCalcsPerMicros;
    private final AudioRateControl audioRateControl;
    private int sampleRatePerFrame = 0;

    protected VariableSampleRateSource(double sourceSampleRate, AudioFormat audioFormat, String sourceName) {
        this(sourceSampleRate, audioFormat, sourceName, 5);
    }

    protected VariableSampleRateSource(double sourceSampleRate, AudioFormat audioFormat, String sourceName, int audioScaleBits) {
        super(audioFormat, audioScaleBits, (int)audioFormat.getSampleRate());
        assert (audioFormat.getChannels() == 2);
        double outputSampleRate = audioFormat.getSampleRate();
        this.sourceSampleRate = sourceSampleRate;
        this.microsPerOutputSample = 1000000.0 / outputSampleRate;
        this.microsPerInputSample = 1000000.0 / sourceSampleRate;
        this.fmCalcsPerMicros = this.microsPerOutputSample;
        this.audioRateControl = new AudioRateControl(sourceName, audioFormat);
        this.start();
    }

    protected abstract void spinOnce();

    public void setMicrosPerInputSample(double microsPerInputSample) {
        this.microsPerInputSample = microsPerInputSample;
    }

    @Override
    protected void addStereoSample(int left, int right) {
        super.addStereoSample(left, right);
        this.sampleRatePerFrame += 2;
    }

    @Override
    public void reset() {
        super.reset();
        this.sampleRatePerFrame = 0;
    }

    @Override
    public void onNewFrame() {
        this.fmCalcsPerMicros = this.audioRateControl.adaptiveRateControl(this.stereoQueueLen.get(), this.fmCalcsPerMicros, this.sampleRatePerFrame);
        this.sampleRatePerFrame = 0;
    }
}

