/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.javasound;

import java.util.Arrays;
import omegadrive.Device;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.system.perf.Telemetry;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Sleeper;
import omegadrive.util.SoundUtil;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class JavaSoundManager
extends AbstractSoundManager {
    private static final Logger LOG = LogHelper.getLogger(JavaSoundManager.class.getSimpleName());
    public static int sleepTotal = 0;
    public static final long EMPTY_QUEUE_SLEEP_NS = 500000L;
    volatile int[] fm_buf_ints;
    volatile int[] pwm_buf_ints;
    volatile int[] pcm_buf_ints;
    volatile byte[] mix_buf_bytes16Stereo;
    volatile byte[] psg_buf_bytes;
    volatile int fmSizeMono;
    private Telemetry telemetry;
    private volatile int samplesProducedCount;
    private volatile int samplesConsumedCount;
    private volatile int audioThreadLoops;
    private volatile int audioThreadEmptyLoops;

    @Override
    public void init(RegionDetector.Region region) {
        super.init(region);
        this.fm_buf_ints = new int[this.fmSize];
        this.pwm_buf_ints = new int[this.fmSize];
        this.pcm_buf_ints = new int[this.fmSize];
        this.mix_buf_bytes16Stereo = new byte[this.fm_buf_ints.length << 1];
        this.psg_buf_bytes = new byte[this.psgSize];
        this.fmSizeMono = (int)Math.round((double)this.fmSize / 2.0);
        this.telemetry = Telemetry.getInstance();
        this.executorService.submit(this.getRunnable());
    }

    private int playOnceStereo(int fmBufferLenMono) {
        int fmMonoActual = this.getFm().updateStereo16(this.fm_buf_ints, 0, fmBufferLenMono) >> 1;
        fmBufferLenMono = (this.soundDeviceSetup & SoundDevice.SoundDeviceType.FM.getBit()) > 0 ? fmMonoActual : fmBufferLenMono;
        int pwmMonoActual = this.getPwm().updateStereo16(this.pwm_buf_ints, 0, fmBufferLenMono) >> 1;
        int pcmMonoActual = this.getPcm().updateStereo16(this.pcm_buf_ints, 0, fmBufferLenMono) >> 1;
        fmBufferLenMono = (this.soundDeviceSetup & SoundDevice.SoundDeviceType.PWM.getBit()) > 0 ? pwmMonoActual : fmBufferLenMono;
        fmBufferLenMono = (this.soundDeviceSetup & SoundDevice.SoundDeviceType.PCM.getBit()) > 0 ? pcmMonoActual : fmBufferLenMono;
        this.getPsg().updateMono8(this.psg_buf_bytes, 0, fmBufferLenMono);
        int fmBufferLenStereo = fmBufferLenMono << 1;
        int bufferBytesStereo = fmBufferLenMono << 2;
        this.samplesProducedCount += fmBufferLenStereo;
        try {
            Arrays.fill(this.mix_buf_bytes16Stereo, (byte)0);
            this.mixAudioProviders(fmBufferLenStereo);
            SoundUtil.writeBufferInternal(this.dataLine, this.mix_buf_bytes16Stereo, bufferBytesStereo);
            if (this.isRecording()) {
                this.soundPersister.persistSound(DEFAULT_SOUND_TYPE, this.mix_buf_bytes16Stereo);
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected sound error", (Throwable)e);
        }
        Arrays.fill(this.fm_buf_ints, 0);
        Arrays.fill(this.psg_buf_bytes, (byte)0);
        return fmBufferLenStereo;
    }

    private Runnable getRunnable() {
        return Util.wrapRunnableEx(() -> {
            int monoSize = Math.min(this.fmSizeMono, SoundUtil.getMonoSamplesBufferSize(audioFormat, 25));
            try {
                do {
                    int actualStereo = this.playOnceStereo(monoSize);
                    this.samplesConsumedCount += actualStereo;
                    if (actualStereo <= 10) {
                        ++this.audioThreadEmptyLoops;
                        Sleeper.parkExactly(500000L);
                    }
                    ++this.audioThreadLoops;
                } while (!this.close);
            }
            catch (Error | Exception e) {
                LOG.error("Unexpected sound error, stopping", e);
            }
            LOG.info("Stopping sound thread");
            this.soundDeviceMap.values().forEach(Device::reset);
        });
    }

    protected void mixAudioProviders(int inputLen) {
        if (!this.soundEnabled) {
            return;
        }
        switch (this.soundDeviceSetup) {
            case 1: {
                SoundUtil.intStereo16ToByteStereo16Mix(this.fm_buf_ints, this.mix_buf_bytes16Stereo, inputLen);
                break;
            }
            case 2: {
                SoundUtil.byteMono8ToByteStereo16Mix(this.psg_buf_bytes, this.mix_buf_bytes16Stereo);
                break;
            }
            case 3: {
                SoundUtil.intStereo14ToByteStereo16Mix(this.fm_buf_ints, this.mix_buf_bytes16Stereo, this.psg_buf_bytes, inputLen);
                break;
            }
            case 6: {
                SoundUtil.intStereo14ToByteStereo16Mix(this.pwm_buf_ints, this.mix_buf_bytes16Stereo, this.psg_buf_bytes, inputLen);
                break;
            }
            case 7: {
                SoundUtil.intStereo14ToByteStereo16PwmMix(this.mix_buf_bytes16Stereo, this.fm_buf_ints, this.pwm_buf_ints, this.psg_buf_bytes, inputLen);
                break;
            }
            case 11: {
                SoundUtil.intStereo14ToByteStereo16PwmMix(this.mix_buf_bytes16Stereo, this.fm_buf_ints, this.pcm_buf_ints, this.psg_buf_bytes, inputLen);
                break;
            }
            default: {
                LOG.error("Unable to mix the sound setup: {}", (Object)this.soundDeviceSetup);
            }
        }
    }

    @Override
    public void onNewFrame() {
        this.doStats();
        this.getFm().onNewFrame();
    }

    private void doStats() {
        this.samplesProducedCount = 0;
        this.samplesConsumedCount = 0;
        this.audioThreadEmptyLoops = 0;
        this.audioThreadLoops = 0;
    }
}

