/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.persist;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.sound.persist.SoundPersister;
import omegadrive.util.LogHelper;
import omegadrive.util.SoundUtil;
import org.slf4j.Logger;

public class FileSoundPersister
implements SoundPersister {
    private static final Logger LOG = LogHelper.getLogger(FileSoundPersister.class.getSimpleName());
    private OutputStream fileStream;
    private File rawFile;
    private boolean recording;

    @Override
    public void persistSound(SoundPersister.SoundType type, byte[] output) {
        if (!this.recording) {
            this.startRecording(type);
        }
        this.recordSound(output);
    }

    private void recordSound(byte[] buffer) {
        if (this.recording) {
            try {
                this.fileStream.write(buffer);
            }
            catch (IOException ioe) {
                LOG.error("An error occurred while writing the sound file.");
            }
        }
    }

    private void startRecordingInternal(SoundPersister.SoundType type) {
        String name = "output_" + type.name() + "_" + System.currentTimeMillis() + ".raw";
        try {
            this.rawFile = Paths.get(".", name).toFile();
            this.fileStream = Files.asByteSink((File)this.rawFile, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();
            LOG.info("Started recording file: {}", (Object)name);
            this.recording = true;
        }
        catch (IOException ioe) {
            LOG.error("Could not open file for recording.");
            System.out.println("Could not open file for recording");
        }
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void stopRecording() {
        if (this.recording) {
            try {
                this.fileStream.flush();
                this.fileStream.close();
                LOG.info("Stopped recording");
                this.recording = false;
                SoundUtil.convertToWav(AbstractSoundManager.audioFormat, this.rawFile.toString());
            }
            catch (IOException ioe) {
                LOG.error("Failed whilst closing output.raw");
            }
        }
    }

    @Override
    public void startRecording(SoundPersister.SoundType type) {
        if (!this.recording) {
            this.startRecordingInternal(type);
        }
    }
}

