/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.psg.msx;

public class Ay38910 {
    public static final int LINE_BUF_SIZE = 1024;
    protected int m_index = 0;
    private static final int AY8912_FREQ = 221660;
    private static final int MAX_CHANNEL_VOLUME = 15;
    private static final int R_FTC_A = 0;
    private static final int R_CTC_A = 1;
    private static final int R_FTC_B = 2;
    private static final int R_CTC_B = 3;
    private static final int R_FTC_C = 4;
    private static final int R_CTC_C = 5;
    private static final int R_NOISE = 6;
    private static final int R_MIXER = 7;
    private static final int R_AMP_A = 8;
    private static final int R_AMP_B = 9;
    private static final int R_AMP_C = 10;
    private static final int R_FPC_E = 11;
    private static final int R_CPC_E = 12;
    private static final int R_ENVELOPE = 13;
    private static final int R_RS232_A = 14;
    private static final int R_RS232_B = 15;
    private static final int ENV_ATTACK = 0;
    private static final int ENV_DECAY = 1;
    private static final int ENV_SUSTAIN_LOW = 2;
    private static final int ENV_SUSTAIN_HIGH = 3;
    private static final int ENV_REPEAT = 4;
    private static final int ENV_RESTART = 5;
    private static final int ENV_ERROR = 6;
    private static final int[][] ENVELOPES = new int[][]{{1, 2, 4}, {1, 2, 4}, {1, 2, 4}, {1, 2, 4}, {0, 2, 4}, {0, 2, 4}, {0, 2, 4}, {0, 2, 4}, {1, 4, 6}, {1, 2, 4}, {1, 0, 5}, {1, 3, 4}, {0, 4, 6}, {0, 3, 4}, {0, 1, 5}, {0, 2, 4}};
    private int m_pitchA;
    private int m_pitchB;
    private int m_pitchC;
    private int m_periodN;
    private int m_mixer;
    private int m_amplitudeA;
    private int m_amplitudeB;
    private int m_amplitudeC;
    private int m_periodE;
    private int m_envelopeType;
    private boolean m_useEnvelopeA;
    private boolean m_useEnvelopeB;
    private boolean m_useEnvelopeC;
    private int _counterA = 0;
    private int _counterB = 0;
    private int _counterC = 0;
    private boolean _generatorA = false;
    private boolean _generatorB = false;
    private boolean _generatorC = false;
    private int _counterN = 0;
    private boolean _generatorN = false;
    private int _counterE = 0;
    private int _tickE = 0;
    private int _envelopeState = 0;
    private int freqScale = 1;
    private static final int MAX_VOL_FACTOR = 3;

    public Ay38910(int sampleRateHz) {
        this.freqScale = 221660 / sampleRateHz;
    }

    public void reset() {
        this._generatorN = false;
        this._generatorC = false;
        this._generatorB = false;
        this._generatorA = false;
        this.m_amplitudeC = 0;
        this.m_amplitudeB = 0;
        this.m_amplitudeA = 0;
        this._tickE = 0;
        this._counterN = 0;
        this._counterE = 0;
        this._counterC = 0;
        this._counterB = 0;
        this._counterA = 0;
        this.m_pitchC = 0;
        this.m_pitchB = 0;
        this.m_pitchA = 0;
        this.m_periodN = 0;
        this.m_periodE = 0;
        this.m_useEnvelopeC = false;
        this.m_useEnvelopeB = false;
        this.m_useEnvelopeA = false;
    }

    public int in(int register) {
        switch (register) {
            case 0: {
                return this.m_pitchA & 0xFF;
            }
            case 1: {
                return (this.m_pitchA & 0xF00) >> 8;
            }
            case 2: {
                return this.m_pitchB & 0xFF;
            }
            case 3: {
                return (this.m_pitchB & 0xF00) >> 8;
            }
            case 4: {
                return this.m_pitchC & 0xFF;
            }
            case 5: {
                return (this.m_pitchC & 0xF00) >> 8;
            }
            case 6: {
                return this.m_periodN;
            }
            case 7: {
                return this.m_mixer;
            }
            case 8: {
                return this.m_amplitudeA;
            }
            case 9: {
                return this.m_amplitudeB;
            }
            case 10: {
                return this.m_amplitudeC;
            }
            case 11: {
                return this.m_periodE & 0xFF;
            }
            case 12: {
                return (this.m_periodE & 0xFF00) >> 8;
            }
            case 13: {
                return this.m_envelopeType;
            }
            case 14: 
            case 15: {
                return 255;
            }
        }
        return 0;
    }

    public void out(int register, int value) {
        switch (register) {
            case 0: {
                this.m_pitchA = this.m_pitchA & 0xF00 | value;
                break;
            }
            case 1: {
                this.m_pitchA = (value & 0xF) << 8 | this.m_pitchA & 0xFF;
                break;
            }
            case 2: {
                this.m_pitchB = this.m_pitchB & 0xF00 | value;
                break;
            }
            case 3: {
                this.m_pitchB = (value & 0xF) << 8 | this.m_pitchB & 0xFF;
                break;
            }
            case 4: {
                this.m_pitchC = this.m_pitchC & 0xF00 | value;
                break;
            }
            case 5: {
                this.m_pitchC = (value & 0xF) << 8 | this.m_pitchC & 0xFF;
                break;
            }
            case 6: {
                this.m_periodN = value & 0x1F;
                break;
            }
            case 7: {
                this.m_mixer = value;
                break;
            }
            case 8: {
                this.m_amplitudeA = value & 0xF;
                this.m_useEnvelopeA = (value & 0x10) != 0;
                break;
            }
            case 9: {
                this.m_amplitudeB = value & 0xF;
                this.m_useEnvelopeB = (value & 0x10) != 0;
                break;
            }
            case 10: {
                this.m_amplitudeC = value & 0xF;
                this.m_useEnvelopeC = (value & 0x10) != 0;
                break;
            }
            case 11: {
                this.m_periodE = this.m_periodE & 0xFF00 | value;
                break;
            }
            case 12: {
                this.m_periodE = value << 8 | this.m_periodE & 0xFF;
                break;
            }
            case 13: {
                this.m_envelopeType = value & 0xF;
                this._envelopeState = 0;
                this._counterE = 0;
                this._tickE = 0;
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public int getSound() {
        int samples = 1;
        if (this.m_pitchA > 0) {
            this._counterA += samples * this.freqScale;
            if (this._counterA >= this.m_pitchA) {
                this._generatorA = !this._generatorA;
                this._counterA -= this.m_pitchA;
            }
        }
        if (this.m_pitchB > 0) {
            this._counterB += samples * this.freqScale;
            if (this._counterB >= this.m_pitchB) {
                this._generatorB = !this._generatorB;
                this._counterB -= this.m_pitchB;
            }
        }
        if (this.m_pitchC > 0) {
            this._counterC += samples * this.freqScale;
            if (this._counterC >= this.m_pitchC) {
                this._generatorC = !this._generatorC;
                this._counterC -= this.m_pitchC;
            }
        }
        if (this.m_periodN > 0) {
            this._counterN += samples * this.freqScale;
            if (this._counterN >= this.m_periodN << 1) {
                this._counterN -= this.m_periodN << 1;
                this._generatorN = Math.random() >= 0.5;
            }
        }
        int[] envelopeShape = ENVELOPES[this.m_envelopeType];
        int amplitudeE = 0;
        if (this.m_periodE > 0) {
            this._counterE += samples * this.freqScale;
            if (this._counterE >= this.m_periodE << 1) {
                this._counterE -= this.m_periodE << 1;
                ++this._tickE;
                if (this._tickE == 15) {
                    this._tickE = 0;
                    ++this._envelopeState;
                    switch (envelopeShape[this._envelopeState]) {
                        case 4: {
                            --this._envelopeState;
                            break;
                        }
                        case 5: {
                            this._envelopeState = 0;
                            break;
                        }
                        case 6: {
                            break;
                        }
                    }
                }
                switch (envelopeShape[this._envelopeState]) {
                    case 0: {
                        amplitudeE = this._tickE;
                        break;
                    }
                    case 1: {
                        amplitudeE = 15 - this._tickE;
                        break;
                    }
                    case 2: {
                        amplitudeE = 0;
                        break;
                    }
                    case 3: {
                        amplitudeE = 15;
                        break;
                    }
                }
            }
        }
        int amplitudeA = this.m_useEnvelopeA ? amplitudeE : this.m_amplitudeA;
        int amplitudeB = this.m_useEnvelopeB ? amplitudeE : this.m_amplitudeB;
        int amplitudeC = this.m_useEnvelopeC ? amplitudeE : this.m_amplitudeC;
        int val = 0;
        if ((this.m_mixer & 1) == 0 && this._generatorA || (this.m_mixer & 8) == 0 && this._generatorN) {
            val += amplitudeA;
        }
        if ((this.m_mixer & 2) == 0 && this._generatorB || (this.m_mixer & 0x10) == 0 && this._generatorN) {
            val += amplitudeB;
        }
        if ((this.m_mixer & 4) == 0 && this._generatorC || (this.m_mixer & 0x20) == 0 && this._generatorN) {
            val += amplitudeC;
        }
        return val;
    }

    public int getSoundUnsigned() {
        int val = this.getSound();
        val = val * 255 / 45;
        return val;
    }

    public int getSoundSigned() {
        int sound = this.getSound();
        return Math.min(sound * 3, 127);
    }
}

