/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.psg.white;

public class SN76489 {
    private static final int SCALE = 8;
    private int clock;
    private int clockFrac;
    private static final int NO_ANTIALIAS = Integer.MIN_VALUE;
    private final int[] reg;
    private int regLatch;
    private final int[] freqCounter;
    private final int[] freqPolarity;
    private final int[] freqPos;
    private int noiseFreq;
    private int noiseShiftReg;
    private static final int SHIFT_RESET = 32768;
    private static final int FEEDBACK_PATTERN = 9;
    private final int[] outputChannel = new int[4];
    private static final int[] PSG_VOLUME = new int[]{25, 20, 16, 13, 10, 8, 6, 5, 4, 3, 3, 2, 2, 1, 1, 0};

    public SN76489() {
        this.reg = new int[8];
        this.freqCounter = new int[4];
        this.freqPolarity = new int[4];
        this.freqPos = new int[3];
    }

    public void init(int clockSpeed, int sampleRate) {
        this.clock = (clockSpeed << 8) / 16 / sampleRate;
        this.reset();
    }

    public void reset() {
        this.regLatch = 0;
        this.clockFrac = 0;
        this.noiseShiftReg = 32768;
        this.noiseFreq = 16;
        for (int i = 0; i < 4; ++i) {
            this.reg[i << 1] = 1;
            this.reg[(i << 1) + 1] = 15;
            this.freqCounter[i] = 0;
            this.freqPolarity[i] = 1;
            if (i == 3) continue;
            this.freqPos[i] = Integer.MIN_VALUE;
        }
    }

    public final void write(int value) {
        if ((value & 0x80) != 0) {
            this.regLatch = value >> 4 & 7;
            this.reg[this.regLatch] = this.reg[this.regLatch] & 0x3F0 | value & 0xF;
        } else {
            this.reg[this.regLatch] = this.regLatch == 0 || this.regLatch == 2 || this.regLatch == 4 ? this.reg[this.regLatch] & 0xF | (value & 0x3F) << 4 : value & 0xF;
        }
        switch (this.regLatch) {
            case 0: 
            case 2: 
            case 4: {
                if (this.reg[this.regLatch] != 0) break;
                this.reg[this.regLatch] = 1;
                break;
            }
            case 6: {
                this.noiseFreq = 16 << (this.reg[6] & 3);
                this.noiseShiftReg = 32768;
            }
        }
    }

    public final void update(byte[] buffer, int offset, int samplesToGenerate) {
        for (int sample = 0; sample < samplesToGenerate; ++sample) {
            for (int i = 0; i < 3; ++i) {
                this.outputChannel[i] = this.freqPos[i] != Integer.MIN_VALUE ? PSG_VOLUME[this.reg[(i << 1) + 1]] * this.freqPos[i] >> 8 : PSG_VOLUME[this.reg[(i << 1) + 1]] * this.freqPolarity[i];
            }
            this.outputChannel[3] = PSG_VOLUME[this.reg[7]] * (this.noiseShiftReg & 1) << 1;
            int output = this.outputChannel[0] + this.outputChannel[1] + this.outputChannel[2] + this.outputChannel[3];
            if (output > 127) {
                output = 127;
            } else if (output < -128) {
                output = -128;
            }
            buffer[offset + sample] = (byte)output;
            this.clockFrac += this.clock;
            int clockCycles = this.clockFrac >> 8;
            int clockCyclesScaled = clockCycles << 8;
            this.clockFrac -= clockCyclesScaled;
            this.freqCounter[0] = this.freqCounter[0] - clockCycles;
            this.freqCounter[1] = this.freqCounter[1] - clockCycles;
            this.freqCounter[2] = this.freqCounter[2] - clockCycles;
            this.freqCounter[3] = this.noiseFreq == 128 ? this.freqCounter[2] : this.freqCounter[3] - clockCycles;
            for (int i = 0; i < 3; ++i) {
                int counter = this.freqCounter[i];
                if (counter <= 0) {
                    int tone = this.reg[i << 1];
                    if (tone == 0) continue;
                    if (tone > 6) {
                        this.freqPos[i] = (clockCyclesScaled - this.clockFrac + 512 * counter << 8) * this.freqPolarity[i] / (clockCyclesScaled + this.clockFrac);
                        this.freqPolarity[i] = -this.freqPolarity[i];
                    } else {
                        this.freqPolarity[i] = 1;
                        this.freqPos[i] = Integer.MIN_VALUE;
                    }
                    int n = i;
                    this.freqCounter[n] = this.freqCounter[n] + tone * (clockCycles / tone + 1);
                    continue;
                }
                this.freqPos[i] = Integer.MIN_VALUE;
            }
            if (this.freqCounter[3] > 0) continue;
            this.freqPolarity[3] = -this.freqPolarity[3];
            if (this.noiseFreq != 128) {
                this.freqCounter[3] = this.freqCounter[3] + this.noiseFreq * (clockCycles / this.noiseFreq + 1);
            }
            if (this.freqPolarity[3] != 1) continue;
            int feedback = (this.reg[6] & 4) != 0 ? ((this.noiseShiftReg & 9) != 0 && (this.noiseShiftReg & 9 ^ 9) != 0 ? 1 : 0) : this.noiseShiftReg & 1;
            this.noiseShiftReg = this.noiseShiftReg >> 1 | feedback << 15;
        }
    }
}

