/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import omegadrive.SystemLoader;
import omegadrive.bus.md.MdBus;
import omegadrive.bus.md.SvpMapper;
import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.cpu.ssp16.Ssp16;
import omegadrive.cpu.z80.Z80CoreWrapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.input.InputProvider;
import omegadrive.joypad.MdJoypad;
import omegadrive.memory.MemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.sound.fm.ym2612.nukeykt.Ym2612Nuke;
import omegadrive.system.BaseSystem;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.util.MemView;
import omegadrive.vdp.util.UpdatableViewer;
import org.slf4j.Logger;

public class Megadrive
extends BaseSystem<MdMainBusProvider> {
    public static final boolean verbose = false;
    public static final int MCLK_DIVIDER = 7;
    protected static final double VDP_RATIO = 0.5714285714285714;
    protected static final int M68K_DIVIDER = 1;
    public static final double[] vdpVals = new double[]{2.2857142857142856, 2.8571428571428568};
    protected static final int Z80_DIVIDER = 2;
    protected static final int FM_DIVIDER = 6;
    protected static final int SVP_CYCLES = 100;
    protected static final int SVP_RUN_CYCLES = 150;
    static final int SVP_CYCLES_MASK = 99;
    private static final int FAST_FM_DIV = 128;
    private static final int FAST_FM_DIV_MASK = 127;
    private boolean isNuke;
    private static final Logger LOG;
    protected Z80Provider z80;
    protected M68kProvider cpu;
    protected Ssp16 ssp16 = Ssp16.NO_SVP;
    protected UpdatableViewer memView = UpdatableViewer.NO_OP_VIEWER;
    protected boolean hasSvp = this.ssp16 != Ssp16.NO_SVP;
    protected double nextVdpCycle = vdpVals[0];
    protected int next68kCycle = 1;
    protected int nextZ80Cycle = 2;

    protected Megadrive(DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = SystemLoader.SystemType.MD;
    }

    public static SystemProvider createNewInstance(DisplayWindow emuFrame) {
        return new Megadrive(emuFrame);
    }

    @Override
    public void init() {
        super.init();
        this.stateHandler = BaseStateHandler.EMPTY_STATE;
        this.joypad = MdJoypad.create(this);
        this.inputProvider = InputProvider.createInstance(this.joypad);
        this.memory = MemoryProvider.createMdInstance();
        this.bus = this.createBus();
        this.vdp = MdVdpProvider.createVdp((MdMainBusProvider)this.bus);
        this.cpu = MC68000Wrapper.createInstance((MdM68kBusProvider)this.bus);
        this.z80 = Z80CoreWrapper.createInstance(this.getSystemType(), (Z80BusProvider)this.bus);
        this.vdp.addVdpEventListener(this.sound);
        ((MdMainBusProvider)this.bus).attachDevices(this, this.memory, this.joypad, this.vdp, this.cpu, this.z80, this.sound);
        this.reloadWindowState();
        this.createAndAddVdpEventListener();
        SvpMapper.ssp16 = Ssp16.NO_SVP;
        this.memView.reset();
        this.memView = this.createMemView();
        this.isNuke = this.sound.getFm() instanceof Ym2612Nuke;
    }

    @Override
    protected void loop() {
        this.updateVideoMode(true);
        do {
            this.run68k();
            this.runZ80();
            this.runFM();
            if (this.hasSvp) {
                this.runSvp();
            }
            this.runVdp();
            ++this.cycleCounter;
        } while (!this.futureDoneFlag);
    }

    protected final void runVdp() {
        if ((double)this.cycleCounter >= this.nextVdpCycle) {
            int vdpMclk = this.vdp.runSlot();
            this.nextVdpCycle += vdpVals[vdpMclk - 4];
        }
    }

    protected final void run68k() {
        if (this.cycleCounter == this.next68kCycle) {
            boolean isRunning = ((MdMainBusProvider)this.bus).is68kRunning();
            boolean canRun = !this.cpu.isStopped() && isRunning;
            int cycleDelay = 1;
            MdRuntimeData.setAccessTypeExt(BufferUtil.CpuDeviceAccess.M68K);
            if (canRun) {
                cycleDelay = this.cpu.runInstruction() + MdRuntimeData.resetCpuDelayExt();
            }
            if (isRunning) {
                ((MdMainBusProvider)this.bus).handleVdpInterrupts68k();
            }
            cycleDelay = Math.max(1, cycleDelay);
            this.next68kCycle += 1 * cycleDelay;
            assert (MdRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    protected final void runZ80() {
        if (this.cycleCounter == this.nextZ80Cycle) {
            int cycleDelay = 0;
            boolean running = ((MdMainBusProvider)this.bus).isZ80Running();
            if (running) {
                MdRuntimeData.setAccessTypeExt(BufferUtil.CpuDeviceAccess.Z80);
                cycleDelay = this.z80.executeInstruction();
                ((MdMainBusProvider)this.bus).handleVdpInterruptsZ80();
                cycleDelay += MdRuntimeData.resetCpuDelayExt();
            }
            cycleDelay = Math.max(1, cycleDelay);
            this.nextZ80Cycle += 2 * cycleDelay;
            assert (MdRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    protected final void runFM() {
        if (this.isNuke) {
            if ((this.cycleCounter & 1) == 0 && this.cycleCounter % 6 == 0) {
                ((MdMainBusProvider)this.bus).getFm().tick();
            }
        } else if ((this.cycleCounter & 0x7F) == 0) {
            ((MdMainBusProvider)this.bus).getFm().tick();
        }
    }

    protected final void runSvp() {
        if ((this.cycleCounter & 0x63) == 0) {
            this.ssp16.ssp1601_run(150);
        }
    }

    protected MdMainBusProvider createBus() {
        return new MdBus();
    }

    @Override
    protected void updateVideoMode(boolean force) {
        if (force || this.displayContext.videoMode != this.vdp.getVideoMode()) {
            this.displayContext.videoMode = this.vdp.getVideoMode();
            double microsPerTick = this.getMicrosPerTick();
            microsPerTick = !this.isNuke ? microsPerTick * 128.0 / 6.0 : microsPerTick;
            this.sound.getFm().setMicrosPerTick(microsPerTick);
            this.targetNs = (long)(this.getRegion().getFrameIntervalMs() * (double)Util.MILLI_IN_NS);
            LOG.info("Video mode changed: {}, microsPerTick: {}", (Object)this.displayContext.videoMode, (Object)microsPerTick);
        }
    }

    protected double getMicrosPerTick() {
        double mclkhz = this.displayContext.videoMode.isPal() ? 5.3203424E7 : 5.3693175E7;
        return 1000000.0 / (mclkhz / 42.0);
    }

    @Override
    public void newFrame() {
        this.checkSvp();
        this.memView.update();
        super.newFrame();
    }

    private void checkSvp() {
        this.ssp16 = SvpMapper.ssp16;
        this.hasSvp = this.ssp16 != Ssp16.NO_SVP;
    }

    protected UpdatableViewer createMemView() {
        return MemView.createInstance((MdMainBusProvider)this.bus, this.vdp.getVdpMemory());
    }

    @Override
    protected void resetCycleCounters(int counter) {
        assert (this.nextZ80Cycle >= counter && this.next68kCycle >= counter && this.nextVdpCycle + 1.0 >= (double)counter);
        this.nextZ80Cycle = Math.max(1, this.nextZ80Cycle - counter);
        this.next68kCycle = Math.max(1, this.next68kCycle - counter);
        this.nextVdpCycle = Math.max(1.0, this.nextVdpCycle - (double)counter);
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.cpu.reset();
        this.z80.reset();
    }

    @Override
    protected void handleSoftReset() {
        if (this.softResetPending) {
            this.cpu.softReset();
            this.z80.reset();
        }
        super.handleSoftReset();
    }

    static {
        BufferUtil.assertPowerOf2Minus1("FAST_FM_DIV_MASK", 127);
        LOG = LogHelper.getLogger(Megadrive.class.getSimpleName());
    }
}

