/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import omegadrive.SystemLoader;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.bus.z80.SmsBus;
import omegadrive.cpu.z80.Z80CoreWrapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.input.InputProvider;
import omegadrive.joypad.TwoButtonsJoypad;
import omegadrive.memory.MemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.system.BaseSystem;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.vdp.SmsVdp;
import org.slf4j.Logger;

public class Sms
extends BaseSystem<Z80BusProvider> {
    public static final boolean ENABLE_FM = Boolean.parseBoolean(System.getProperty("sms.enable.fm", "false"));
    private static final Logger LOG = LogHelper.getLogger(Sms.class.getSimpleName());
    public static final int MCLK_PAL = 53203424;
    public static final int MCLK_NTSC = 53693175;
    public static final int VDP_CLK_NTSC = 10738635;
    public static final int VDP_CLK_PAL = 10640684;
    protected static final int VDP_DIVIDER = 2;
    protected static final int Z80_DIVIDER = 3;
    protected static final int FM_DIVIDER = 216;
    protected Z80Provider z80;
    int nextZ80Cycle = 3;
    int nextVdpCycle = 2;

    protected Sms(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = systemType;
    }

    public static SystemProvider createNewInstance(SystemLoader.SystemType systemType, DisplayWindow emuFrame) {
        return new Sms(systemType, emuFrame);
    }

    private void initCommon() {
        this.inputProvider = InputProvider.createInstance(this.joypad);
        this.vdp = new SmsVdp(this);
        this.z80 = Z80CoreWrapper.createInstance(this.systemType, (Z80BusProvider)this.bus);
        this.vdp.addVdpEventListener(this.sound);
        ((Z80BusProvider)this.bus).attachDevices(this, this.memory, this.joypad, this.vdp, this.sound, this.z80);
        this.reloadWindowState();
        this.createAndAddVdpEventListener();
    }

    @Override
    public void init() {
        super.init();
        this.stateHandler = BaseStateHandler.EMPTY_STATE;
        this.joypad = new TwoButtonsJoypad();
        this.memory = MemoryProvider.createSmsInstance();
        this.bus = new SmsBus();
        SmsBus.HW_ENABLE_FM = ENABLE_FM;
        this.initCommon();
    }

    @Override
    protected void loop() {
        double frameMs = this.systemType == SystemLoader.SystemType.GG ? RegionDetector.Region.USA.getFrameIntervalMs() : this.mediaSpec.getRegion().getFrameIntervalMs();
        this.targetNs = (long)(frameMs * (double)Util.MILLI_IN_NS);
        do {
            this.runZ80(this.cycleCounter);
            this.runVdp(this.cycleCounter);
            if (ENABLE_FM) {
                this.runFM(this.cycleCounter);
            }
            ++this.cycleCounter;
        } while (!this.runningRomFuture.isDone());
    }

    @Override
    protected void updateVideoMode(boolean force) {
        this.displayContext.videoMode = this.vdp.getVideoMode();
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.z80.reset();
        this.vdp.reset();
    }

    @Override
    protected void resetCycleCounters(int counter) {
        this.nextZ80Cycle -= counter;
        this.nextVdpCycle -= counter;
    }

    protected void runVdp(long counter) {
        if (counter == (long)this.nextVdpCycle) {
            this.vdp.runSlot();
            this.nextVdpCycle += 2;
        }
    }

    protected void runZ80(long counter) {
        if (counter == (long)this.nextZ80Cycle) {
            int cycleDelay = this.z80.executeInstruction();
            this.handleMaskableInterrupts();
            cycleDelay = Math.max(1, cycleDelay);
            this.nextZ80Cycle += 3 * cycleDelay;
        }
    }

    protected void runFM(int counter) {
        if ((counter + 1) % 216 == 0) {
            this.sound.getFm().tick();
        }
    }

    private void handleMaskableInterrupts() {
        ((Z80BusProvider)this.bus).handleInterrupts(Z80Provider.Interrupt.IM1);
    }

    private void handleNmi() {
        ((Z80BusProvider)this.bus).handleInterrupts(Z80Provider.Interrupt.NMI);
    }
}

