/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mcd.MegaCd;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.model.BaseBusProvider;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.fm.MdFmProvider;
import omegadrive.sound.fm.ym2413.Ym2413Provider;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.Megadrive;
import omegadrive.system.Sms;
import omegadrive.system.SystemProvider;
import omegadrive.system.Z80BaseSystem;
import omegadrive.system.gb.Gb;
import omegadrive.system.gb.GbSoundWrapper;
import omegadrive.system.nes.Nes;
import omegadrive.system.nes.NesSoundWrapper;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Size;
import omegadrive.vdp.model.BaseVdpAdapter;
import omegadrive.vdp.model.BaseVdpProvider;
import org.slf4j.Logger;
import s32x.Md32x;
import s32x.MegaCd32x;
import s32x.pwm.BlipPwmProvider;
import s32x.pwm.Pwm;
import s32x.pwm.S32xPwmProvider;

public class SysUtil {
    private static final Logger LOG = LogHelper.getLogger(SysUtil.class.getSimpleName());
    public static final String SMD_INTERLEAVED_EXT = ".smd";
    public static final Map<SystemLoader.SystemType, String[]> sysFileExtensionsMap = ImmutableMap.builder().put((Object)SystemLoader.SystemType.MD, (Object)new String[]{".md", ".bin", ".smd"}).put((Object)SystemLoader.SystemType.S32X, (Object)new String[]{".32x", ".bin", ".md"}).put((Object)SystemLoader.SystemType.MEGACD, (Object)new String[]{".cue", ".bin", ".iso"}).put((Object)SystemLoader.SystemType.MEGACD_S32X, (Object)new String[]{".cue", ".bin", ".iso", ".32x"}).put((Object)SystemLoader.SystemType.SG_1000, (Object)new String[]{".sg", ".sc"}).put((Object)SystemLoader.SystemType.COLECO, (Object)new String[]{".col"}).put((Object)SystemLoader.SystemType.MSX, (Object)new String[]{".rom"}).put((Object)SystemLoader.SystemType.SMS, (Object)new String[]{".sms"}).put((Object)SystemLoader.SystemType.GG, (Object)new String[]{".gg"}).put((Object)SystemLoader.SystemType.NES, (Object)new String[]{".nes"}).put((Object)SystemLoader.SystemType.GB, (Object)new String[]{".gb"}).build();
    public static final String[] compressedBinaryTypes = new String[]{".gz", ".zip"};
    public static final Set<String> binaryTypesSet;
    public static final String[] binaryTypes;
    public static final BaseBusProvider NO_OP_BUS;
    public static final BaseVdpProvider NO_OP_VDP_PROVIDER;

    public static SystemProvider createSystemProvider(MediaSpecHolder romSpec, DisplayWindow display) {
        MediaSpecHolder.MediaSpec mediaSpec = romSpec.getBootableMedia();
        String lcName = mediaSpec.romFile.getFileName().toString().toLowerCase();
        String lowerCaseName = SystemLoader.handleCompressedFiles(mediaSpec.romFile, lcName);
        if (lowerCaseName == null) {
            LOG.error("Unable to load file: {}", (Object)romSpec);
            return null;
        }
        SystemLoader.SystemType type = romSpec.systemType;
        if (type == SystemLoader.SystemType.NONE) {
            for (Map.Entry<SystemLoader.SystemType, String[]> entry : sysFileExtensionsMap.entrySet()) {
                boolean isMatch = Arrays.stream(entry.getValue()).anyMatch(lowerCaseName::endsWith);
                if (!isMatch) continue;
                type = entry.getKey();
                break;
            }
        }
        romSpec.systemType = type;
        romSpec.reload();
        SystemProvider systemProvider = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SystemLoader.SystemType.MD -> Megadrive.createNewInstance(display);
            case SystemLoader.SystemType.MEGACD -> MegaCd.createNewInstance(display);
            case SystemLoader.SystemType.S32X -> Md32x.createNewInstance32x(display);
            case SystemLoader.SystemType.MEGACD_S32X -> MegaCd32x.createNewInstance(display);
            case SystemLoader.SystemType.SG_1000 -> Z80BaseSystem.createNewInstance(SystemLoader.SystemType.SG_1000, display);
            case SystemLoader.SystemType.COLECO -> Z80BaseSystem.createNewInstance(SystemLoader.SystemType.COLECO, display);
            case SystemLoader.SystemType.MSX -> Z80BaseSystem.createNewInstance(SystemLoader.SystemType.MSX, display);
            case SystemLoader.SystemType.SMS -> Sms.createNewInstance(SystemLoader.SystemType.SMS, display);
            case SystemLoader.SystemType.GG -> Sms.createNewInstance(SystemLoader.SystemType.GG, display);
            case SystemLoader.SystemType.NES -> Nes.createNewInstance(SystemLoader.SystemType.NES, display);
            case SystemLoader.SystemType.GB -> Gb.createNewInstance(SystemLoader.SystemType.GB, display);
            case SystemLoader.SystemType.NONE -> {
                LOG.error("Unable to find a system to load: {}", (Object)romSpec);
                yield null;
            }
        };
        return systemProvider;
    }

    public static Map<SoundDevice.SoundDeviceType, SoundDevice> getSoundDevices(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        EnumMap<SoundDevice.SoundDeviceType, SoundDevice> m = new EnumMap<SoundDevice.SoundDeviceType, SoundDevice>(SoundDevice.SoundDeviceType.class);
        m.put(SoundDevice.SoundDeviceType.PSG, SysUtil.getPsgProvider(systemType, region));
        m.put(SoundDevice.SoundDeviceType.FM, SysUtil.getFmProvider(systemType, region));
        m.put(SoundDevice.SoundDeviceType.PWM, SysUtil.getPwmProvider(systemType, region));
        m.put(SoundDevice.SoundDeviceType.PCM, SysUtil.getPcmProvider(systemType, region));
        return m;
    }

    public static SoundDevice getPwmProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        return switch (systemType) {
            case SystemLoader.SystemType.S32X -> {
                if (Pwm.PWM_USE_BLIP) {
                    yield new BlipPwmProvider(region);
                }
                yield new S32xPwmProvider(region);
            }
            default -> PwmProvider.NO_SOUND;
        };
    }

    public static SoundDevice getPcmProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        switch (systemType) {
            default: 
        }
        return PcmProvider.NO_SOUND;
    }

    public static SoundDevice getPsgProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        PsgProvider psgProvider = PsgProvider.NO_SOUND;
        switch (systemType) {
            case MSX: {
                psgProvider = PsgProvider.createAyInstance(region, SoundProvider.SAMPLE_RATE_HZ);
                break;
            }
            case NES: 
            case GB: {
                break;
            }
            default: {
                psgProvider = PsgProvider.createSnInstance(region, SoundProvider.SAMPLE_RATE_HZ);
            }
        }
        return psgProvider;
    }

    public static SoundDevice getFmProvider(SystemLoader.SystemType systemType, RegionDetector.Region region) {
        FmProvider fmProvider = FmProvider.NO_SOUND;
        switch (systemType) {
            case MEGACD_S32X: {
                fmProvider = MdFmProvider.createFastInstance(region, AbstractSoundManager.audioFormat);
                break;
            }
            case MD: 
            case MEGACD: 
            case S32X: {
                fmProvider = MdFmProvider.createInstance(region, AbstractSoundManager.audioFormat);
                break;
            }
            case SMS: {
                if (!Sms.ENABLE_FM) break;
                fmProvider = Ym2413Provider.createInstance(AbstractSoundManager.audioFormat);
                break;
            }
            case NES: {
                fmProvider = new NesSoundWrapper(region);
                break;
            }
            case GB: {
                fmProvider = new GbSoundWrapper(region);
                break;
            }
        }
        return fmProvider;
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        sysFileExtensionsMap.values().stream().flatMap(v -> Arrays.stream(v)).forEach(arg_0 -> ((ImmutableSet.Builder)b).add(arg_0));
        Arrays.stream(compressedBinaryTypes).forEach(arg_0 -> ((ImmutableSet.Builder)b).add(arg_0));
        binaryTypesSet = b.build();
        binaryTypes = (String[])binaryTypesSet.toArray(String[]::new);
        NO_OP_BUS = new BaseBusProvider(){

            @Override
            public int read(int address, Size size) {
                return 0;
            }

            @Override
            public void write(int address, int data, Size size) {
            }

            @Override
            public BaseBusProvider attachDevice(Device device) {
                return null;
            }

            @Override
            public <T extends Device> Optional<T> getBusDeviceIfAny(Class<T> clazz) {
                return Optional.empty();
            }

            @Override
            public <T extends Device> Set<T> getAllDevices(Class<T> clazz) {
                return Collections.emptySet();
            }
        };
        NO_OP_VDP_PROVIDER = new BaseVdpAdapter();
    }

    public static enum RomFileType {
        UNKNOWN,
        BIN_CUE,
        ISO,
        CART_ROM;


        public boolean isDiscImage() {
            return this == BIN_CUE || this == ISO;
        }
    }
}

