/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system;

import java.nio.file.Path;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.system.MediaSpecHolder;
import omegadrive.util.RegionDetector;

public interface SystemProvider
extends Device {
    public static final SystemClock NO_CLOCK = new SystemClock(){

        @Override
        public int getCycleCounter() {
            return 0;
        }

        @Override
        public long getFrameCounter() {
            return 0L;
        }
    };

    public void handleSystemEvent(SystemEvent var1, Object var2);

    public boolean isRomRunning();

    public MediaSpecHolder getMediaSpec();

    public SystemLoader.SystemType getSystemType();

    default public RegionDetector.Region getRegion() {
        return this.getMediaSpec().getRegion();
    }

    default public int getRegionCode() {
        return this.getRegion().getVersionCode();
    }

    default public Path getRomPath() {
        return this.getMediaSpec().getBootableMedia().romFile;
    }

    public static interface SystemClock {
        public int getCycleCounter();

        public long getFrameCounter();
    }

    public static interface NewFrameListener {
        public void newFrame();
    }

    public static enum SystemEvent {
        NONE,
        NEW_ROM,
        CLOSE_ROM,
        CLOSE_APP,
        RESET,
        LOAD_STATE,
        SAVE_STATE,
        QUICK_SAVE,
        QUICK_LOAD,
        TOGGLE_PAUSE,
        SOUND_ENABLED,
        TOGGLE_FULL_SCREEN,
        TOGGLE_THROTTLE,
        CONTROLLER_CHANGE,
        SHOW_FPS,
        TOGGLE_SOUND_RECORD,
        SOFT_RESET,
        PAD_SETUP_CHANGE,
        FORCE_PAD_TYPE;

    }
}

