/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

public class ArrayEndianUtil {
    public static final int MASK_16BIT = 65535;

    public static int getUInt32LE(byte ... bytes) {
        int value = bytes[0] & 0xFF;
        value = bytes.length > 1 ? value | (bytes[1] & 0xFF) << 8 : value;
        value = bytes.length > 2 ? value | (bytes[2] & 0xFF) << 16 : value;
        value = bytes.length > 3 ? value | (bytes[3] & 0xFF) << 24 : value;
        return value;
    }

    public static int getUInt32LE(int ... bytes) {
        int value = bytes[0] & 0xFF;
        value = bytes.length > 1 ? value | (bytes[1] & 0xFF) << 8 : value;
        value = bytes.length > 2 ? value | (bytes[2] & 0xFF) << 16 : value;
        value = bytes.length > 3 ? value | (bytes[3] & 0xFF) << 24 : value;
        return value;
    }

    public static void setWordFromBytesBE(byte[] src, int[] data, int srcIndex, int destIndex) {
        data[destIndex] = ((src[srcIndex] & 0xFF) << 8 | src[srcIndex + 1] & 0xFF) & 0xFFFF;
    }

    public static void setUInt32LE(int value, int[] data, int startIndex) {
        data[startIndex + 3] = value >> 24 & 0xFF;
        data[startIndex + 2] = value >> 16 & 0xFF;
        data[startIndex + 1] = value >> 8 & 0xFF;
        data[startIndex] = value & 0xFF;
    }

    public static void setUInt32LE(int value, byte[] data, int startIndex) {
        data[startIndex + 3] = (byte)(value >> 24 & 0xFF);
        data[startIndex + 2] = (byte)(value >> 16 & 0xFF);
        data[startIndex + 1] = (byte)(value >> 8 & 0xFF);
        data[startIndex] = (byte)(value & 0xFF);
    }

    public static int[] toUnsignedIntArray(byte[] bytes) {
        int[] data = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            data[i] = bytes[i] & 0xFF;
        }
        return data;
    }

    public static int[] toSignedIntArray(byte[] bytes) {
        int[] data = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            data[i] = bytes[i];
        }
        return data;
    }

    public static byte[] unsignedToByteArray(int[] bytes) {
        return ArrayEndianUtil.toByteArray(bytes, false);
    }

    public static byte[] signedToByteArray(int[] bytes) {
        return ArrayEndianUtil.toByteArray(bytes, true);
    }

    private static byte[] toByteArray(int[] bytes, boolean signed) {
        int min = signed ? -128 : 0;
        int max = signed ? 127 : 255;
        byte[] data = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            data[i] = (byte)(bytes[i] & 0xFF);
            if (bytes[i] >= min && bytes[i] <= max) continue;
            throw new IllegalArgumentException("Invalid value at pos " + i + ", it doesn't represent a byte: " + bytes[i]);
        }
        return data;
    }

    public static int getByteInWordBE(int word, int bytePos) {
        return word >> ((~bytePos & 1) << 3) & 0xFF;
    }

    public static int setByteInWordBE(int word, int byteVal, int bytePos) {
        int shift = (~bytePos & 1) << 3;
        return word & ~(255 << shift) | (byteVal & 0xFF) << shift;
    }

    public static int setNibbleInByteBE(int byteVal, int nibbleVal, int nibblePos) {
        assert (nibblePos < 2 && byteVal == (byte)byteVal);
        int shift = (~nibblePos & 1) << 2;
        return byteVal & ~(15 << shift) | (nibbleVal & 0xF) << shift;
    }

    public static int getNibbleInByteBE(int byteVal, int nibblePos) {
        return byteVal >> ((~nibblePos & 1) << 2) & 0xF;
    }

    public static void setSigned16LE(short value, byte[] data, int startIndex) {
        data[startIndex] = (byte)value;
        data[startIndex + 1] = (byte)(value >> 8);
    }
}

